package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.app.Application;
import android.net.Uri;
import android.os.Handler;
import android.view.View;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.dayouzc.e2e.core.E2EAppClientNewContext;
import com.dayouzc.e2e.core.view.MyXwalkview;
import org.xwalk.core.JavascriptInterface;
import org.xwalk.core.XWalkPreferences;
import org.xwalk.core.XWalkUIClient;
import org.xwalk.core.XWalkView;
import org.xwalk.core.internal.XWalkSettingsInternal;
import org.xwalk.core.internal.XWalkViewBridge;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 *  WebView统一设置工具类
 *
 * @author tyutNo4
 * @date 2018/07/26
 */
public class WebViewUtils {

    /**
     * 统一设置WebView
     * @param webView  WebView对象
     * @param url       加载URL
     */
    @SuppressLint("JavascriptInterface")
    public static void setWebView(WebView webView, String url, Application application, Handler handler) {

        webView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
        //设置WebView属性，能够执行Javascript脚本
        webView.getSettings().setJavaScriptEnabled(true);
        //支持缩放
        webView.getSettings().setSupportZoom(true);
        webView.getSettings().setDisplayZoomControls(false);
        //将图片调整到适合webview的大小
        webView.getSettings().setUseWideViewPort(true);
        //设置可以访问文件
        webView.getSettings().setAllowFileAccess(true);
        //设置支持缩放
        webView.getSettings().setBuiltInZoomControls(true);
        // 支持内容重新布局
        webView.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        // 缩放至屏幕的大小
        webView.getSettings().setLoadWithOverviewMode(true);
        //支持自动加载图片
        webView.getSettings().setLoadsImagesAutomatically(true);

        String user  = webView.getSettings().getUserAgentString()+";webview_android;youpie";
        webView.getSettings().setUserAgentString(user);
        webView.addJavascriptInterface(new JsInterface(application, handler), "OpenManagerInterface");
        webView.loadUrl(url);

        webView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
    }

    /**
     * 统一设置XWalkView
     * @param mXwalkView    WebView对象
     * @param url            加载URL
     * @param application   Application
     */
    public static void setXWalkView(MyXwalkview mXwalkView, String url, Application application, Handler handler) {

        //TODO mXwalkView长按崩溃  暂时这么解决
        mXwalkView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {

                return true;
            }
        });

        //添加对javascript支持
        XWalkPreferences.setValue("enable-javascript", true);
        //开启调式,支持谷歌浏览器调式
        XWalkPreferences.setValue(XWalkPreferences.REMOTE_DEBUGGING, true);
        //置是否允许通过file url加载的Javascript可以访问其他的源,包括其他的文件和http,https等其他的源
        XWalkPreferences.setValue(XWalkPreferences.ALLOW_UNIVERSAL_ACCESS_FROM_FILE, true);
        //JAVASCRIPT_CAN_OPEN_WINDOW
        XWalkPreferences.setValue(XWalkPreferences.JAVASCRIPT_CAN_OPEN_WINDOW, true);
        // enable multiple windows.
        XWalkPreferences.setValue(XWalkPreferences.SUPPORT_MULTIPLE_WINDOWS, true);
        // enable multiple windows.
        XWalkPreferences.setValue(XWalkPreferences.PROFILE_NAME, true);

        mXwalkView.addJavascriptInterface(new JsInterface(application, handler), "OpenManagerInterface");

        mXwalkView.setUIClient(new MyUIClient(mXwalkView));
        try {
            Method _getBridge = XWalkView.class.getDeclaredMethod("getBridge");
            _getBridge.setAccessible(true);
            XWalkViewBridge xWalkViewBridge = null;
            xWalkViewBridge = (XWalkViewBridge) _getBridge.invoke(mXwalkView);
            XWalkSettingsInternal xWalkSettings = xWalkViewBridge.getSettings();
            xWalkSettings.setJavaScriptEnabled(true);

            xWalkSettings.setAllowFileAccess(true);
            xWalkSettings.setAllowFileAccessFromFileURLs(false);
            xWalkSettings.setAllowUniversalAccessFromFileURLs(false);
            xWalkSettings.setAllowScriptsToCloseWindows(true);
            xWalkSettings.setAppCacheEnabled(true);
            xWalkSettings.setDatabaseEnabled(true);
            xWalkSettings.setDomStorageEnabled(true);
            xWalkSettings.setSaveFormData(true);
            xWalkSettings.setJavaScriptCanOpenWindowsAutomatically(true);
            xWalkSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
            xWalkSettings.setLoadsImagesAutomatically(true);
            String user  = mXwalkView.getSettings().getUserAgentString()+";webview_android;youpie";
            xWalkSettings.setUserAgentString(user);

            mXwalkView.load(url, null);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    // TODO: 2019/7/29 临时修改 ua修改为 谷歌浏览器
    /**
     * 统一设置XWalkView 设置UA为 谷歌浏览器
     * @param mXwalkView    WebView对象
     * @param url            加载URL
     * @param application   Application
     */
    public static void setXWalkViewForWin(MyXwalkview mXwalkView, String url, Application application, Handler handler) {

        //TODO mXwalkView长按崩溃  暂时这么解决
        mXwalkView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {

                return true;
            }
        });

        //添加对javascript支持
        XWalkPreferences.setValue("enable-javascript", true);
        //开启调式,支持谷歌浏览器调式
        XWalkPreferences.setValue(XWalkPreferences.REMOTE_DEBUGGING, true);
        //置是否允许通过file url加载的Javascript可以访问其他的源,包括其他的文件和http,https等其他的源
        XWalkPreferences.setValue(XWalkPreferences.ALLOW_UNIVERSAL_ACCESS_FROM_FILE, true);
        //JAVASCRIPT_CAN_OPEN_WINDOW
        XWalkPreferences.setValue(XWalkPreferences.JAVASCRIPT_CAN_OPEN_WINDOW, true);
        // enable multiple windows.
        XWalkPreferences.setValue(XWalkPreferences.SUPPORT_MULTIPLE_WINDOWS, true);
        // enable multiple windows.
        XWalkPreferences.setValue(XWalkPreferences.PROFILE_NAME, true);

        mXwalkView.addJavascriptInterface(new JsInterface(application, handler), "OpenManagerInterface");

        mXwalkView.setUIClient(new MyUIClient(mXwalkView));
        try {
            Method _getBridge = XWalkView.class.getDeclaredMethod("getBridge");
            _getBridge.setAccessible(true);
            XWalkViewBridge xWalkViewBridge = null;
            xWalkViewBridge = (XWalkViewBridge) _getBridge.invoke(mXwalkView);
            XWalkSettingsInternal xWalkSettings = xWalkViewBridge.getSettings();
            xWalkSettings.setJavaScriptEnabled(true);

            xWalkSettings.setAllowFileAccess(true);
            xWalkSettings.setAllowFileAccessFromFileURLs(false);
            xWalkSettings.setAllowUniversalAccessFromFileURLs(false);
            xWalkSettings.setAllowScriptsToCloseWindows(true);
            xWalkSettings.setAppCacheEnabled(true);
            xWalkSettings.setDatabaseEnabled(true);
            xWalkSettings.setDomStorageEnabled(true);
            xWalkSettings.setSaveFormData(true);
            xWalkSettings.setJavaScriptCanOpenWindowsAutomatically(true);
            xWalkSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
            xWalkSettings.setLoadsImagesAutomatically(true);
            String user  = mXwalkView.getSettings().getUserAgentString()+";Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.94 Safari/537.36";
            xWalkSettings.setUserAgentString(user);

            mXwalkView.load(url, null);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    // TODO: 2019/7/29 临时修改 ua修改为 谷歌浏览器
    /**
     * 统一设置XWalkView  设置UA为手机浏览器
     * @param mXwalkView    WebView对象
     * @param url            加载URL
     * @param application   Application
     */
    public static void setXWalkViewForPhone(MyXwalkview mXwalkView, String url, Application application, Handler handler) {

        //TODO mXwalkView长按崩溃  暂时这么解决
        mXwalkView.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {

                return true;
            }
        });

        //添加对javascript支持
        XWalkPreferences.setValue("enable-javascript", true);
        //开启调式,支持谷歌浏览器调式
        XWalkPreferences.setValue(XWalkPreferences.REMOTE_DEBUGGING, true);
        //置是否允许通过file url加载的Javascript可以访问其他的源,包括其他的文件和http,https等其他的源
        XWalkPreferences.setValue(XWalkPreferences.ALLOW_UNIVERSAL_ACCESS_FROM_FILE, true);
        //JAVASCRIPT_CAN_OPEN_WINDOW
        XWalkPreferences.setValue(XWalkPreferences.JAVASCRIPT_CAN_OPEN_WINDOW, true);
        // enable multiple windows.
        XWalkPreferences.setValue(XWalkPreferences.SUPPORT_MULTIPLE_WINDOWS, true);
        // enable multiple windows.
        XWalkPreferences.setValue(XWalkPreferences.PROFILE_NAME, true);

        mXwalkView.addJavascriptInterface(new JsInterface(application, handler), "OpenManagerInterface");

        mXwalkView.setUIClient(new MyUIClient(mXwalkView));
        try {
            Method _getBridge = XWalkView.class.getDeclaredMethod("getBridge");
            _getBridge.setAccessible(true);
            XWalkViewBridge xWalkViewBridge = null;
            xWalkViewBridge = (XWalkViewBridge) _getBridge.invoke(mXwalkView);
            XWalkSettingsInternal xWalkSettings = xWalkViewBridge.getSettings();
            xWalkSettings.setJavaScriptEnabled(true);

            xWalkSettings.setAllowFileAccess(true);
            xWalkSettings.setAllowFileAccessFromFileURLs(false);
            xWalkSettings.setAllowUniversalAccessFromFileURLs(false);
            xWalkSettings.setAllowScriptsToCloseWindows(true);
            xWalkSettings.setAppCacheEnabled(true);
            xWalkSettings.setDatabaseEnabled(true);
            xWalkSettings.setDomStorageEnabled(true);
            xWalkSettings.setSaveFormData(true);
            xWalkSettings.setJavaScriptCanOpenWindowsAutomatically(true);
            xWalkSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
            xWalkSettings.setLoadsImagesAutomatically(true);
            String user  = mXwalkView.getSettings().getUserAgentString()+";Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_3_2 like Mac OS X; en-us) AppleWebKit/533.17.9 (KHTML, like Gecko) Version/5.0.2 Mobile/8H7 Safari/6533.18.5 Quark/2.4.2.986";
            xWalkSettings.setUserAgentString(user);

            mXwalkView.load(url, null);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static class MyUIClient extends XWalkUIClient {
        MyUIClient(XWalkView view) {
            super(view);
        }

        @Override
        public void onPageLoadStarted(XWalkView view, String url) {
            super.onPageLoadStarted(view, url);
        }

        @Override
        public void onPageLoadStopped(XWalkView view, String url, LoadStatus status) {
            //取消计时
            super.onPageLoadStopped(view, url, status);
        }

        @Override
        public void openFileChooser(XWalkView view, ValueCallback<Uri> uploadFile, String acceptType, String capture) {
            super.openFileChooser(view, uploadFile, acceptType, capture);
        }
    }

    private static class JsInterface {
        Application application;
        Handler handler;

        public JsInterface() {

        }

        public JsInterface(Application application, Handler handler) {
            this.application = application;
            this.handler = handler;
        }

        @JavascriptInterface
        public void previewDoc(String docUrl) {
            DownLoadUtils.downFile(docUrl, handler);
        }

        @JavascriptInterface
        public String getAccountInfo() {
            String info = LoginUtils.getAccountInfo();
            return info;
        }

        @JavascriptInterface
        public String getEquipInfo() {
            String info = LoginUtils.getEquipInfo();
            return info;
        }

        @JavascriptInterface
        public String getToken() {
            return E2EAppClientNewContext.getToken();
        }

        @JavascriptInterface
        public void  notifyException(String errorCode, String msg) {
            try {
                throw new Exception("错误码:"+errorCode +"错误信息:"+msg);
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }



}
