/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public final class SysEnvUtils {
    private static final String TAG = SysEnvUtils.class.getSimpleName();
    private static final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    private static Context context;
    public static final String MODEL_NUMBER;
    public static final String DISPLAY_NAME;
    public static final String OS_VERSION;
    public static final String APP_VERSION;
    public static final int SCREEN_WIDTH;
    public static final int SCREEN_HEIGHT;
    public static final String ACTIVITY_DTO_KEY = "ACTIVITY_DTO_KEY";

    @SuppressLint(value={"MissingPermission"})
    public static String getPhoneNumber(Application application) {
        if (context == null) {
            context = application;
        }
        return ((TelephonyManager)context.getSystemService("phone")).getLine1Number();
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getDeviceId(Application application) {
        if (context == null) {
            context = application;
        }
        return ((TelephonyManager)context.getSystemService("phone")).getDeviceId();
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getIMEI(Application application) {
        if (context == null) {
            context = application;
        }
        return ((TelephonyManager)context.getSystemService("phone")).getSimSerialNumber();
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getIMSI(Application application) {
        if (context == null) {
            context = application;
        }
        return ((TelephonyManager)context.getSystemService("phone")).getSubscriberId();
    }

    public static DisplayMetrics getDisplayMetrics() {
        WindowManager windowMgr = (WindowManager)context.getSystemService("window");
        windowMgr.getDefaultDisplay().getMetrics(mDisplayMetrics);
        return mDisplayMetrics;
    }

    public static List<Camera.Size> getSupportedPreviewSizes(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List sizeList = parameters.getSupportedPreviewSizes();
        return sizeList;
    }

    public static String getVersion() {
        PackageManager manager = context.getPackageManager();
        PackageInfo info = null;
        try {
            info = manager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("\u83b7\u53d6\u5e94\u7528\u7a0b\u5e8f\u7248\u672c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage()));
            return "";
        }
        return info.versionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getKernelVersion() {
        String strVersion = "";
        FileReader mFileReader = null;
        BufferedReader mBufferedReader = null;
        try {
            mFileReader = new FileReader("/proc/version");
            mBufferedReader = new BufferedReader(mFileReader, 8192);
            String str2 = mBufferedReader.readLine();
            strVersion = str2.split("\\s+")[2];
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("\u83b7\u53d6\u7cfb\u7edf\u5185\u6838\u7248\u672c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage()));
        }
        finally {
            try {
                mBufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return strVersion;
    }

    public static String getMacAddress() {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo.getMacAddress() != null) {
            return wifiInfo.getMacAddress();
        }
        return "";
    }

    public static long getRunTimes() {
        long ut = SystemClock.elapsedRealtime() / 1000L;
        if (ut == 0L) {
            ut = 1L;
        }
        return ut;
    }

    static {
        MODEL_NUMBER = Build.MODEL;
        DISPLAY_NAME = Build.DISPLAY;
        OS_VERSION = Build.VERSION.RELEASE;
        APP_VERSION = SysEnvUtils.getVersion();
        SCREEN_WIDTH = SysEnvUtils.getDisplayMetrics().widthPixels;
        SCREEN_HEIGHT = SysEnvUtils.getDisplayMetrics().heightPixels;
    }
}

