/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.Log;

public class NetWorkUtils {
    @SuppressLint(value={"MissingPermission"})
    public static boolean isOpenWifi(Context context) {
        WifiManager connectivityManager = (WifiManager)context.getSystemService("wifi");
        return connectivityManager.isWifiEnabled();
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isConnected(Context context) {
        boolean bisConnFlag = false;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo network = connectivityManager.getActiveNetworkInfo();
        if (network != null) {
            bisConnFlag = connectivityManager.getActiveNetworkInfo().isAvailable();
        }
        return bisConnFlag;
    }

    public static boolean isWifi(Context context) {
        boolean isWifi;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (!NetWorkUtils.isConnected(context)) {
            Log.i((String)"NetStatus", (String)"\u5f53\u524d\u7f51\u7edc----->\u4e0d\u53ef\u7528");
            return false;
        }
        boolean bl = isWifi = connectivityManager.getActiveNetworkInfo().getType() == 1;
        if (isWifi) {
            Log.i((String)"NetStatus", (String)"\u5f53\u524d\u7f51\u7edc----->WIFI\u73af\u5883");
        } else {
            Log.i((String)"NetStatus", (String)"\u5f53\u524d\u7f51\u7edc----->\u975eWIFI\u73af\u5883");
        }
        return isWifi;
    }

    public static void openSetting(Activity activity) {
        Intent intent = null;
        if (Build.VERSION.SDK_INT > 10) {
            intent = new Intent("android.settings.WIRELESS_SETTINGS");
        } else {
            intent = new Intent();
            ComponentName component = new ComponentName("com.android.settings", "com.android.settings.WirelessSettings");
            intent.setComponent(component);
            intent.setAction("android.intent.action.VIEW");
        }
        activity.startActivity(intent);
    }

    public static String getNetworkTypeName(Context context) {
        NetworkInfo info;
        ConnectivityManager connectMgr;
        if (context != null && (connectMgr = (ConnectivityManager)context.getSystemService("connectivity")) != null && (info = connectMgr.getActiveNetworkInfo()) != null) {
            switch (info.getType()) {
                case 1: {
                    return "WIFI";
                }
                case 0: {
                    return NetWorkUtils.getNetworkTypeName(info.getSubtype());
                }
            }
        }
        return NetWorkUtils.getNetworkTypeName(0);
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getNetworkName(Context context) {
        NetworkInfo wifiNetInfo;
        ConnectivityManager connectMgr;
        if (context != null && (connectMgr = (ConnectivityManager)context.getSystemService("connectivity")) != null && (wifiNetInfo = connectMgr.getNetworkInfo(1)).isConnected()) {
            return wifiNetInfo.getExtraInfo();
        }
        return "";
    }

    private static String getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
        }
        return "UNKNOWN";
    }
}

