/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class ImageConvertUtils {
    public static byte[] bitmapToBytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap bytesToBitmap(byte[] b) {
        if (b.length != 0) {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inSampleSize = 1;
            return BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length, (BitmapFactory.Options)opts);
        }
        return null;
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    public static Drawable bitmapToDrawable(Bitmap bitmap) {
        return new BitmapDrawable(bitmap);
    }

    public static byte[] drawableToBytes(Drawable bm) {
        byte[] bytes = ImageConvertUtils.bitmapToBytes(ImageConvertUtils.drawableToBitmap(bm));
        return bytes;
    }

    public static Drawable bytesToDrawable(byte[] bytes) {
        Drawable drawable2 = ImageConvertUtils.bitmapToDrawable(ImageConvertUtils.bytesToBitmap(bytes));
        return drawable2;
    }
}

