/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;

public class XmlUtils {
    public static String obj2xml(Object obj) {
        return XmlUtils.obj2xml(obj, "UTF-8");
    }

    public static String obj2xmlGBK(Object obj) {
        return XmlUtils.obj2xml(obj, "GBK");
    }

    public static String obj2xml(Object obj, String encoding) {
        try {
            if (obj == null) {
                return null;
            }
            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xStream.autodetectAnnotations(true);
            String xml = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n" + xStream.toXML(obj);
            xml = xml.replaceAll("__", "_");
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object xml2Obj(String content, Class<?> clazz) {
        try {
            if (content == null || "".equals(content)) {
                return null;
            }
            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xStream.processAnnotations(clazz);
            return xStream.fromXML(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object xml2Obj(String content, Class<?>[] clazzes) {
        try {
            if (content == null || "".equals(content)) {
                return null;
            }
            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xStream.processAnnotations((Class[])clazzes);
            return xStream.fromXML(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

