/*
 * Decompiled with CFR 0.152.
 */
package com.dayouzc.e2e.core.callback;

import com.dayouzc.e2e.core.util.ConvertUtils;
import com.dayouzc.e2eplatform.core.dto.common.ResponseData;
import com.google.gson.stream.JsonReader;
import com.lzy.okgo.convert.Converter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonConvert<T>
implements Converter<T> {
    private Type type;
    private Class<T> clazz;

    public JsonConvert() {
    }

    public JsonConvert(Type type) {
        this.type = type;
    }

    public JsonConvert(Class<T> clazz) {
        this.clazz = clazz;
    }

    public T convertResponse(Response response) throws Throwable {
        if (this.type == null) {
            if (this.clazz == null) {
                Type genType = this.getClass().getGenericSuperclass();
                this.type = ((ParameterizedType)genType).getActualTypeArguments()[0];
            } else {
                return this.parseClass(response, this.clazz);
            }
        }
        if (this.type instanceof ParameterizedType) {
            return this.parseParameterizedType(response, (ParameterizedType)this.type);
        }
        if (this.type instanceof Class) {
            return this.parseClass(response, (Class)this.type);
        }
        return this.parseType(response, this.type);
    }

    private T parseClass(Response response, Class<?> rawType) throws Exception {
        if (rawType == null) {
            return null;
        }
        ResponseBody body = response.body();
        if (body == null) {
            return null;
        }
        JsonReader jsonReader = new JsonReader(body.charStream());
        if (rawType == String.class) {
            return (T)body.string();
        }
        if (rawType == JSONObject.class) {
            return (T)new JSONObject(body.string());
        }
        if (rawType == JSONArray.class) {
            return (T)new JSONArray(body.string());
        }
        Object t = ConvertUtils.fromJson(jsonReader, rawType);
        response.close();
        return t;
    }

    private T parseType(Response response, Type type) throws Exception {
        if (type == null) {
            return null;
        }
        ResponseBody body = response.body();
        if (body == null) {
            return null;
        }
        JsonReader jsonReader = new JsonReader(body.charStream());
        Object t = ConvertUtils.fromJson(jsonReader, type);
        response.close();
        return t;
    }

    private T parseParameterizedType(Response response, ParameterizedType type) throws Exception {
        if (type == null) {
            return null;
        }
        ResponseBody body = response.body();
        if (body == null) {
            return null;
        }
        JsonReader jsonReader = new JsonReader(body.charStream());
        Type rawType = type.getRawType();
        Type typeArgument = type.getActualTypeArguments()[0];
        if (rawType != ResponseData.class) {
            Object t = ConvertUtils.fromJson(jsonReader, (Type)type);
            response.close();
            return t;
        }
        ResponseData lzyResponse = (ResponseData)ConvertUtils.fromJson(jsonReader, (Type)type);
        response.close();
        int code = Integer.parseInt(lzyResponse.getStatus());
        if (code == 10000) {
            return (T)lzyResponse;
        }
        if (code == 104) {
            throw new IllegalStateException("\u7528\u6237\u6388\u6743\u4fe1\u606f\u65e0\u6548");
        }
        if (code == 105) {
            throw new IllegalStateException("\u7528\u6237\u6536\u53d6\u4fe1\u606f\u5df2\u8fc7\u671f");
        }
        throw new IllegalStateException("\u9519\u8bef\u4ee3\u7801\uff1a" + code + "\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + lzyResponse.getMsg());
    }
}

