/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sdk;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.superrtc.sdk.VideoViewRenderer;
import com.superrtc.sdk.VideoViewWrapper;

public class VideoView
extends GLSurfaceView {
    protected VideoViewRenderer renderer;
    private boolean isGesture = false;
    private boolean isSingle = true;
    private boolean isDouble = false;
    private float focusX = 0.0f;
    private float focusY = 0.0f;
    private int width;
    private int height;
    private float oldZoom;
    private CallViewListener callViewListener;
    private EMCallViewScaleMode aspectMode = EMCallViewScaleMode.EMCallViewScaleModeAspectFit;

    public synchronized EMCallViewScaleMode getScaleMode() {
        return this.aspectMode;
    }

    public synchronized void setScaleMode(EMCallViewScaleMode mode) {
        if (this.aspectMode != mode) {
            this.aspectMode = mode;
        }
    }

    public VideoView(Context context) {
        this(context, null);
    }

    public VideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
    }

    public VideoViewRenderer getRenderer() {
        return this.renderer;
    }

    public void release() {
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
    }

    public void setGestureEnable(boolean gesture) {
        this.isGesture = gesture;
    }

    void init(VideoViewWrapper wrapper) {
        this.renderer = new VideoViewRenderer(wrapper, "CallView");
    }

    private void handleFocus() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.callViewListener != null) {
            this.callViewListener.onFocus(this.focusX, this.focusY, this.width, this.height);
        }
    }

    private float getZoom(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private void handleZoom(boolean isZoomIn, int zoomScale) {
        if (this.callViewListener != null) {
            this.callViewListener.onZoom(isZoomIn, zoomScale);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isGesture) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.isSingle = true;
                break;
            }
            case 5: {
                this.isSingle = false;
                this.isDouble = true;
                this.oldZoom = this.getZoom(event);
                break;
            }
            case 2: {
                if (this.isSingle || !this.isDouble) break;
                float newZoom = this.getZoom(event);
                int zoomScale = (int)Math.abs((newZoom - this.oldZoom) / 3.0f);
                if (newZoom > this.oldZoom) {
                    this.handleZoom(true, zoomScale);
                } else {
                    this.handleZoom(false, zoomScale);
                }
                this.oldZoom = newZoom;
                break;
            }
            case 6: {
                this.isDouble = false;
                break;
            }
            case 1: {
                if (!this.isSingle) break;
                this.focusX = event.getX();
                this.focusY = event.getY();
                this.handleFocus();
            }
        }
        return true;
    }

    public void setCallViewListener(CallViewListener listener) {
        this.callViewListener = listener;
    }

    public static interface CallViewListener {
        public void onFocus(float var1, float var2, int var3, int var4);

        public void onZoom(boolean var1, int var2);
    }

    public static enum EMCallViewScaleMode {
        EMCallViewScaleModeAspectFit,
        EMCallViewScaleModeAspectFill;

    }
}

