/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import com.superrtc.call.AudioTrack;
import com.superrtc.call.MediaStreamTrack;
import com.superrtc.call.VideoTrack;
import java.util.LinkedList;

public class MediaStream {
    public final LinkedList<AudioTrack> audioTracks = new LinkedList();
    public final LinkedList<VideoTrack> videoTracks = new LinkedList();
    public final LinkedList<VideoTrack> preservedVideoTracks = new LinkedList();
    final long nativeStream;

    public MediaStream(long nativeStream) {
        this.nativeStream = nativeStream;
    }

    public boolean addTrack(AudioTrack track) {
        if (MediaStream.nativeAddAudioTrack(this.nativeStream, track.nativeTrack)) {
            this.audioTracks.add(track);
            return true;
        }
        return false;
    }

    public boolean addTrack(VideoTrack track) {
        if (MediaStream.nativeAddVideoTrack(this.nativeStream, track.nativeTrack)) {
            this.videoTracks.add(track);
            return true;
        }
        return false;
    }

    public boolean addPreservedTrack(VideoTrack track) {
        if (MediaStream.nativeAddVideoTrack(this.nativeStream, track.nativeTrack)) {
            this.preservedVideoTracks.add(track);
            return true;
        }
        return false;
    }

    public boolean removeTrack(AudioTrack track) {
        this.audioTracks.remove(track);
        return MediaStream.nativeRemoveAudioTrack(this.nativeStream, track.nativeTrack);
    }

    public boolean removeTrack(VideoTrack track) {
        this.videoTracks.remove(track);
        this.preservedVideoTracks.remove(track);
        return MediaStream.nativeRemoveVideoTrack(this.nativeStream, track.nativeTrack);
    }

    public void dispose() {
        MediaStreamTrack track;
        while (!this.audioTracks.isEmpty()) {
            track = this.audioTracks.getFirst();
            this.removeTrack((AudioTrack)track);
            track.dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            track = this.videoTracks.getFirst();
            this.removeTrack((VideoTrack)track);
            ((VideoTrack)track).dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            this.removeTrack(this.preservedVideoTracks.getFirst());
        }
        MediaStream.free(this.nativeStream);
    }

    public String label() {
        return MediaStream.nativeLabel(this.nativeStream);
    }

    public String toString() {
        return "[" + this.label() + ":A=" + this.audioTracks.size() + ":V=" + this.videoTracks.size() + "]";
    }

    private static native boolean nativeAddAudioTrack(long var0, long var2);

    private static native boolean nativeAddVideoTrack(long var0, long var2);

    private static native boolean nativeRemoveAudioTrack(long var0, long var2);

    private static native boolean nativeRemoveVideoTrack(long var0, long var2);

    private static native String nativeLabel(long var0);

    private static native void free(long var0);
}

