/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.widget.util;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.widget.TextView;
import com.chinamobile.ysx.R;
import com.chinamobile.ysx.widget.util.CNNameAbbrGenerator;
import com.chinamobile.ysx.widget.util.INameAbbrGenerator;
import java.util.Locale;

public class NameAbbrAvatarDrawable
extends Drawable {
    private static final String TAG = NameAbbrAvatarDrawable.class.getSimpleName();
    private static final int[] BG_COLORS_IDS = new int[]{R.color.m_abbr_avatar_bg_1, R.color.m_abbr_avatar_bg_2, R.color.m_abbr_avatar_bg_3, R.color.m_abbr_avatar_bg_4, R.color.m_abbr_avatar_bg_5, R.color.m_abbr_avatar_bg_6, R.color.m_abbr_avatar_bg_7, R.color.m_abbr_avatar_bg_8};
    private int mAlpha = -1;
    private ColorFilter mColorFilter;
    private String mNameAbbr = "XX";
    private int mColorBg = -11908018;
    private int mColorFg = -1;
    private Context mContext;

    public NameAbbrAvatarDrawable(Context context, String name, String mBgColorSeed) {
        if (name != null) {
            this.mColorBg = this.getBackgroundColorBySeedString(context, mBgColorSeed);
            this.mColorFg = context.getResources().getColor(R.color.m_abbr_avatar_fg);
            this.mNameAbbr = this.generateNameAbbr(context, name);
            this.mContext = context;
        }
    }

    private int getBackgroundColorBySeedString(Context context, String str) {
        int color2;
        int idx = 0;
        for (color2 = 0; color2 < str.length(); ++color2) {
            idx += str.charAt(color2);
            idx %= 8;
        }
        color2 = context.getResources().getColor(BG_COLORS_IDS[idx]);
        return color2;
    }

    private String generateNameAbbr(Context context, String name) {
        CNNameAbbrGenerator generator = new CNNameAbbrGenerator();
        return ((INameAbbrGenerator)generator).getNameAbbreviation(name, Locale.getDefault());
    }

    public void draw(Canvas canvas) {
        int horizontalPadding1;
        Rect bounds = this.getBounds();
        int left = bounds.left;
        int top = bounds.top;
        int canvasWidth = bounds.width();
        int canvasHeight = bounds.height();
        int textSize = (int)Math.sqrt(canvasWidth / 2 * (canvasWidth / 2) / 2) * 4 / 3;
        TextPaint textPaint = new TextPaint();
        Typeface typeface = new TextView(this.mContext).getTypeface();
        textPaint.setTypeface(typeface);
        textPaint.setColor(this.mColorFg);
        textPaint.setColorFilter(this.mColorFilter);
        textPaint.setAlpha(this.mAlpha);
        textPaint.setAntiAlias(true);
        int minHPadding = NameAbbrAvatarDrawable.dip2px(this.mContext, 7.0f);
        boolean textWidth = false;
        boolean horizontalPadding = false;
        int nextSize = textSize;
        do {
            textPaint.setTextSize((float)nextSize);
            int textWidth1 = (int)textPaint.measureText(this.mNameAbbr);
            horizontalPadding1 = (canvasWidth - textWidth1) / 2;
            nextSize -= 2;
        } while (horizontalPadding1 < minHPadding);
        canvas.drawColor(this.mColorBg);
        Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
        canvas.drawText(this.mNameAbbr, (float)(left + horizontalPadding1), (float)top + ((float)(canvasHeight / 2) - ((fontMetrics.bottom - fontMetrics.top) / 2.0f + fontMetrics.top)), (Paint)textPaint);
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return 0;
    }

    public static int dip2px(Context context, float value) {
        if (context == null) {
            return (int)value;
        }
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(value * density + 0.5f);
    }
}

