/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.widget.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.chinamobile.ysx.utils.StringUtil;
import com.chinamobile.ysx.widget.util.ImageUtil;
import java.io.File;
import java.util.WeakHashMap;

public class MyBitmapFactory {
    private static final String TAG = MyBitmapFactory.class.getSimpleName();
    private static WeakHashMap<Key, Bitmap> cachedMap = new WeakHashMap();

    public static Bitmap decodeFile(Context context, String pathName) {
        return MyBitmapFactory.decodeFile(context, pathName, false);
    }

    public static Bitmap decodeFile(Context context, String pathName, int maxArea) {
        return MyBitmapFactory.decodeFile(context, pathName, maxArea, false);
    }

    public static Bitmap decodeFile(Context context, String pathName, boolean fromMemCacheOnly) {
        return MyBitmapFactory.decodeFile(context, pathName, -1, fromMemCacheOnly);
    }

    public static Bitmap decodeFile(Context context, String pathName, int maxArea, boolean fromMemCacheOnly) {
        return MyBitmapFactory.decodeFile(context, pathName, maxArea, true, fromMemCacheOnly);
    }

    public static Bitmap decodeFile(Context context, String pathName, int maxArea, boolean useMemCache, boolean fromMemCacheOnly) {
        if (StringUtil.isEmptyOrNull(pathName)) {
            return null;
        }
        File file = new File(pathName);
        if (!file.exists()) {
            return null;
        }
        long timestamp = file.lastModified();
        Bitmap bitmap = null;
        if (useMemCache) {
            bitmap = MyBitmapFactory.getCachedBitmap(pathName, null, timestamp);
        }
        if (!(bitmap != null || useMemCache && fromMemCacheOnly)) {
            if (maxArea > 0) {
                bitmap = ImageUtil.translateImageAsSmallBitmapInArea(context, Uri.fromFile((File)file), maxArea, false);
            } else {
                BitmapFactory.Options o = new BitmapFactory.Options();
                o.inSampleSize = 1;
                try {
                    while (true) {
                        try {
                            bitmap = BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)o);
                        }
                        catch (OutOfMemoryError var10) {
                            ++o.inSampleSize;
                            if (o.inSampleSize <= 32) continue;
                            return null;
                        }
                        break;
                    }
                }
                catch (Exception var11) {
                    return null;
                }
            }
            if (bitmap != null && useMemCache) {
                MyBitmapFactory.cacheBitmap(pathName, null, bitmap, timestamp);
            }
        }
        return bitmap;
    }

    public static void cacheBitmap(String pathName, String key, Bitmap bitmap, long timestamp) {
        if ((pathName != null || key != null) && bitmap != null) {
            cachedMap.put(new Key(pathName, key, timestamp), bitmap);
        }
    }

    public static Bitmap getCachedBitmap(String pathName, String key, long timestamp) {
        if (pathName == null && key == null) {
            return null;
        }
        Bitmap bitmap = cachedMap.get(Key.getFlyweightInstance(pathName, key, timestamp));
        if (bitmap != null && bitmap.isRecycled()) {
            cachedMap.remove(Key.getFlyweightInstance(pathName, key, timestamp));
            bitmap = null;
        }
        return bitmap;
    }

    static class Key {
        private static Key flyWeightInstance = new Key(null, null, 0L);
        String path;
        String subKey;
        long timestamp = 0L;

        public Key(String path, String subKey, long timestamp) {
            this.path = path;
            this.subKey = subKey;
            this.timestamp = timestamp;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key1 = (Key)obj;
            return StringUtil.isSameString(this.path, key1.path) && StringUtil.isSameString(this.subKey, key1.subKey) && this.timestamp == key1.timestamp;
        }

        public int hashCode() {
            return (int)this.timestamp;
        }

        static Key getFlyweightInstance(String path, String subKey, long timestamp) {
            Key.flyWeightInstance.path = path;
            Key.flyWeightInstance.subKey = subKey;
            Key.flyWeightInstance.timestamp = timestamp;
            return flyWeightInstance;
        }
    }
}

