/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.widget.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.chinamobile.ysx.widget.util.MyBitmapFactory;

public class LazyLoadDrawable
extends Drawable {
    private final String TAG = LazyLoadDrawable.class.getSimpleName();
    private String mImagePath;
    private Bitmap mBitmap;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private int mAlpha = -1;
    private ColorFilter mColorFilter;
    private boolean mbValid = false;
    private Context mContext;

    public LazyLoadDrawable(String imagePath) {
        if (imagePath != null) {
            this.mImagePath = imagePath;
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            try {
                BitmapFactory.decodeFile((String)this.mImagePath, (BitmapFactory.Options)o);
            }
            catch (Exception var4) {
                return;
            }
            this.mIntrinsicWidth = o.outWidth;
            this.mIntrinsicHeight = o.outHeight;
            this.mbValid = this.mIntrinsicWidth > 0 && this.mIntrinsicHeight > 0;
        }
    }

    public boolean isValidDrawable() {
        return this.mbValid;
    }

    public int getIntrinsicWidth() {
        return this.mIntrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.mIntrinsicHeight;
    }

    public void draw(Canvas canvas) {
        if (this.mBitmap == null || this.mBitmap.isRecycled()) {
            this.mBitmap = MyBitmapFactory.decodeFile(this.mContext, this.mImagePath);
        }
        if (this.mBitmap != null) {
            Rect bounds = this.getBounds();
            Paint paint = new Paint();
            if (this.mAlpha >= 0 && this.mAlpha <= 255) {
                paint.setAlpha(this.mAlpha);
            }
            if (this.mColorFilter != null) {
                paint.setColorFilter(this.mColorFilter);
            }
            canvas.drawBitmap(this.mBitmap, new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight()), bounds, paint);
        }
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return 0;
    }
}

