/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.widget.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.util.Base64;
import com.chinamobile.ysx.im.Constants;
import com.chinamobile.ysx.utils.FileUtil;
import com.chinamobile.ysx.utils.StringUtil;
import com.chinamobile.ysx.widget.util.GroupAvatarDrawable;
import com.chinamobile.ysx.widget.util.MyBitmapFactory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ImageUtil {
    private static final String TAG = ImageUtil.class.getSimpleName();

    public static String getNewFilePathForTakingPhoto(Context context) {
        File dir = ImageUtil.getZoomGalleryPath();
        if (dir != null) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (dir.exists()) {
                Date time = new Date();
                SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);
                String fileName = formater.format(time);
                String path = dir.getAbsolutePath() + "/" + fileName + ".jpg";
                int index = 1;
                while (new File(path).exists()) {
                    StringBuilder var10000 = new StringBuilder().append(dir.getAbsolutePath()).append("/").append(fileName).append("(");
                    path = var10000.append(++index).append(").jpg").toString();
                }
                return path;
            }
        }
        return FileUtil.getTempPath(context) + "/capture.jpg";
    }

    public static File getZoomGalleryPath() {
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        if (dir != null && !(dir = new File(dir.getAbsolutePath() + "/zoom.us")).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static boolean translateImageAsSmallJpeg(Context context, Uri imageUri, int maxWidthHeight, String outFile) throws FileNotFoundException {
        return ImageUtil.translateImageAsSmallJpeg(context, imageUri, maxWidthHeight, false, outFile);
    }

    public static boolean translateImageAsSmallJpegInArea(Context context, Uri imageUri, int maxArea, String outFile) throws FileNotFoundException {
        return ImageUtil.translateImageAsSmallJpegInArea(context, imageUri, maxArea, false, outFile);
    }

    public static boolean translateImageAsSmallJpeg(Context context, Uri imageUri, int maxWidthHeight, boolean cropCenter, String outFile) throws FileNotFoundException {
        return outFile != null && ImageUtil.translateImageAsSmallJpeg(context, imageUri, maxWidthHeight, cropCenter, new FileOutputStream(outFile));
    }

    public static boolean translateImageAsSmallJpegInArea(Context context, Uri imageUri, int maxArea, boolean cropCenter, String outFile) throws FileNotFoundException {
        return outFile != null && ImageUtil.translateImageAsSmallJpegInArea(context, imageUri, maxArea, cropCenter, new FileOutputStream(outFile));
    }

    public static boolean translateImageAsSmallJpeg(Context context, Uri imageUri, int maxWidthHeight, boolean cropCenter, OutputStream stream) {
        if (context != null && imageUri != null && stream != null) {
            if (maxWidthHeight <= 0) {
                return false;
            }
            try {
                Bitmap e = ImageUtil.translateImageAsSmallBitmap(context, imageUri, maxWidthHeight, false, cropCenter);
                if (e == null) {
                    return false;
                }
                boolean res = e.compress(Bitmap.CompressFormat.JPEG, 60, stream);
                e.recycle();
                return res;
            }
            catch (Exception var7) {
                return false;
            }
        }
        return false;
    }

    public static boolean translateImageAsSmallJpegInArea(Context context, Uri imageUri, int maxArea, boolean cropCenter, OutputStream stream) {
        if (context != null && imageUri != null && stream != null) {
            if (maxArea <= 0) {
                return false;
            }
            try {
                Bitmap e = ImageUtil.translateImageAsSmallBitmapInArea(context, imageUri, maxArea, false, cropCenter);
                if (e == null) {
                    return false;
                }
                boolean res = e.compress(Bitmap.CompressFormat.JPEG, 60, stream);
                e.recycle();
                return res;
            }
            catch (Exception var7) {
                return false;
            }
        }
        return false;
    }

    public static Bitmap translateImageAsSmallBitmap(Context context, Uri imageUri, int maxWidthHeight, boolean strict) {
        return ImageUtil.translateImageAsSmallBitmap(context, imageUri, maxWidthHeight, strict, false);
    }

    public static Bitmap translateImageAsSmallBitmapInArea(Context context, Uri imageUri, int maxArea, boolean strict) {
        return ImageUtil.translateImageAsSmallBitmapInArea(context, imageUri, maxArea, strict, false);
    }

    public static Bitmap translateImageAsSmallBitmap(Context context, Uri imageUri, int maxWidthHeight, boolean strict, boolean cropCenter) {
        if (context != null && imageUri != null) {
            if (maxWidthHeight <= 0) {
                return null;
            }
            try {
                BitmapFactory.Options e = new BitmapFactory.Options();
                e.inJustDecodeBounds = true;
                BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(imageUri), null, (BitmapFactory.Options)e);
                return ImageUtil.translateImageAsSmallBitmap(context, imageUri, e.outWidth, e.outHeight, maxWidthHeight, strict, cropCenter);
            }
            catch (Exception var6) {
                return null;
            }
        }
        return null;
    }

    public static Bitmap translateImageAsSmallBitmapInArea(Context context, Uri imageUri, int maxArea, boolean strict, boolean cropCenter) {
        if (context != null && imageUri != null) {
            if (maxArea <= 0) {
                return null;
            }
            try {
                BitmapFactory.Options e = new BitmapFactory.Options();
                e.inJustDecodeBounds = true;
                BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(imageUri), null, (BitmapFactory.Options)e);
                int width = (int)Math.sqrt((float)maxArea * ((float)e.outWidth / (float)e.outHeight));
                int height = width * e.outHeight / e.outWidth;
                int maxWidthHeight = width > height ? width : height;
                return ImageUtil.translateImageAsSmallBitmap(context, imageUri, e.outWidth, e.outHeight, maxWidthHeight, strict, cropCenter);
            }
            catch (Exception var9) {
                return null;
            }
        }
        return null;
    }

    private static Bitmap translateImageAsSmallBitmap(Context context, Uri imageUri, int origWidth, int origHeight, int maxWidthHeight, boolean strict, boolean cropCenter) {
        if (context != null && imageUri != null) {
            if (maxWidthHeight <= 0) {
                return null;
            }
            Bitmap bitmap = null;
            try {
                String e = ImageUtil.getPathFromUri(context, imageUri);
                int width = origWidth;
                int height = origHeight;
                int scale = 1;
                if (cropCenter) {
                    while ((scale >= 3 || origWidth / (scale + 1) >= maxWidthHeight * 3 / 4 && origHeight / (scale + 1) >= maxWidthHeight * 3 / 4) && width >= maxWidthHeight * 3 / 2 && height >= maxWidthHeight * 3 / 2) {
                        width = origWidth / ++scale;
                        height = origHeight / scale;
                    }
                } else {
                    while (!(scale < 3 && origWidth / (scale + 1) < maxWidthHeight * 3 / 4 && origHeight / (scale + 1) < maxWidthHeight * 3 / 4 || width < maxWidthHeight * 3 / 2 && height < maxWidthHeight * 3 / 2)) {
                        width = origWidth / ++scale;
                        height = origHeight / scale;
                    }
                }
                BitmapFactory.Options o2 = new BitmapFactory.Options();
                o2.inSampleSize = scale;
                while (true) {
                    try {
                        bitmap = BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(imageUri), null, (BitmapFactory.Options)o2);
                    }
                    catch (OutOfMemoryError var22) {
                        width = origWidth / ++scale;
                        height = origHeight / scale;
                        o2.inSampleSize = scale;
                        if (width >= maxWidthHeight / 4 || height >= maxWidthHeight / 4) continue;
                        return null;
                    }
                    break;
                }
                if (ImageUtil.isJpegFile(e)) {
                    try {
                        Bitmap h2;
                        int w2 = ImageUtil.getJpegRotation(e);
                        if (w2 > 0 && (h2 = ImageUtil.rotateBitmap(bitmap, w2)) != null && h2 != bitmap) {
                            bitmap.recycle();
                            bitmap = h2;
                        }
                    }
                    catch (Exception h2) {
                        // empty catch block
                    }
                }
                if (strict && (width > maxWidthHeight || height > maxWidthHeight) || cropCenter && width != height) {
                    int var26;
                    int w2;
                    width = bitmap.getWidth();
                    height = bitmap.getHeight();
                    boolean var24 = false;
                    boolean var25 = false;
                    if (width >= height) {
                        w2 = maxWidthHeight;
                        var26 = maxWidthHeight * height / width;
                    } else {
                        var26 = maxWidthHeight;
                        w2 = maxWidthHeight * width / height;
                    }
                    int hOffset = 0;
                    int vOffset = 0;
                    if (cropCenter) {
                        if (w2 > var26) {
                            vOffset = 0;
                            hOffset = (w2 - var26) / 2;
                        } else {
                            hOffset = 0;
                            vOffset = (var26 - w2) / 2;
                        }
                        w2 = var26 = Math.min(w2, var26);
                    }
                    Bitmap baseBitmap = null;
                    try {
                        baseBitmap = Bitmap.createBitmap((int)w2, (int)var26, (Bitmap.Config)bitmap.getConfig());
                    }
                    catch (OutOfMemoryError var20) {
                        return bitmap;
                    }
                    Canvas canvas = new Canvas(baseBitmap);
                    Paint paint = new Paint();
                    canvas.drawBitmap(bitmap, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Rect(-hOffset, -vOffset, w2 + hOffset, var26 + vOffset), paint);
                    bitmap.recycle();
                    return baseBitmap;
                }
                return bitmap;
            }
            catch (Exception var23) {
                return null;
            }
        }
        return null;
    }

    private static boolean isJpegFile(String imagePath) {
        return imagePath != null && (imagePath.endsWith(".jpg") || imagePath.endsWith(".JPG") || imagePath.endsWith(".jpeg") || imagePath.endsWith(".JPEG"));
    }

    public static String getPathFromUri(Context context, Uri uri) {
        return context != null && uri != null ? FileUtil.getPathFromUri(context, uri) : null;
    }

    private static int getJpegRotation(String imagePath) throws IOException {
        ExifInterface exif = new ExifInterface(imagePath);
        int orientation = exif.getAttributeInt("Orientation", 1);
        int angle = 0;
        if (orientation == 6) {
            angle = 90;
        } else if (orientation == 3) {
            angle = 180;
        } else if (orientation == 8) {
            angle = 270;
        }
        return angle;
    }

    public static Bitmap getJpegThumbnail(String imagePath) {
        if (StringUtil.isEmptyOrNull(imagePath)) {
            return null;
        }
        File f = new File(imagePath);
        try {
            ExifInterface exif = new ExifInterface(f.getPath());
            if (!exif.hasThumbnail()) {
                return null;
            }
            byte[] data = exif.getThumbnail();
            if (data == null) {
                return null;
            }
            Bitmap bmp = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)new BitmapFactory.Options());
            return bmp;
        }
        catch (Exception var5) {
            return null;
        }
    }

    private static Bitmap rotateBitmap(Bitmap bmp, int angle) {
        Matrix mat = new Matrix();
        mat.postRotate((float)angle);
        try {
            Bitmap e = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)mat, (boolean)true);
            return e;
        }
        catch (OutOfMemoryError var4) {
            return null;
        }
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float roundRatioX, float roundRatioY) {
        if (bitmap == null) {
            return null;
        }
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -65536;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float roundPx = roundRatioX * (float)bitmap.getWidth();
        float roundPy = roundRatioY * (float)bitmap.getHeight();
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-65536);
        canvas.drawRoundRect(rectF, roundPx, roundPy, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean makeGroupAvatarFromMembers(Context context, List<GroupAvatarDrawable.GroupAvatarItem> memberAvatars, int size, String outputFile) {
        if (StringUtil.isEmptyOrNull(outputFile)) {
            return false;
        }
        Bitmap bmpOutput = ImageUtil.makeGroupAvatarFromMembers(context, memberAvatars, size);
        if (bmpOutput == null) {
            return false;
        }
        FileOutputStream os = null;
        boolean res = false;
        try {
            os = new FileOutputStream(outputFile);
            res = bmpOutput.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        }
        catch (Exception exception) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        bmpOutput.recycle();
        return res;
    }

    public static Bitmap makeGroupAvatarFromMembers(Context context, List<GroupAvatarDrawable.GroupAvatarItem> memberAvatars, int size) {
        if (size <= 0) {
            return null;
        }
        Bitmap bmpOutput = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmpOutput);
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        GroupAvatarDrawable drawable2 = new GroupAvatarDrawable(context, memberAvatars);
        drawable2.draw(canvas);
        return bmpOutput;
    }

    public static boolean isValidImageFile(String pathName) {
        if (StringUtil.isEmptyOrNull(pathName)) {
            return false;
        }
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)o);
        }
        catch (Exception var3) {
            return false;
        }
        return o.outWidth > 0 && o.outHeight > 0;
    }

    public static boolean compressImageFile(Context context, String srcFile, String destFile, int quality) {
        if (srcFile != null && destFile != null) {
            Bitmap bitmap = MyBitmapFactory.decodeFile(context, srcFile, -1, false, false);
            if (bitmap == null) {
                return false;
            }
            boolean res = ImageUtil.saveBitmapAsJPEG(bitmap, destFile, quality);
            bitmap.recycle();
            return res;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBitmapAsJPEG(Bitmap bitmap, String destFile, int quality) {
        if (bitmap != null && destFile != null) {
            if (quality == 0) {
                quality = 100;
            }
            boolean res = false;
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(destFile);
                res = bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)os);
            }
            catch (Exception exception) {
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return res;
        }
        return false;
    }

    public static Bitmap readBitmap(String imgPath) {
        try {
            return BitmapFactory.decodeFile((String)imgPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imgToBase64(String imgPath) {
        Bitmap bitmap = null;
        if (imgPath != null && imgPath.length() > 0) {
            bitmap = ImageUtil.readBitmap(imgPath);
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 60, (OutputStream)out);
            out.flush();
            out.close();
            byte[] imgBytes = out.toByteArray();
            String string2 = Base64.encodeToString((byte[])imgBytes, (int)0);
            return string2;
        }
        catch (Exception e) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveFile(Context context, String url) throws IOException {
        try {
            Bitmap bm = ImageUtil.readBitmap(url);
            String downLoadPath = FileUtil.saveFile(context, Constants.MEDIA_PATH, null, "my-avatar.jpg", true);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(downLoadPath));
            bm.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

