/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.widget.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.chinamobile.ysx.R;
import com.chinamobile.ysx.widget.util.ContactsAvatarCache;
import com.chinamobile.ysx.widget.util.LazyLoadDrawable;
import com.chinamobile.ysx.widget.util.NameAbbrAvatarDrawable;
import com.chinamobile.ysx.widget.util.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GroupAvatarDrawable
extends Drawable {
    private List<Drawable> mDrawables = new ArrayList<Drawable>();
    private List<GroupAvatarItem> mNoAvatarItems = new ArrayList<GroupAvatarItem>();
    private int mCountMembers;
    private int mAlpha = -1;
    private ColorFilter mColorFilter;
    private Context mContext;

    public GroupAvatarDrawable(Context context, List<GroupAvatarItem> memberAvatars) {
        this.mCountMembers = memberAvatars.size();
        this.mContext = context;
        for (int i = 0; i < memberAvatars.size(); ++i) {
            GroupAvatarItem item = memberAvatars.get(i);
            String pathName = item.avatar;
            if ((pathName == null || pathName.length() == 0) && item.contactId < 0) {
                this.mNoAvatarItems.add(item);
                continue;
            }
            if (pathName != null && pathName.length() != 0) {
                File var7 = new File(pathName);
                if (var7.exists() && var7.isFile()) {
                    this.mDrawables.add(new LazyLoadDrawable(pathName));
                    if (this.mDrawables.size() < this.mCountMembers) continue;
                    break;
                }
                this.mNoAvatarItems.add(item);
                continue;
            }
            int file = item.contactId;
            Bitmap bmp = ContactsAvatarCache.getInstance().getContactAvatar(this.mContext, file);
            if (bmp != null) {
                this.mDrawables.add((Drawable)new BitmapDrawable(this.mContext.getResources(), bmp));
                continue;
            }
            this.mNoAvatarItems.add(item);
        }
    }

    public void draw(Canvas canvas) {
        if (this.mCountMembers > 0) {
            Rect bounds = this.getBounds();
            int size = bounds.width();
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            int inset = UIUtil.dip2px(this.mContext, 1.0f);
            if (this.mCountMembers == 1) {
                Rect radiusSmall = new Rect(0, 0, size, size);
                radiusSmall.inset(inset, inset);
                radiusSmall.offset(bounds.left, bounds.top);
                float radius = (float)radiusSmall.width() / 2.0f;
                Path rcArc = new Path();
                rcArc.addCircle((float)radiusSmall.left + radius, (float)radiusSmall.top + radius, radius, Path.Direction.CCW);
                this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, 0, rcArc, radiusSmall);
            } else if (this.mCountMembers == 2) {
                double radiusSmall1 = Math.sqrt(size / 4 * (size / 4) + size / 2 * (size / 2));
                RectF rcArc1 = new RectF(0.0f, 0.0f, (float)size, (float)size);
                rcArc1.inset((float)inset, (float)inset);
                rcArc1.offset((float)bounds.left, (float)bounds.top);
                boolean idx = false;
                float radius1 = rcArc1.width() / 2.0f;
                Path path = new Path();
                path.arcTo(rcArc1, 90.0f, 180.0f);
                path.lineTo(rcArc1.left + radius1, rcArc1.bottom);
                path.close();
                Rect rcDest = new Rect((int)((double)((float)size / 4.0f) - radiusSmall1), (int)((double)((float)size / 2.0f) - radiusSmall1), (int)((double)((float)size / 4.0f) + radiusSmall1), (int)((double)((float)size / 2.0f) + radiusSmall1));
                rcDest.offset(bounds.left, bounds.top);
                int idx1 = this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, 0, path, rcDest);
                path = new Path();
                path.arcTo(rcArc1, 270.0f, 180.0f);
                path.lineTo(rcArc1.left + radius1, rcArc1.top);
                path.close();
                rcDest.offset(size / 2, 0);
                this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, idx1 + 1, path, rcDest);
            } else if (this.mCountMembers == 3) {
                double radiusSmall1 = Math.sqrt(size / 4 * (size / 4) * 2);
                RectF rcArc1 = new RectF(0.0f, 0.0f, (float)size, (float)size);
                rcArc1.inset((float)inset, (float)inset);
                rcArc1.offset((float)bounds.left, (float)bounds.top);
                boolean idx = false;
                float radius1 = rcArc1.width() / 2.0f;
                Path path = new Path();
                path.arcTo(rcArc1, 180.0f, 90.0f);
                path.lineTo(rcArc1.left + radius1, rcArc1.top + radius1);
                path.lineTo(rcArc1.left, rcArc1.top + radius1);
                path.close();
                Rect rcDest = new Rect((int)((double)((float)size / 4.0f) - radiusSmall1), (int)((double)((float)size / 4.0f) - radiusSmall1), (int)((double)((float)size / 4.0f) + radiusSmall1), (int)((double)((float)size / 4.0f) + radiusSmall1));
                rcDest.offset(bounds.left, bounds.top);
                int idx1 = this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, 0, path, rcDest);
                path = new Path();
                path.moveTo(rcArc1.left, rcArc1.top + radius1);
                path.lineTo(rcArc1.left + radius1, rcArc1.top + radius1);
                path.lineTo(rcArc1.left + radius1, rcArc1.bottom);
                path.arcTo(rcArc1, 90.0f, 90.0f);
                path.close();
                rcDest.offset(0, size / 2);
                idx1 = this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, idx1 + 1, path, rcDest);
                path = new Path();
                path.arcTo(rcArc1, 270.0f, 180.0f);
                path.lineTo(rcArc1.left + radius1, rcArc1.top);
                path.close();
                double radiusBig = Math.sqrt(size / 4 * (size / 4) + size / 2 * (size / 2));
                rcDest = new Rect((int)((double)((float)size * 3.0f / 4.0f) - radiusBig), (int)((double)((float)size / 2.0f) - radiusBig), (int)((double)((float)size * 3.0f / 4.0f) + radiusBig), (int)((double)((float)size / 2.0f) + radiusBig));
                rcDest.offset(bounds.left, bounds.top);
                this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, idx1 + 1, path, rcDest);
            } else if (this.mCountMembers >= 4) {
                double radiusSmall1 = Math.sqrt(size / 4 * (size / 4) * 2);
                RectF rcArc1 = new RectF(0.0f, 0.0f, (float)size, (float)size);
                rcArc1.inset((float)inset, (float)inset);
                rcArc1.offset((float)bounds.left, (float)bounds.top);
                boolean idx = false;
                float radius1 = rcArc1.width() / 2.0f;
                Path path = new Path();
                path.arcTo(rcArc1, 180.0f, 90.0f);
                path.lineTo(rcArc1.left + radius1, rcArc1.top + radius1);
                path.lineTo(rcArc1.left, rcArc1.top + radius1);
                path.close();
                Rect rcDest = new Rect((int)((double)((float)size / 4.0f) - radiusSmall1), (int)((double)((float)size / 4.0f) - radiusSmall1), (int)((double)((float)size / 4.0f) + radiusSmall1), (int)((double)((float)size / 4.0f) + radiusSmall1));
                rcDest.offset(bounds.left, bounds.top);
                int idx1 = this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, 0, path, rcDest);
                path = new Path();
                path.arcTo(rcArc1, 270.0f, 90.0f);
                path.lineTo(rcArc1.left + radius1, rcArc1.top + radius1);
                path.lineTo(rcArc1.left + radius1, rcArc1.top);
                path.close();
                rcDest.offset(size / 2, 0);
                idx1 = this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, idx1 + 1, path, rcDest);
                path = new Path();
                path.moveTo(rcArc1.left, rcArc1.top + radius1);
                path.lineTo(rcArc1.left + radius1, rcArc1.top + radius1);
                path.lineTo(rcArc1.left + radius1, rcArc1.bottom);
                path.arcTo(rcArc1, 90.0f, 90.0f);
                path.close();
                rcDest.offset(-size / 2, size / 2);
                idx1 = this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, idx1 + 1, path, rcDest);
                path = new Path();
                path.moveTo(rcArc1.left + radius1, rcArc1.bottom);
                path.lineTo(rcArc1.left + radius1, rcArc1.top + radius1);
                path.lineTo(rcArc1.right, rcArc1.top + radius1);
                path.arcTo(rcArc1, 0.0f, 90.0f);
                path.close();
                rcDest.offset(size / 2, 0);
                this.drawMemberAvatar(this.mContext, this.mDrawables, canvas, paint, idx1 + 1, path, rcDest);
            }
        }
    }

    private int drawMemberAvatar(Context context, List<Drawable> drawables, Canvas canvas, Paint paint, int from, Path path, Rect rcDest) {
        Drawable drawable2 = null;
        Drawable srcDrawable = null;
        if (drawables.size() > from) {
            srcDrawable = drawables.get(from);
            if (srcDrawable instanceof LazyLoadDrawable) {
                LazyLoadDrawable borderPaint = (LazyLoadDrawable)srcDrawable;
                if (borderPaint.isValidDrawable()) {
                    drawable2 = srcDrawable;
                }
            } else {
                drawable2 = srcDrawable;
            }
        }
        if (drawable2 == null) {
            int borderPaint1 = from - drawables.size();
            if (borderPaint1 < this.mNoAvatarItems.size()) {
                GroupAvatarItem item = this.mNoAvatarItems.get(borderPaint1);
                drawable2 = new NameAbbrAvatarDrawable(context, item.name, item.jid);
            } else {
                drawable2 = context.getResources().getDrawable(R.drawable.m_no_avatar);
            }
        }
        canvas.save();
        canvas.clipPath(path);
        if (drawable2 != null) {
            canvas.drawColor(-1);
            drawable2.setBounds(rcDest);
            if (this.mAlpha >= 0 && this.mAlpha <= 255) {
                drawable2.setAlpha(this.mAlpha);
            }
            if (this.mColorFilter != null) {
                drawable2.setColorFilter(this.mColorFilter);
            }
            drawable2.draw(canvas);
        }
        canvas.restore();
        Paint borderPaint2 = new Paint();
        borderPaint2.setAntiAlias(true);
        borderPaint2.setColor(-1);
        borderPaint2.setStyle(Paint.Style.STROKE);
        borderPaint2.setStrokeWidth((float)UIUtil.dip2px(this.mContext, 1.0f));
        canvas.drawPath(path, borderPaint2);
        return from;
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
    }

    public int getOpacity() {
        return 0;
    }

    public static class GroupAvatarItem {
        public static final int INVALID_CONTACT_ID = -1;
        public String name;
        public String avatar;
        public int contactId = -1;
        public String jid;

        public GroupAvatarItem(String name, String avatar, int contactId, String jid) {
            this.name = name;
            this.avatar = avatar;
            this.contactId = contactId;
            this.jid = jid;
        }
    }
}

