/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sdk;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SDPSsrcChanger {
    String streamLabel;
    String msidAudio;
    String msidVideo;
    String lastCNAME = null;
    long lastAudioSSRC = 0L;
    long lastVideoSSRC = 0L;
    static long ssrcInterval = 20L;

    public SDPSsrcChanger(String streamLabel) {
        this.streamLabel = streamLabel;
        this.msidAudio = streamLabel + "a0";
        this.msidVideo = streamLabel + "v0";
        this.reset();
    }

    public void reset() {
        this.lastCNAME = null;
        this.lastAudioSSRC = 0L;
        this.lastVideoSSRC = 0L;
    }

    public String processPranswer(String rawSDP) {
        String[] medias = SDPSsrcChanger.splitSDP2Medias(rawSDP);
        StringBuilder sb = new StringBuilder();
        long ssrcBase = SDPSsrcChanger.getNextStartSSRC();
        for (int i = 0; i < medias.length; ++i) {
            long ssrc;
            String m = medias[i];
            this.lastCNAME = "cname" + ssrcBase;
            if (m.startsWith("m=audio")) {
                sb.append(m);
                if (m.indexOf("a=ssrc:") >= 0) continue;
                ssrc = ssrcBase + 0L;
                sb.append("a=ssrc:" + ssrc + " cname:" + this.lastCNAME + "\r\n");
                sb.append("a=ssrc:" + ssrc + " msid:" + this.streamLabel + " " + this.msidAudio + "\r\n");
                sb.append("a=ssrc:" + ssrc + " mslabel:" + this.streamLabel + "\r\n");
                sb.append("a=ssrc:" + ssrc + " label:" + this.msidAudio + "\r\n");
                this.lastAudioSSRC = ssrc;
                continue;
            }
            if (m.startsWith("m=video")) {
                sb.append(m);
                if (m.indexOf("a=ssrc:") >= 0) continue;
                ssrc = ssrcBase + 10L;
                sb.append("a=ssrc-group:FID " + (ssrc + 0L) + " " + (ssrc + 1L) + "\r\n");
                for (int k = 0; k < 2; ++k) {
                    sb.append("a=ssrc:" + (ssrc + (long)k) + " cname:" + this.lastCNAME + "\r\n");
                    sb.append("a=ssrc:" + (ssrc + (long)k) + " msid:" + this.streamLabel + " " + this.msidVideo + "\r\n");
                    sb.append("a=ssrc:" + (ssrc + (long)k) + " mslabel:" + this.streamLabel + "\r\n");
                    sb.append("a=ssrc:" + (ssrc + (long)k) + " label:" + this.msidVideo + "\r\n");
                }
                this.lastVideoSSRC = ssrc;
                continue;
            }
            sb.append(m);
        }
        return sb.toString();
    }

    private String changeMediaSSRC(String m, long ssrc) {
        String regex = "a=ssrc-group:FID(( \\d+)+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(m);
        int replaceCount = 0;
        while (matcher.find()) {
            String[] _fields;
            String fields = matcher.group(1);
            for (String field : _fields = fields.trim().split(" ")) {
                m = m.replaceAll(field, "" + (ssrc + (long)replaceCount));
                ++replaceCount;
            }
        }
        if (replaceCount == 0) {
            m = m.replaceAll("a=ssrc:(\\d+)", "a=ssrc:" + ssrc);
        }
        return m;
    }

    public String changeSSRC(String rawSDP) {
        String[] medias = SDPSsrcChanger.splitSDP2Medias(rawSDP);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < medias.length; ++i) {
            String m = medias[i];
            if (m.startsWith("m=audio") && this.lastAudioSSRC > 0L) {
                m = this.changeMediaSSRC(m, this.lastAudioSSRC);
                sb.append(m);
                continue;
            }
            if (m.startsWith("m=video") && this.lastVideoSSRC > 0L) {
                m = this.changeMediaSSRC(m, this.lastVideoSSRC);
                sb.append(m);
                continue;
            }
            sb.append(m);
        }
        return sb.toString();
    }

    static String[] splitSDP2Medias(String rawSDP) {
        String[] tmpParts = rawSDP.split("\r\nm=");
        if (tmpParts.length < 2) {
            return new String[]{rawSDP};
        }
        String[] medias = new String[tmpParts.length];
        medias[0] = tmpParts[0] + "\r\n";
        for (int i = 1; i < tmpParts.length; ++i) {
            medias[i] = "m=" + tmpParts[i];
            if (i == tmpParts.length - 1) continue;
            int n = i;
            medias[n] = medias[n] + "\r\n";
        }
        return medias;
    }

    static long getNextStartSSRC() {
        long n = Math.abs(new Random().nextLong() % 100000000L);
        n -= n % ssrcInterval;
        return n;
    }
}

