/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.hardware.Camera;
import android.os.SystemClock;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.Logging;
import java.util.ArrayList;
import java.util.List;

public class CameraEnumerator
implements CameraEnumerationAndroid.Enumerator {
    private static final String TAG = "CameraEnumerator";
    private List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int cameraId) {
        CameraEnumerator cameraEnumerator = this;
        synchronized (cameraEnumerator) {
            if (this.cachedSupportedFormats == null) {
                this.cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
                for (int i = 0; i < CameraEnumerationAndroid.getDeviceCount(); ++i) {
                    this.cachedSupportedFormats.add(this.enumerateFormats(i));
                }
            }
        }
        return this.cachedSupportedFormats.get(cameraId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int cameraId) {
        Camera.Parameters parameters;
        Logging.d(TAG, "Get supported formats for camera index " + cameraId + ".");
        long startTimeMs = SystemClock.elapsedRealtime();
        Camera camera = null;
        try {
            Logging.d(TAG, "Opening camera with index " + cameraId);
            camera = Camera.open((int)cameraId);
            parameters = camera.getParameters();
        }
        catch (RuntimeException e2) {
            Logging.e(TAG, "Open camera failed on camera index " + cameraId, e2);
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            return arrayList;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        ArrayList<CameraEnumerationAndroid.CaptureFormat> formatList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
        try {
            int minFps = 0;
            int maxFps = 0;
            List listFpsRange = parameters.getSupportedPreviewFpsRange();
            if (listFpsRange != null) {
                int[] range = (int[])listFpsRange.get(listFpsRange.size() - 1);
                minFps = range[0];
                maxFps = range[1];
            }
            for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                formatList.add(new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, minFps, maxFps));
            }
        }
        catch (Exception e3) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index " + cameraId, e3);
        }
        long endTimeMs = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + cameraId + " done. Time spent: " + (endTimeMs - startTimeMs) + " ms.");
        return formatList;
    }
}

