/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMContactListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.adapter.EMAContactListener;
import com.hyphenate.chat.adapter.EMAContactManager;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.exceptions.HyphenateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EMContactManager {
    EMAContactManager emaObject;
    EMClient mClient;
    private List<EMContactListener> contactListeners = Collections.synchronizedList(new ArrayList());
    private EMAContactListenerImpl contactImpl = new EMAContactListenerImpl();

    EMContactManager(EMClient eMClient, EMAContactManager eMAContactManager) {
        this.mClient = eMClient;
        this.emaObject = new EMAContactManager(eMAContactManager);
        this.emaObject.registerContactListener(this.contactImpl);
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    public void addContact(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.inviteContact(string, string2, eMAError);
        this.handleError(eMAError);
    }

    public void aysncAddContact(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.addContact(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void deleteContact(String string) throws HyphenateException {
        this.deleteContact(string, false);
    }

    public void deleteContact(String string, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.deleteContact(string, eMAError, bl);
        EMClient.getInstance().chatManager().caches.remove(string);
        this.handleError(eMAError);
    }

    public void aysncDeleteContact(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.deleteContact(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> getAllContactsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getContactsFromServer(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void aysncGetAllContactsFromServer(final EMValueCallBack<List<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = EMContactManager.this.getAllContactsFromServer();
                    eMValueCallBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void setContactListener(EMContactListener eMContactListener) {
        if (!this.contactListeners.contains(eMContactListener)) {
            this.contactListeners.add(eMContactListener);
        }
    }

    public void removeContactListener(EMContactListener eMContactListener) {
        this.contactListeners.remove(eMContactListener);
    }

    public void addUserToBlackList(String string, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.addToBlackList(string, bl, eMAError);
        this.handleError(eMAError);
    }

    public void aysncAddUserToBlackList(final String string, final boolean bl, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.addUserToBlackList(string, bl);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeUserFromBlackList(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.removeFromBlackList(string, eMAError);
        this.handleError(eMAError);
    }

    public void aysncRemoveUserFromBlackList(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.removeUserFromBlackList(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> getBlackListUsernames() {
        EMAError eMAError = new EMAError();
        return this.emaObject.getBlackListFromDB(eMAError);
    }

    public List<String> getBlackListFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getBlackListFromServer(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void aysncGetBlackListFromServer(final EMValueCallBack<List<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = EMContactManager.this.getBlackListFromServer();
                    eMValueCallBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void saveBlackList(List<String> list) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.saveBlackList(list, eMAError);
        this.handleError(eMAError);
    }

    public void asyncSaveBlackList(final List<String> list, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.saveBlackList(list);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void acceptInvitation(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.acceptInvitation(string, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAcceptInvitation(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.acceptInvitation(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void declineInvitation(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineInvitation(string, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineInvitation(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMContactManager.this.declineInvitation(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    List<String> getContactsFromDB(EMAError eMAError) {
        return this.emaObject.getContactsFromDB(eMAError);
    }

    void onLogout() {
    }

    public List<String> getSelfIdsOnOtherPlatform() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getSelfIdsOnOtherPlatform(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void aysncGetSelfIdsOnOtherPlatform(final EMValueCallBack<List<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = EMContactManager.this.getSelfIdsOnOtherPlatform();
                    eMValueCallBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    class EMAContactListenerImpl
    extends EMAContactListener {
        EMAContactListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactAdded(String string) {
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onContactAdded(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactDeleted(String string) {
            EMClient.getInstance().chatManager().caches.remove(string);
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onContactDeleted(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactInvited(String string, String string2) {
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onContactInvited(string, string2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactAgreed(String string) {
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onFriendRequestAccepted(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactRefused(String string) {
            List list = EMContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (EMContactListener eMContactListener : EMContactManager.this.contactListeners) {
                        eMContactListener.onFriendRequestDeclined(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

