/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.widget.util;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import com.chinamobile.ysx.widget.util.UIUtil;

public class RoundDrawable
extends InsetDrawable {
    private float mCornerRatio = 0.0f;
    private int mBorderColor = -1;
    private boolean mbCircle = true;
    private int mClientWidth = 0;
    private int mClientHeight = 0;
    private Context mContext;

    public RoundDrawable(Context context, Drawable drawable2, float cornerRatio, int borderColor) {
        this(context, drawable2, cornerRatio, borderColor, true, 0, 0);
    }

    public RoundDrawable(Context context, Drawable drawable2, float cornerRatio, int borderColor, boolean bCircle, int clientWidth, int clientHeight) {
        super(drawable2, 0);
        this.mCornerRatio = cornerRatio;
        this.mBorderColor = borderColor;
        this.mbCircle = bCircle;
        this.mClientWidth = clientWidth;
        this.mClientHeight = clientHeight;
        this.mContext = context;
    }

    public boolean setClientSize(int clientWidth, int clientHeight) {
        boolean changed = false;
        if (this.mClientWidth != clientWidth) {
            this.mClientWidth = clientWidth;
            changed = true;
        }
        if (this.mClientHeight != clientHeight) {
            this.mClientHeight = clientHeight;
            changed = true;
        }
        return changed;
    }

    public int getIntrinsicWidth() {
        if (this.mClientWidth > 0 && this.mClientHeight > 0) {
            int minVal = Math.min(this.mClientWidth, this.mClientHeight);
            return super.getIntrinsicWidth() <= super.getIntrinsicHeight() ? minVal : super.getIntrinsicWidth() * minVal / super.getIntrinsicHeight();
        }
        return super.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        if (this.mClientWidth > 0 && this.mClientHeight > 0) {
            int minVal = Math.min(this.mClientWidth, this.mClientHeight);
            return super.getIntrinsicWidth() >= super.getIntrinsicHeight() ? minVal : super.getIntrinsicHeight() * minVal / super.getIntrinsicWidth();
        }
        return super.getIntrinsicHeight();
    }

    public void draw(Canvas canvas) {
        float roundPx;
        Rect bounds = this.getBounds();
        int strokeWidth = UIUtil.dip2px(this.mContext, 1.0f);
        Rect rect = new Rect(bounds.left, bounds.top, bounds.right, bounds.bottom);
        rect.inset(strokeWidth, strokeWidth);
        RectF rectF = new RectF(rect);
        if (this.mbCircle) {
            roundPx = Math.min(rectF.width(), rectF.height());
            rectF.inset((rectF.width() - roundPx) / 2.0f, (rectF.height() - roundPx) / 2.0f);
        }
        roundPx = this.mCornerRatio * (float)rect.width();
        float roundPy = this.mCornerRatio * (float)rect.height();
        Path path = new Path();
        path.addRoundRect(rectF, roundPx, roundPy, Path.Direction.CCW);
        canvas.save();
        canvas.clipPath(path);
        super.draw(canvas);
        canvas.restore();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(this.mBorderColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)strokeWidth);
        canvas.drawPath(path, paint);
    }

    public void setBorderColor(int color2) {
        this.mBorderColor = color2;
    }
}

