/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.ysx.widget.util;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.ContactsContract;
import java.io.InputStream;
import java.util.WeakHashMap;

public class ContactsAvatarCache {
    private static final String TAG = ContactsAvatarCache.class.getSimpleName();
    private WeakHashMap<Integer, Object> mCacheMap = new WeakHashMap();
    private static ContactsAvatarCache instance = null;

    public static synchronized ContactsAvatarCache getInstance() {
        if (instance == null) {
            instance = new ContactsAvatarCache();
        }
        return instance;
    }

    private ContactsAvatarCache() {
    }

    public synchronized Bitmap getContactAvatar(Context context, int contactId) {
        return this.getContactAvatar(context, contactId, false);
    }

    public synchronized Bitmap getContactAvatar(Context context, int contactId, boolean fromMemCacheOnly) {
        if (context == null) {
            return null;
        }
        Object item = this.getCachedAvatar(contactId);
        if (item instanceof Bitmap) {
            return (Bitmap)item;
        }
        if (item != null) {
            return null;
        }
        if (fromMemCacheOnly) {
            return null;
        }
        Bitmap bitmap = ContactsAvatarCache.syncGetContactAvatar(context, contactId);
        return bitmap;
    }

    private static Bitmap syncGetContactAvatar(Context context, int contactId) {
        if (context == null) {
            return null;
        }
        InputStream is = ContactsAvatarCache.getAvatarStream(context, contactId);
        if (is == null) {
            ContactsAvatarCache.getInstance().cacheAvatar(contactId, null);
            return null;
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
        try {
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ContactsAvatarCache.getInstance().cacheAvatar(contactId, bitmap);
        return bitmap;
    }

    private synchronized void cacheAvatar(int contactId, Bitmap bitmap) {
        if (bitmap != null) {
            this.mCacheMap.put(contactId, bitmap);
        } else {
            this.mCacheMap.put(contactId, 0);
        }
    }

    private synchronized Object getCachedAvatar(int contactId) {
        Object obj = this.mCacheMap.get(contactId);
        return obj;
    }

    private static InputStream getAvatarStream(Context context, int contactId) {
        if (contactId < 0) {
            return null;
        }
        ContentResolver cr = context.getContentResolver();
        if (cr == null) {
            return null;
        }
        Uri contactUri = ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)contactId);
        if (contactUri == null) {
            return null;
        }
        try {
            InputStream e = ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)cr, (Uri)contactUri);
            return e;
        }
        catch (Exception var5) {
            return null;
        }
    }
}

