/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.ptapp.AlterHost;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.PTUserProfile;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.sdk.MeetingItem;
import us.zoom.sdk.PreMeetingService;
import us.zoom.sdk.PreMeetingServiceListener;
import us.zoom.sdk.ZoomSDK;

class PreMeetingServiceImpl
implements PreMeetingService,
PTUI.IMeetingMgrListener {
    private ListenerList mListenerList = new ListenerList();

    public PreMeetingServiceImpl(ZoomSDK zoomSdk) {
        PTUI.getInstance().addMeetingMgrListener(this);
    }

    @Override
    public void addListener(PreMeetingServiceListener listener) {
        this.mListenerList.add((IListener)listener);
    }

    @Override
    public void removeListener(PreMeetingServiceListener listener) {
        this.mListenerList.remove((IListener)listener);
    }

    @Override
    public PreMeetingService.ScheduleOrEditMeetingError scheduleMeeting(MeetingItem item) {
        boolean result;
        PTUserProfile myProfile;
        if (item == null) {
            return PreMeetingService.ScheduleOrEditMeetingError.INVALID_PARAMETER;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (profile == null || helper == null) {
            return PreMeetingService.ScheduleOrEditMeetingError.WRONG_USAGE_ERROR;
        }
        if (StringUtil.isEmptyOrNull((String)item.getMeetingTopic())) {
            return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_MEETING_TOPIC;
        }
        if (StringUtil.isEmptyOrNull((String)item.getTimeZoneId())) {
            return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_MEETING_TIMEZONE;
        }
        if (profile.isDisablePSTN() && (item.getAudioType() == MeetingItem.AudioType.AUDIO_TYPE_TELEPHONY || item.getAudioType() == MeetingItem.AudioType.AUDIO_TYPE_VOIP_AND_TELEPHONEY)) {
            return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_MEETING_AUDIO_TYPE;
        }
        if (item.getAudioType() == MeetingItem.AudioType.AUDIO_TYPE_THIRD_PARTY_AUDIO) {
            if (profile.hasSelfTelephony()) {
                if (StringUtil.isEmptyOrNull((String)item.getThirdPartyAudioInfo())) {
                    return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_THIRD_PARTY_AUDIO_INFO;
                }
            } else {
                return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_MEETING_AUDIO_TYPE;
            }
        }
        if (!PTApp.getInstance().isSignedInUserMeetingOn() && item.isOnlySignUserCanJoin()) {
            return PreMeetingService.ScheduleOrEditMeetingError.ONLY_SIGNIN_USER_CAN_JOIN_NOT_SUPPORT;
        }
        MeetingInfo meetingInfo = this.meetingItemToMeetingInfo(null, item, profile);
        String hostId = null;
        String hostEmail = item.getScheduleForHostEmail();
        if (!StringUtil.isEmptyOrNull((String)hostEmail) && (myProfile = PTApp.getInstance().getCurrentUserProfile()) != null && myProfile.getEmail() != null && !hostEmail.equals(myProfile.getEmail())) {
            int count = PTApp.getInstance().getAltHostCount();
            for (int i = 0; i < count; ++i) {
                AlterHost host = PTApp.getInstance().getAltHostAt(i);
                if (host == null || StringUtil.isEmptyOrNull((String)host.getEmail()) || !host.getEmail().equals(hostEmail)) continue;
                hostId = host.getHostID();
                break;
            }
            if (StringUtil.isEmptyOrNull(hostId)) {
                return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_SCHEDULE_FOR_HOST_EMAIL;
            }
        }
        if (result = StringUtil.isEmptyOrNull(hostId) ? helper.scheduleMeeting(meetingInfo, item.getTimeZoneId(), null) : helper.scheduleMeeting(meetingInfo, item.getTimeZoneId(), hostId)) {
            return PreMeetingService.ScheduleOrEditMeetingError.SUCCESS;
        }
        return PreMeetingService.ScheduleOrEditMeetingError.OTHER_ERROR;
    }

    @Override
    public PreMeetingService.ScheduleOrEditMeetingError editMeeting(String meetingId, MeetingItem item) {
        if (meetingId == null || item == null) {
            return PreMeetingService.ScheduleOrEditMeetingError.INVALID_PARAMETER;
        }
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (profile == null || helper == null) {
            return PreMeetingService.ScheduleOrEditMeetingError.WRONG_USAGE_ERROR;
        }
        if (StringUtil.isEmptyOrNull((String)item.getMeetingTopic())) {
            return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_MEETING_TOPIC;
        }
        if (StringUtil.isEmptyOrNull((String)item.getTimeZoneId())) {
            return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_MEETING_TIMEZONE;
        }
        if (profile.isDisablePSTN() && (item.getAudioType() == MeetingItem.AudioType.AUDIO_TYPE_TELEPHONY || item.getAudioType() == MeetingItem.AudioType.AUDIO_TYPE_VOIP_AND_TELEPHONEY)) {
            return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_MEETING_AUDIO_TYPE;
        }
        if (item.getAudioType() == MeetingItem.AudioType.AUDIO_TYPE_THIRD_PARTY_AUDIO) {
            if (profile.hasSelfTelephony()) {
                if (StringUtil.isEmptyOrNull((String)item.getThirdPartyAudioInfo())) {
                    return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_THIRD_PARTY_AUDIO_INFO;
                }
            } else {
                return PreMeetingService.ScheduleOrEditMeetingError.INVAILD_MEETING_AUDIO_TYPE;
            }
        }
        if (!PTApp.getInstance().isSignedInUserMeetingOn() && item.isOnlySignUserCanJoin()) {
            return PreMeetingService.ScheduleOrEditMeetingError.ONLY_SIGNIN_USER_CAN_JOIN_NOT_SUPPORT;
        }
        MeetingInfo meetingInfo = this.meetingItemToMeetingInfo(meetingId, item, profile);
        if (helper.editMeeting(meetingInfo, item.getTimeZoneId())) {
            return PreMeetingService.ScheduleOrEditMeetingError.SUCCESS;
        }
        return PreMeetingService.ScheduleOrEditMeetingError.OTHER_ERROR;
    }

    @Override
    public boolean deleteMeeting(MeetingItem item) {
        if (item == null) {
            return false;
        }
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper != null) {
            long delNo = item.getMeetingNo();
            long origNo = item.getOriginalMeetingNo();
            if (origNo > 0L) {
                delNo = origNo;
            }
            meetingHelper.deleteMeeting(delNo);
        }
        return true;
    }

    @Override
    public boolean listMeeting() {
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper == null) {
            return false;
        }
        return helper.listMeetingUpcoming();
    }

    @Override
    public int getMeetingCount() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return 0;
        }
        return meetingHelper.getMeetingCount();
    }

    @Override
    public MeetingItem getMeetingItemByIndex(int index) {
        if (index < 0) {
            return null;
        }
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return null;
        }
        MeetingInfo mi = meetingHelper.getMeetingItemByIndex(index);
        if (mi == null) {
            return null;
        }
        return this.meetingInfoToMeetingItem(mi);
    }

    @Override
    public MeetingItem getMeetingItemByNumber(long meetingNumber) {
        if (meetingNumber < 0L) {
            return null;
        }
        MeetingHelper helper = PTApp.getInstance().getMeetingHelper();
        if (helper == null) {
            return null;
        }
        MeetingInfo meetingInfo = helper.getMeetingItemByNumber(meetingNumber);
        if (meetingInfo == null) {
            return null;
        }
        return this.meetingInfoToMeetingItem(meetingInfo);
    }

    private MeetingInfo meetingItemToMeetingInfo(String meetingId, MeetingItem item, PTUserProfile profile) {
        MeetingInfo meetingInfo = new MeetingInfo();
        if (item.getMeetingTopic() != null) {
            meetingInfo.setTopic(item.getMeetingTopic());
        }
        meetingInfo.setStartTime(item.getStartTime() / 1000L);
        meetingInfo.setDuration(item.getDurationInMinutes());
        meetingInfo.setType(item.getRepeatType() != 0 ? MeetingInfo.MeetingType.REPEAT : MeetingInfo.MeetingType.SCHEDULE);
        meetingInfo.setRepeatType(item.getRepeatType());
        meetingInfo.setRepeatEndTime(item.getRepeatEndTime() / 1000L);
        meetingInfo.setMeetingNumber(item.getMeetingNo());
        meetingInfo.setOriginalMeetingNumber(item.getOriginalMeetingNo());
        if (meetingId != null) {
            meetingInfo.setId(meetingId);
        }
        if (item.getPassword() != null) {
            meetingInfo.setPassword(item.getPassword());
        }
        meetingInfo.setCanJoinBeforeHost(item.getCanJoinBeforeHost());
        meetingInfo.setHostVideoOff(item.isHostVideoOff());
        meetingInfo.setAttendeeVideoOff(item.isAttendeeVideoOff());
        switch (item.getAudioType()) {
            case AUDIO_TYPE_VOIP: {
                meetingInfo.setVoipOff(false);
                meetingInfo.setTelephonyOff(true);
                break;
            }
            case AUDIO_TYPE_TELEPHONY: {
                if (profile.isDisablePSTN()) break;
                meetingInfo.setVoipOff(true);
                meetingInfo.setTelephonyOff(false);
                break;
            }
            case AUDIO_TYPE_VOIP_AND_TELEPHONEY: {
                if (profile.isDisablePSTN()) break;
                meetingInfo.setVoipOff(false);
                meetingInfo.setTelephonyOff(false);
                break;
            }
            case AUDIO_TYPE_THIRD_PARTY_AUDIO: {
                if (!profile.hasSelfTelephony()) break;
                meetingInfo.setVoipOff(true);
                meetingInfo.setTelephonyOff(true);
                meetingInfo.setIsSelfTelephonyOn(true);
                meetingInfo.setOtherTeleConfInfo(item.getThirdPartyAudioInfo());
            }
        }
        meetingInfo.setUsePmiAsMeetingID(item.isUsePmiAsMeetingID());
        if (PTApp.getInstance().isSignedInUserMeetingOn()) {
            meetingInfo.setIsOnlySignJoin(item.isOnlySignUserCanJoin());
        }
        return meetingInfo;
    }

    private MeetingItem meetingInfoToMeetingItem(MeetingInfo info) {
        MeetingItem item = new MeetingItem();
        item.setMeetingTopic(info.getTopic());
        item.setStartTime(info.getStartTime() * 1000L);
        item.setDurationInMinutes(info.getDuration());
        item.setAsRecurringMeeting(info.getType() == MeetingInfo.MeetingType.REPEAT);
        item.setRepeatType(info.getRepeatType());
        item.setRepeatEndTime(info.getRepeatEndTime() * 1000L);
        item.setMeetingNo(info.getMeetingNumber());
        item.setPassword(info.getPassword());
        item.setMeetingId(info.getId());
        item.setCanJoinBeforeHost(info.getCanJoinBeforeHost());
        item.setHostVideoOff(info.getHostVideoOff());
        item.setAttendeeVideoOff(info.getAttendeeVideoOff());
        if (info.getIsSelfTelephonyOn()) {
            item.setAudioType(MeetingItem.AudioType.AUDIO_TYPE_THIRD_PARTY_AUDIO);
        } else if (!info.getVoipOff() && !info.getTelephonyOff()) {
            item.setAudioType(MeetingItem.AudioType.AUDIO_TYPE_VOIP_AND_TELEPHONEY);
        } else if (!info.getVoipOff()) {
            item.setAudioType(MeetingItem.AudioType.AUDIO_TYPE_VOIP);
        } else if (!info.getTelephonyOff()) {
            item.setAudioType(MeetingItem.AudioType.AUDIO_TYPE_TELEPHONY);
        }
        item.setThirdPartyAudioInfo(info.getOtherTeleConfInfo());
        item.setUsePmiAsMeetingID(info.getUsePmiAsMeetingID());
        item.setOriginalMeetingNo(info.getOriginalMeetingNumber());
        item.setTimeZoneId(info.getTimeZoneId());
        item.setPersonalMeeting(info.getExtendMeetingType() == 1);
        item.setWebinarMeeting(info.getExtendMeetingType() == 2);
        item.setInvitationEmailContentWithTime(info.getInviteEmailContentWithTime());
        item.setOnlySignUserCanJoin(info.getIsOnlySignJoin());
        if (!StringUtil.isEmptyOrNull((String)info.getMeetingHostID())) {
            String email = null;
            PTUserProfile myProfile = PTApp.getInstance().getCurrentUserProfile();
            if (myProfile != null && myProfile.getUserID() != null && info.getMeetingHostID().equals(myProfile.getUserID())) {
                email = myProfile.getEmail();
            } else {
                int count = PTApp.getInstance().getAltHostCount();
                for (int i = 0; i < count; ++i) {
                    AlterHost host = PTApp.getInstance().getAltHostAt(i);
                    if (host == null || StringUtil.isEmptyOrNull((String)host.getHostID()) || !host.getHostID().equals(info.getMeetingHostID())) continue;
                    email = host.getEmail();
                    break;
                }
            }
            item.setScheduleForHostEmail(email);
        }
        return item;
    }

    @Override
    public void onScheduleMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                PreMeetingServiceListener l = (PreMeetingServiceListener)listener;
                if (meetingInfo != null) {
                    long meetingNumber = meetingInfo.getMeetingNumber();
                    if (meetingInfo.getOriginalMeetingNumber() > 0L) {
                        meetingNumber = meetingInfo.getOriginalMeetingNumber();
                    }
                    l.onScheduleMeeting(result, meetingNumber);
                    continue;
                }
                l.onScheduleMeeting(result, 0L);
            }
        }
    }

    @Override
    public void onListMeetingResult(int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                PreMeetingServiceListener l = (PreMeetingServiceListener)listener;
                l.onListMeeting(result);
            }
        }
    }

    @Override
    public void onListCalendarEventsResult(int result) {
    }

    @Override
    public void onDeleteMeetingResult(int result) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                PreMeetingServiceListener l = (PreMeetingServiceListener)listener;
                l.onDeleteMeeting(result);
            }
        }
    }

    @Override
    public void onUpdateMeetingResult(int result, MeetingInfo meetingInfo, String errorMsg) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                PreMeetingServiceListener l = (PreMeetingServiceListener)listener;
                l.onUpdateMeeting(result);
            }
        }
    }

    @Override
    public void onStartFailBeforeLaunch(int result) {
    }

    @Override
    public void onPMIEvent(int event, int result, MeetingInfo item) {
    }
}

