/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import com.zipow.videobox.confapp.ShareSessionMgr;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.sdk.InMeetingRemoteController;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

public class InMeetingRemoteControllerImpl
implements InMeetingRemoteController {
    private ListenerList mListenerList = new ListenerList();
    private ConfUI.IConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
            return InMeetingRemoteControllerImpl.this.sinkUserStatusChanged(cmd, userId);
        }
    };

    public InMeetingRemoteControllerImpl() {
        SdkConfUIBridge.getInstance().addListener(this.mConfUIListener);
    }

    private boolean sinkUserStatusChanged(int cmd, long userId) {
        if (SDKMeetingInterfaceHelper.isInSlientMode()) {
            return true;
        }
        long nodeId = this.getNodeIdByUserId(userId);
        if (nodeId == -1L && cmd != 51) {
            return false;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            block4: for (IListener listener : listeners) {
                InMeetingRemoteController.InMeetingRemoteControlListener l = (InMeetingRemoteController.InMeetingRemoteControlListener)listener;
                switch (cmd) {
                    case 55: {
                        l.onUserGetRemoteControlPrivilege(userId);
                        continue block4;
                    }
                    case 56: {
                        l.remoteControlStarted(userId);
                    }
                }
            }
        }
        return true;
    }

    private long getNodeIdByUserId(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null) {
            return user.getNodeId();
        }
        return -1L;
    }

    @Override
    public void addListener(InMeetingRemoteController.InMeetingRemoteControlListener listener) {
        this.mListenerList.add((IListener)listener);
    }

    @Override
    public void removeListener(InMeetingRemoteController.InMeetingRemoteControlListener listener) {
        this.mListenerList.remove((IListener)listener);
    }

    @Override
    public boolean hasRemoteControlPrivilegeWithUserId(long userID) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        return shareSession.hasRemoteControlPrivilegeWithUserId(userID);
    }

    @Override
    public boolean isRemoteController() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        long myID = ConfMgr.getInstance().getMyself().getNodeId();
        return shareSession.isRemoteController(myID);
    }

    @Override
    public MobileRTCSDKError startRemoteControl() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        boolean ret = shareSession.startRemoteControl();
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError grabRemoteControl() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        long myID = ConfMgr.getInstance().getMyself().getNodeId();
        boolean ret = shareSession.grabRemoteControl(myID);
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError remoteControlSingleTap(float x, float y) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        boolean ret = shareSession.remoteControlSingleTap(x, y);
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError remoteControlDoubleTap(float x, float y) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        boolean ret = shareSession.remoteControlDoubleTap(x, y);
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError remoteControlLongPress(float x, float y) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        boolean ret = shareSession.remoteControlLongPress(x, y);
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError remoteControlDoubleScroll(float x, float y) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        boolean ret = shareSession.remoteControlDoubleScroll(x, y);
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError remoteControlSingleMove(float x, float y) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        boolean ret = shareSession.remoteControlSingleMove(x, y);
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError remoteControlCharInput(String str) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        boolean ret = shareSession.remoteControlCharInput(str);
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError remoteControlKeyInput(InMeetingRemoteController.MobileRTCRemoteControlInputType keyType) {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        int type = 0;
        switch (keyType) {
            case MobileRTCRemoteControl_Del: {
                type = 0;
                break;
            }
            case MobileRTCRemoteControl_Return: {
                type = 1;
            }
        }
        boolean ret = shareSession.remoteControlKeyInput(type);
        if (!ret) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }
}

