/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.util.Base64;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import com.zipow.videobox.confapp.bo.BOMgr;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.sdk.InMeetingLiveStreamController;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

class InMeetingLiveStreamControllerImpl
implements InMeetingLiveStreamController {
    private ConfUI.IConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onConfStatusChanged2(int cmd, long ret) {
            return InMeetingLiveStreamControllerImpl.this.sinkConfStatusChanged2(cmd, ret);
        }
    };
    private ListenerList mListenerList = new ListenerList();

    public InMeetingLiveStreamControllerImpl() {
        SdkConfUIBridge.getInstance().addListener(this.mConfUIListener);
    }

    @Override
    public void addListener(InMeetingLiveStreamController.InMeetingLiveStreamListener listener) {
        this.mListenerList.add((IListener)listener);
    }

    @Override
    public void removeListener(InMeetingLiveStreamController.InMeetingLiveStreamListener listener) {
        this.mListenerList.remove((IListener)listener);
    }

    @Override
    public List<InMeetingLiveStreamController.LiveStreamChannel> getLiveStreamChannels() {
        ArrayList<InMeetingLiveStreamController.LiveStreamChannel> liveStreamChannels = new ArrayList<InMeetingLiveStreamController.LiveStreamChannel>();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return null;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return null;
        }
        int count = confStatus.getLiveChannelsCount();
        for (int i = 0; i < count; ++i) {
            String url;
            String key = confStatus.getLiveChannelKey(i);
            if (key == null || key.length() <= 0 || (url = confContext.getLiveURL(key)) == null || url.length() <= 0) continue;
            liveStreamChannels.add(new InMeetingLiveStreamController.LiveStreamChannel(key, url));
        }
        return liveStreamChannels;
    }

    @Override
    public MobileRTCSDKError startLiveStreamWithStreamingURL(String streamUrl, String streamKey, String broadcastUrl) {
        if (!SDKMeetingInterfaceHelper.isValidCall()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!myself.isHost()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr != null && boMgr.isInBOMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (confStatus.getLiveChannelsCount() <= 0) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        if (StringUtil.isEmptyOrNull((String)streamKey) || StringUtil.isEmptyOrNull((String)streamKey) || StringUtil.isEmptyOrNull((String)broadcastUrl)) {
            return MobileRTCSDKError.SDKERR_INVALID_PARAMETER;
        }
        String stream = streamUrl.endsWith("/") ? streamUrl + streamKey : streamUrl + "/" + streamKey;
        try {
            stream = Base64.encodeToString((byte[])stream.getBytes("utf-8"), (int)2);
            broadcastUrl = Base64.encodeToString((byte[])broadcastUrl.getBytes("utf-8"), (int)2);
        }
        catch (UnsupportedEncodingException e) {
            return MobileRTCSDKError.SDKERR_INVALID_PARAMETER;
        }
        if (StringUtil.isEmptyOrNull((String)stream) || StringUtil.isEmptyOrNull((String)broadcastUrl)) {
            return MobileRTCSDKError.SDKERR_INVALID_PARAMETER;
        }
        String url = "custom|" + broadcastUrl + "|" + stream + "|1";
        if (ConfMgr.getInstance().startLiveChannels(url)) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError stopLiveStream() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!myself.isHost()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isLiveOn()) {
            if (confStatus.stopLive()) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
    }

    private boolean sinkConfStatusChanged2(int cmd, long ret) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            block5: for (IListener listener : listeners) {
                InMeetingLiveStreamController.InMeetingLiveStreamListener l = (InMeetingLiveStreamController.InMeetingLiveStreamListener)listener;
                switch (cmd) {
                    case 47: {
                        if (ret != 1L) continue block5;
                        l.onLiveStreamStatusChange(InMeetingLiveStreamController.MobileRTCLiveStreamStatus.MobileRTCLiveStreamStatus_StartSuccessed);
                        continue block5;
                    }
                    case 48: {
                        l.onLiveStreamStatusChange(InMeetingLiveStreamController.MobileRTCLiveStreamStatus.MobileRTCLiveStreamStatus_StartTimeout);
                        continue block5;
                    }
                    case 49: {
                        l.onLiveStreamStatusChange(InMeetingLiveStreamController.MobileRTCLiveStreamStatus.MobileRTCLiveStreamStatus_StartFailedOrEnded);
                    }
                }
            }
        }
        return true;
    }
}

