/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.util.ZMConfUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.sdk.InMeetingChatController;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

class InMeetingChatControllerImpl
implements InMeetingChatController {
    InMeetingChatControllerImpl() {
    }

    @Override
    public boolean isChatDisabled() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            return confContext.isChatOff();
        }
        return false;
    }

    @Override
    public boolean isPrivateChatDisabled() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            return confContext.isPrivateChatOFF();
        }
        return false;
    }

    @Override
    public MobileRTCSDKError sendChatToUser(long receiver, String content) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confContext == null || myself == null || confStatus == null) {
            return MobileRTCSDKError.SDKERR_UNINITIALIZE;
        }
        if (receiver <= 0L || StringUtil.isEmptyOrNull((String)content)) {
            return MobileRTCSDKError.SDKERR_INVALID_PARAMETER;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(receiver);
        if (user == null || confStatus.isMyself(receiver)) {
            return MobileRTCSDKError.SDKERR_INVALID_PARAMETER;
        }
        if (user.isH323User() || user.isPureCallInUser()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!(myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
            if (confContext.isChatOff()) {
                return MobileRTCSDKError.SDKERR_NO_PERMISSION;
            }
            if (!confContext.isWebinar()) {
                if (!(user.isHost() || user.isCoHost() || user.isBOModerator() || confStatus.getAttendeeChatPriviledge() != 3)) {
                    return MobileRTCSDKError.SDKERR_NO_PERMISSION;
                }
                if (confContext.isPrivateChatOFF()) {
                    return MobileRTCSDKError.SDKERR_NO_PERMISSION;
                }
            } else if (confContext.isPrivateChatOFF() || ConfMgr.getInstance().isViewOnlyMeeting()) {
                return MobileRTCSDKError.SDKERR_NO_PERMISSION;
            }
        }
        boolean result = false;
        if (confContext.isWebinar()) {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(receiver);
            if (buddy != null && !buddy.isOfflineUser()) {
                result = buddy.getRole() == 0 ? ConfMgr.getInstance().sendXmppChatToIndividual(content, buddy.getJID(), true) : ConfMgr.getInstance().sendChatMessageTo(receiver, content, false, false, 0L);
            }
            if (!result || qacomponent == null) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
        } else {
            result = ConfMgr.getInstance().sendChatMessageTo(receiver, content, false, false, 0L);
            if (!result) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public MobileRTCSDKError sendChatToGroup(InMeetingChatController.MobileRTCChatGroup group, String content) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confContext == null || myself == null || confStatus == null) {
            return MobileRTCSDKError.SDKERR_UNINITIALIZE;
        }
        if (StringUtil.isEmptyOrNull((String)content)) {
            return MobileRTCSDKError.SDKERR_INVALID_PARAMETER;
        }
        if (!(myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
            if (confContext.isChatOff()) {
                return MobileRTCSDKError.SDKERR_NO_PERMISSION;
            }
            if (!confContext.isWebinar()) {
                if (confStatus.getAttendeeChatPriviledge() == 3) {
                    return MobileRTCSDKError.SDKERR_NO_PERMISSION;
                }
            } else {
                if (confContext.isPrivateChatOFF()) {
                    return MobileRTCSDKError.SDKERR_NO_PERMISSION;
                }
                if (confStatus.getAttendeeChatPriviledge() == 2 && group == InMeetingChatController.MobileRTCChatGroup.MobileRTCChatGroup_All) {
                    return MobileRTCSDKError.SDKERR_NO_PERMISSION;
                }
                if (ConfMgr.getInstance().isViewOnlyMeeting() && confStatus.getAttendeeChatPriviledge() == 3) {
                    return MobileRTCSDKError.SDKERR_NO_PERMISSION;
                }
            }
        }
        boolean result = false;
        if (confContext.isWebinar()) {
            ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
            if (group == InMeetingChatController.MobileRTCChatGroup.MobileRTCChatGroup_All) {
                result = ConfMgr.getInstance().sendChatMessageTo(0L, content, false, false, 0L);
            } else if (group == InMeetingChatController.MobileRTCChatGroup.MobileRTCChatGroup_Panelists) {
                result = ConfMgr.getInstance().isViewOnlyMeeting() ? ConfMgr.getInstance().sendXmppChatToAllPanelists(content) : ConfMgr.getInstance().sendChatMessageTo(0L, content, true, false, 0L);
            }
            if (!result || qacomponent == null) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
        } else {
            result = ConfMgr.getInstance().sendChatMessageTo(0L, content, false, false, 0L);
            if (!result) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
        }
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }
}

