/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.ptapp.AlterHost;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUserProfile;
import java.util.ArrayList;
import java.util.List;
import us.zoom.sdk.AccountService;
import us.zoom.sdk.Alternativehost;
import us.zoom.sdk.MeetingItem;

class AccoutServiceImpl
implements AccountService {
    AccoutServiceImpl() {
    }

    @Override
    public String getAccountName() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            return profile.getUserName();
        }
        return null;
    }

    @Override
    public String getAccountEmail() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            return profile.getEmail();
        }
        return null;
    }

    @Override
    public MeetingItem.AudioType getDefaultAudioOption() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        MeetingItem.AudioType audioType = MeetingItem.AudioType.AUDIO_TYPE_VOIP_AND_TELEPHONEY;
        if (profile != null) {
            if (profile.isDisablePSTN()) {
                audioType = MeetingItem.AudioType.AUDIO_TYPE_VOIP;
            } else if (profile.alwaysUseTelephonyAsDefaultAudio()) {
                audioType = MeetingItem.AudioType.AUDIO_TYPE_TELEPHONY;
            } else if (profile.alwaysUseBothAsDefaultAudio()) {
                audioType = MeetingItem.AudioType.AUDIO_TYPE_VOIP_AND_TELEPHONEY;
            } else if (profile.alwaysUse3rdPartyAsDefaultAudio()) {
                audioType = MeetingItem.AudioType.AUDIO_TYPE_THIRD_PARTY_AUDIO;
            }
        }
        return audioType;
    }

    @Override
    public boolean isTelephonySupported() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            return !profile.isDisablePSTN();
        }
        return false;
    }

    @Override
    public boolean isThirdPartyAudioSupported() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            return profile.hasSelfTelephony();
        }
        return false;
    }

    @Override
    public String getThirdPartyAudioInfo() {
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null) {
            return profile.getMyTelephoneInfo();
        }
        return null;
    }

    @Override
    public boolean isSignedInUserMeetingOn() {
        return PTApp.getInstance().isSignedInUserMeetingOn();
    }

    @Override
    public List<Alternativehost> getCanScheduleForUsersList() {
        int count = PTApp.getInstance().getAltHostCount();
        if (count > 0) {
            ArrayList<Alternativehost> hostList = new ArrayList<Alternativehost>();
            for (int i = 0; i < count; ++i) {
                AlterHost alterHost = PTApp.getInstance().getAltHostAt(i);
                if (alterHost == null) continue;
                Alternativehost host = new Alternativehost(alterHost.getEmail(), alterHost.getFirstName(), alterHost.getLastName(), alterHost.getPicUrl(), alterHost.getPmi());
                hostList.add(host);
            }
            return hostList;
        }
        return null;
    }
}

