/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.PreferenceUtil;
import org.webrtc.voiceengine.VoiceEnginContext;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;

public class VoiceEngineCompat {
    public static final int AUDIO_DEVICE_API_TYPE_OPENSLES = 0;
    public static final int AUDIO_DEVICE_API_TYPE_JNI = 1;
    private static final String[] SAMSUNG_ChipAECDisabledNonePhoneDevices = new String[]{"GT-P6200", "GT-P6210", "GT-P6800", "GT-P7500", "GT-P7510", "GT-P7100", "GT-P7110", "GT-P739", "GT-P7300", "GT-P7310", "GT-P1000", "GT-P1010"};
    private static final String[] SAMSUNG_BluetoothScoDisabledDevices = new String[]{"GT-P6200", "GT-P6210", "GT-P6800", "GT-P7500", "GT-P7510", "GT-P7100", "GT-P7110", "GT-P739", "GT-P7300", "GT-P7310", "GT-P1000", "GT-P1010", "GT-I9003"};
    private static boolean g_bBlackListBluetoothSco = false;

    public static boolean isChipAECSupported(Context context) {
        if (Build.BRAND.equals("samsung") && HardwareUtil.getCPUKernalNumbers() >= 2) {
            if (Build.MODEL.equals("Galaxy Nexus")) {
                return false;
            }
            if (!VoiceEngineCompat.isFeatureTelephonySupported(context)) {
                for (int i = 0; i < SAMSUNG_ChipAECDisabledNonePhoneDevices.length; ++i) {
                    if (!SAMSUNG_ChipAECDisabledNonePhoneDevices[i].equals(Build.MODEL)) continue;
                    return false;
                }
            }
            return true;
        }
        if ("Amazon".equals(Build.MANUFACTURER)) {
            return true;
        }
        return "Motorola".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && "XT1085".equalsIgnoreCase(Build.MODEL) && OsUtil.isAtLeastL_MR1();
    }

    public static void blacklistBluetoothSco(boolean blacklist) {
        g_bBlackListBluetoothSco = blacklist;
    }

    public static boolean isBluetoothScoSupported() {
        if (g_bBlackListBluetoothSco) {
            return false;
        }
        if ("samsung".equals(Build.BRAND)) {
            for (int i = 0; i < SAMSUNG_BluetoothScoDisabledDevices.length; ++i) {
                if (!SAMSUNG_BluetoothScoDisabledDevices[i].equals(Build.MODEL)) continue;
                return false;
            }
            return VoiceEngineCompat.isBluetoothScoAvailableOffCall();
        }
        if ("realtek".equals(Build.MANUFACTURER) && "phoenix".equals(Build.MODEL)) {
            return false;
        }
        if (VoiceEngineCompat.selectAudioDeviceAPIType((Context)VideoBoxApplication.getInstance()) == 1) {
            int streamType = VoiceEnginContext.getSelectedPlayerStreamType();
            if (streamType < 0) {
                return Build.VERSION.SDK_INT >= 11 && VoiceEngineCompat.isBluetoothScoAvailableOffCall();
            }
            return streamType == 0 && VoiceEngineCompat.isBluetoothScoAvailableOffCall();
        }
        return false;
    }

    private static boolean isBluetoothScoAvailableOffCall() {
        AudioManager audioMgr = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
        if (audioMgr == null) {
            return false;
        }
        return audioMgr.isBluetoothScoAvailableOffCall();
    }

    public static boolean isFeatureTelephonySupported(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    public static boolean isTablet(Context context) {
        return UIUtil.getDisplayMinWidthInDip((Context)context) > 500.0f;
    }

    public static boolean isPlayerConfigurationNativeAPIDisabled(Context context) {
        boolean bRet = false;
        if (Build.VERSION.SDK_INT < 11) {
            bRet = true;
        } else if ("GT-I9003".equalsIgnoreCase(Build.MODEL)) {
            bRet = true;
        } else if ("Nexus 7".equals(Build.MODEL)) {
            bRet = false;
        } else if ("Meizu".equals(Build.MANUFACTURER)) {
            bRet = true;
        } else if (!VoiceEngineCompat.isChipAECSupported(context)) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean isRecorderConfigurationNativeAPIDisabled(Context context) {
        boolean bRet = false;
        if (Build.VERSION.SDK_INT < 11) {
            bRet = true;
        } else if ("Amazon".equals(Build.MANUFACTURER)) {
            bRet = !VoiceEngineCompat.isFeatureTelephonySupported(context);
        } else if ("Nexus 7".equals(Build.MODEL)) {
            bRet = false;
        } else if (!VoiceEngineCompat.isChipAECSupported(context)) {
            bRet = true;
        }
        return bRet;
    }

    public static int selectAudioDeviceAPIType(Context context) {
        String audioAPIType = PreferenceUtil.readStringValue("audioAPIType", null);
        if ("java".equals(audioAPIType)) {
            return 1;
        }
        if ("OpenSLES".equals(audioAPIType)) {
            return 0;
        }
        if ("Amazon".equals(Build.MANUFACTURER)) {
            return 0;
        }
        if ("Meizu".equals(Build.MANUFACTURER)) {
            return 0;
        }
        if ("Motorola".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && Build.MODEL.startsWith("XT")) {
            return 0;
        }
        if ("Dell".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && Build.MODEL.startsWith("Venue7")) {
            return 0;
        }
        if ("Acer".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && Build.MODEL.equals("A1-830")) {
            return 0;
        }
        if ("Lenovo".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL != null && Build.MODEL.equals("Lenovo TB-X103F")) {
            return 0;
        }
        if (context == null) {
            return 0;
        }
        if (VoiceEngineCompat.isPlayerConfigurationNativeAPIDisabled(context) || VoiceEngineCompat.isRecorderConfigurationNativeAPIDisabled(context)) {
            return 1;
        }
        return 0;
    }

    public static boolean isPlayerCommunicationModeAvailable() {
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        String audioAPIType = PreferenceUtil.readStringValue("audioAPIType", null);
        if ("OpenSLES".equals(audioAPIType)) {
            return !VoiceEngineCompat.isPlayerConfigurationNativeAPIDisabled((Context)VideoBoxApplication.getInstance());
        }
        if ("Amazon".equals(Build.MANUFACTURER)) {
            return !VoiceEngineCompat.isPlayerConfigurationNativeAPIDisabled((Context)VideoBoxApplication.getInstance());
        }
        if ("Meizu".equals(Build.MANUFACTURER)) {
            return !VoiceEngineCompat.isPlayerConfigurationNativeAPIDisabled((Context)VideoBoxApplication.getInstance());
        }
        return true;
    }

    public static boolean isAudioSourceVoiceCommunicationDisabled() {
        return Build.VERSION.SDK_INT >= 24 && StringUtil.isSameString((String)Build.MANUFACTURER, (String)"Xiaomi");
    }
}

