/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.view.View;
import com.zipow.videobox.view.video.ZPGLSurfaceView;
import com.zipow.videobox.view.video.ZPGLTextureView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public abstract class VideoRenderer
implements GLSurfaceView.Renderer,
ZPGLTextureView.Renderer {
    private static final String TAG = VideoRenderer.class.getSimpleName();
    private int mWidth = 0;
    private int mHeight = 0;
    private View mGLView;
    private float mFps = 0.0f;
    private boolean mIsStarted = false;
    private boolean mbIntialized = false;
    private Thread mScheduleThread;
    private long mGLThreadId = 0L;
    private boolean mbPaused = false;
    private int mGroupIndex = 0;
    private Handler mHandler = new Handler();

    public VideoRenderer(View glView) {
        this.mGLView = glView;
    }

    public VideoRenderer(View glView, int groupIndex) {
        this.mGLView = glView;
        this.mGroupIndex = groupIndex;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void initialize() {
        this.mbIntialized = true;
    }

    public boolean isInitialized() {
        return this.mbIntialized;
    }

    public void startRenderer(float fps) {
        this.mFps = fps;
        if (this.mIsStarted) {
            return;
        }
        this.mIsStarted = true;
        this.mbPaused = false;
        if (this.mGLView instanceof ZPGLSurfaceView) {
            ((ZPGLSurfaceView)this.mGLView).setRenderMode(0);
        } else if (this.mGLView instanceof ZPGLTextureView) {
            ((ZPGLTextureView)this.mGLView).setRenderMode(0);
        }
        this.mScheduleThread = new Thread("ScheduleRendererThread"){

            @Override
            public void run() {
                do {
                    try {
                        if (!VideoRenderer.this.mbPaused) {
                            VideoRenderer.this.requestRender();
                        }
                        1.sleep((long)(1000.0f / VideoRenderer.this.mFps));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } while (VideoRenderer.this.mIsStarted);
            }
        };
        this.mScheduleThread.start();
    }

    public boolean isRunning() {
        return this.mIsStarted;
    }

    public void pauseRenderer() {
        this.mbPaused = true;
    }

    public void resumeRenderer() {
        this.mbPaused = false;
    }

    public void stopRenderer() {
        this.mIsStarted = false;
        this.mbPaused = true;
        this.mbIntialized = false;
        if (this.mScheduleThread != null && this.mScheduleThread.isAlive()) {
            this.mScheduleThread.interrupt();
            this.mScheduleThread = null;
        }
    }

    protected void requestRender() {
        if (this.mGLView instanceof ZPGLSurfaceView) {
            ((ZPGLSurfaceView)this.mGLView).requestRender();
        } else if (this.mGLView instanceof ZPGLTextureView) {
            ((ZPGLTextureView)this.mGLView).requestRender();
        }
    }

    public void beforeGLContextDestroyed() {
        this.mGLThreadId = Thread.currentThread().getId();
        this.onSurfaceNeedDestroy();
        this.mGLThreadId = 0L;
        this.onGLSurfaceDestoryed();
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        this.onDrawFrame(gl, this);
        this.glRun(this.mGroupIndex);
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mGLThreadId = Thread.currentThread().getId();
        this.mWidth = width;
        this.mHeight = height;
        this.onGLSurfaceChanged(width, height);
        this.glRun(this.mGroupIndex);
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.mGLThreadId = Thread.currentThread().getId();
        this.onGLSurfaceCreated();
        this.glRun(this.mGroupIndex);
    }

    protected void onGLSurfaceCreated() {
    }

    protected void onGLSurfaceChanged(int width, int height) {
    }

    protected void onGLSurfaceDestoryed() {
    }

    protected void onSurfaceNeedDestroy() {
        this.glRun(this.mGroupIndex);
    }

    public abstract void onDrawFrame(GL10 var1, VideoRenderer var2);

    private native void glRun(int var1);
}

