/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import com.zipow.videobox.util.PreferenceUtil;

public class VideoLayoutHelper {
    private static VideoLayoutHelper instance;

    public static synchronized VideoLayoutHelper getInstance() {
        if (instance == null) {
            instance = new VideoLayoutHelper();
        }
        return instance;
    }

    private VideoLayoutHelper() {
    }

    public boolean isHideNoVideoUsersEnabled() {
        return PreferenceUtil.readBooleanValue("hide_no_video_users", false);
    }

    public void setHideNoVideoUsersEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("hide_no_video_users", enabled);
    }

    public boolean isSwitchVideoLayoutAccordingToUserCountEnabled() {
        return PreferenceUtil.readBooleanValue("switch_video_layout_according_to_user_count", false);
    }

    public void setSwitchVideoLayoutAccordingToUserCountEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("switch_video_layout_according_to_user_count", enabled);
    }

    public int getSwitchVideoLayoutUserCountThreshold() {
        return PreferenceUtil.readIntValue("switch_video_layout_user_count_threshold", 3);
    }

    public void setSwitchVideoLayoutUserCountThreshold(int value) {
        if (value < 2) {
            return;
        }
        PreferenceUtil.saveIntValue("switch_video_layout_user_count_threshold", value);
    }

    public void setGalleryViewCapacity(int cap) {
        if (cap < 0) {
            cap = 0;
        }
        if (cap > 25) {
            cap = 25;
        }
        PreferenceUtil.saveIntValue("gallery_view_capcity", cap);
    }

    public int getGalleryViewCapacity() {
        int cap = PreferenceUtil.readIntValue("gallery_view_capcity", 0);
        if (cap < 0) {
            cap = 0;
        }
        if (cap > 25) {
            cap = 25;
        }
        return cap;
    }
}

