/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.view.NormalMessageTip;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.ShareVideoScene;
import com.zipow.videobox.view.video.VideoSceneMgr;
import us.zoom.androidlib.util.AccessibilityUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class RCFloatView
extends LinearLayout
implements View.OnClickListener {
    private static final String RC_TAP_MESSAGE_TIP_TAG = "RC_TAP";
    private ImageView mIvRCControl;
    private ImageView mIvKeyboard;
    private ImageView mIvQuestion;
    private EditText mHiddenEditText;
    private ViewGroup mVGContentSpan;
    private ViewGroup mVGFloatPanel;
    private GestureDetector mGestureDetector;
    private int mDraggingPointerIndex = -1;
    private boolean mbPosChanged = false;
    private float mDownRawX = 0.0f;
    private float mDownRawY = 0.0f;
    private int mPosXStartDrag = 0;
    private int mPosYStartDrag = 0;
    private boolean mCleanHiddenEditText = false;
    private IRemoteControlButtonStatusListener iEnabledRemoteControlListener;
    private ConfActivityNormal mActivity;
    private Dialog mHelpDialog;
    private Handler mHandler = new Handler();
    Runnable mFirstFocusRunnabel = new Runnable(){

        @Override
        public void run() {
            AccessibilityUtil.sendAccessibilityFocusEvent((View)RCFloatView.this.mIvRCControl);
        }
    };

    public void setRemoteControlButtonStatusListener(IRemoteControlButtonStatusListener iEnabledRemoteControlListener) {
        this.iEnabledRemoteControlListener = iEnabledRemoteControlListener;
    }

    public RCFloatView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public RCFloatView(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mActivity = (ConfActivityNormal)context;
        this.mHelpDialog = new Dialog(context);
        this.mHelpDialog.requestWindowFeature(1);
        this.mHelpDialog.setContentView(R.layout.zm_rc_fingers_question);
        this.mHelpDialog.setCanceledOnTouchOutside(true);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = inflater.inflate(R.layout.zm_rc_float_view, (ViewGroup)this);
        this.mIvRCControl = (ImageView)view.findViewById(R.id.rc_control);
        this.mIvKeyboard = (ImageView)view.findViewById(R.id.rc_keyboard);
        this.mIvQuestion = (ImageView)view.findViewById(R.id.rc_question);
        this.mVGContentSpan = (ViewGroup)view.findViewById(R.id.rc_content_span);
        this.mHiddenEditText = (EditText)view.findViewById(R.id.rc_hidden_edit);
        this.mVGFloatPanel = (ViewGroup)view.findViewById(R.id.rc_float_panel);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MoveGesture());
        this.mIvRCControl.setOnClickListener((View.OnClickListener)this);
        this.mIvRCControl.setImageResource(R.drawable.zm_rc_control);
        this.mIvQuestion.setOnClickListener((View.OnClickListener)this);
        this.mVGContentSpan.setVisibility(4);
        this.mIvKeyboard.setOnClickListener((View.OnClickListener)this);
        this.mHiddenEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (RCFloatView.this.mCleanHiddenEditText) {
                    return;
                }
                ShareVideoScene shareVideoScene = RCFloatView.this.mActivity.getShareVideoScene();
                if (shareVideoScene == null) {
                    return;
                }
                if (count > 0) {
                    for (int i = 0; i < before; ++i) {
                        shareVideoScene.remoteControlKeyInput(0);
                    }
                }
                CharSequence ss = s.subSequence(start, s.length());
                if (count == 1 && ss.equals("\n")) {
                    shareVideoScene.remoteControlKeyInput(1);
                } else {
                    shareVideoScene.remoteControlCharInput(ss.toString());
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                if (s.length() > 100) {
                    RCFloatView.this.mCleanHiddenEditText = true;
                    RCFloatView.this.mHiddenEditText.setText((CharSequence)"");
                } else {
                    RCFloatView.this.mCleanHiddenEditText = false;
                }
            }
        });
        String message = this.getMessage();
        if (!StringUtil.isEmptyOrNull((String)message)) {
            this.mIvRCControl.setContentDescription((CharSequence)message);
        }
    }

    public void enableRC(boolean enable) {
        if (enable) {
            String message;
            this.mVGContentSpan.setVisibility(0);
            this.mIvRCControl.setImageResource(R.drawable.zm_rc_control_reverse_bg);
            this.mVGFloatPanel.setBackgroundResource(R.drawable.zm_rc_drawer);
            if (this.iEnabledRemoteControlListener != null) {
                this.iEnabledRemoteControlListener.onEnabledRC(true);
            }
            if (!StringUtil.isEmptyOrNull((String)(message = this.getMessage()))) {
                this.mIvRCControl.setContentDescription((CharSequence)message);
            }
        } else {
            this.mVGContentSpan.setVisibility(4);
            this.mIvRCControl.setImageResource(R.drawable.zm_rc_control);
            this.mVGFloatPanel.setBackgroundResource(0);
            this.showKeyboard(false);
            if (this.mHelpDialog.isShowing()) {
                this.mHelpDialog.dismiss();
            }
            if (this.iEnabledRemoteControlListener != null) {
                this.iEnabledRemoteControlListener.onEnabledRC(false);
            }
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        if (params != null) {
            this.correctPostion(params.leftMargin, params.topMargin);
        }
    }

    private void showRCTapMessageTip() {
        String message = this.getMessage();
        if (!StringUtil.isEmptyOrNull((String)message)) {
            this.mIvRCControl.setContentDescription((CharSequence)message);
            NormalMessageTip.show(this.mActivity.getSupportFragmentManager(), RC_TAP_MESSAGE_TIP_TAG, null, message, R.id.rc_control, 3, false);
        }
    }

    public void showRCFloatView(boolean show, boolean isFirst) {
        if (show) {
            AbsVideoSceneMgr videoSceneMgr;
            FrameLayout.LayoutParams params;
            View parent = (View)this.getParent();
            if (parent == null) {
                return;
            }
            if (!this.mbPosChanged && (params = (FrameLayout.LayoutParams)this.getLayoutParams()) != null) {
                params.topMargin = parent.getHeight() - UIUtil.dip2px((Context)this.mActivity, (float)150.0f);
                params.leftMargin = UIUtil.dip2px((Context)this.mActivity, (float)50.0f);
                this.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            this.setVisibility(0);
            if (isFirst) {
                this.showRCTapMessageTip();
            }
            if ((videoSceneMgr = this.mActivity.getVideoSceneMgr()) != null && videoSceneMgr instanceof VideoSceneMgr) {
                ((VideoSceneMgr)videoSceneMgr).switchToDefaultScene();
            }
        } else {
            this.setVisibility(8);
            if (this.mHelpDialog.isShowing()) {
                this.mHelpDialog.dismiss();
            }
            NormalMessageTip.dismiss(this.mActivity.getSupportFragmentManager(), RC_TAP_MESSAGE_TIP_TAG);
        }
        ShareVideoScene shareVideoScene = this.mActivity.getShareVideoScene();
        this.enableRC(shareVideoScene != null && shareVideoScene.isInRemoteControlMode());
        this.showKeyboard(false);
        if (isFirst && show) {
            this.mHandler.removeCallbacks(this.mFirstFocusRunnabel);
            this.mHandler.postDelayed(this.mFirstFocusRunnabel, 200L);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int y;
        int x;
        if (event == null) {
            return super.dispatchTouchEvent(null);
        }
        if (event.getActionMasked() == 0 && this.mDraggingPointerIndex < 0) {
            NormalMessageTip.dismiss(this.mActivity.getSupportFragmentManager(), RC_TAP_MESSAGE_TIP_TAG);
            int actionPointerIndex = event.getActionIndex();
            this.mDownRawX = event.getRawX();
            this.mDownRawY = event.getRawY();
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
            if (params != null) {
                this.mPosXStartDrag = params.leftMargin;
                this.mPosYStartDrag = params.topMargin;
            }
            if (this.mVGContentSpan.getVisibility() == 4) {
                Rect rect = new Rect(this.mIvRCControl.getLeft(), this.mIvRCControl.getTop(), this.mIvRCControl.getRight(), this.mIvRCControl.getBottom());
                if (rect.contains((int)event.getX(actionPointerIndex), (int)event.getY(actionPointerIndex))) {
                    this.mDraggingPointerIndex = actionPointerIndex;
                }
            } else {
                this.mDraggingPointerIndex = actionPointerIndex;
            }
        } else if (event.getAction() == 1 && event.getActionIndex() == this.mDraggingPointerIndex) {
            this.mDraggingPointerIndex = -1;
        } else if (event.getActionMasked() == 2 && this.mDraggingPointerIndex >= 0 && event.getActionIndex() == this.mDraggingPointerIndex && this.correctPostion(x = (int)((float)this.mPosXStartDrag + event.getRawX() - this.mDownRawX), y = (int)((float)this.mPosYStartDrag + event.getRawY() - this.mDownRawY))) {
            this.mbPosChanged = true;
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        return super.onInterceptTouchEvent(event);
    }

    protected void onDetachedFromWindow() {
        this.mHandler.removeCallbacksAndMessages(null);
        super.onDetachedFromWindow();
    }

    private boolean correctPostion(int x, int y) {
        FrameLayout.LayoutParams params;
        int widthSpec;
        int heightSpec = widthSpec = View.MeasureSpec.makeMeasureSpec((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE);
        this.measure(widthSpec, heightSpec);
        int width = this.mVGContentSpan.getVisibility() == 0 ? this.getMeasuredWidth() : this.mIvRCControl.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        View parent = (View)this.getParent();
        if (parent == null) {
            return false;
        }
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + width > parentWidth) {
            x = parentWidth - width;
        }
        if (y + height > parentHeight) {
            y = parentHeight - height;
        }
        if ((params = (FrameLayout.LayoutParams)this.getLayoutParams()) == null) {
            return false;
        }
        if (params.topMargin != y || params.leftMargin != x) {
            params.topMargin = y;
            params.leftMargin = x;
            this.setLayoutParams((ViewGroup.LayoutParams)params);
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        if (v == this.mIvRCControl) {
            ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
            if (shareSession == null) {
                return;
            }
            ConfMgr confMgr = ConfMgr.getInstance();
            if (confMgr == null || confMgr.getMyself() == null) {
                return;
            }
            long myUserId = confMgr.getMyself().getNodeId();
            if (shareSession.isRemoteController(myUserId)) {
                this.enableRC(this.mVGContentSpan.getVisibility() != 0);
            } else {
                shareSession.grabRemoteControl(confMgr.getMyself().getNodeId());
            }
            NormalMessageTip.dismiss(this.mActivity.getSupportFragmentManager(), RC_TAP_MESSAGE_TIP_TAG);
        } else if (v == this.mIvKeyboard) {
            this.showKeyboard(true);
        } else if (v == this.mIvQuestion) {
            this.mHelpDialog.show();
        }
    }

    public void onConfLayoutChanged(int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        if (params != null) {
            this.correctPostion(params.leftMargin, params.topMargin);
        }
    }

    private void showKeyboard(boolean show) {
        if (show) {
            UIUtil.openSoftKeyboard((Context)this.getContext(), (View)this.mHiddenEditText);
        } else {
            UIUtil.closeSoftKeyboard((Context)this.getContext(), (View)this.mHiddenEditText);
        }
    }

    public boolean isControlling() {
        return this.mVGContentSpan.getVisibility() == 0;
    }

    private String getMessage() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return null;
        }
        long userID = shareSession.getActiveUserID();
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return null;
        }
        CmmUser user = confMgr.getUserById(userID);
        if (user == null) {
            return null;
        }
        String shareUsername = user.getScreenName();
        String messageFormat = this.mActivity.getString(R.string.zm_rc_tap_notice);
        return String.format(messageFormat, shareUsername);
    }

    private class MoveGesture
    extends GestureDetector.SimpleOnGestureListener {
        private MoveGesture() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return true;
        }
    }

    public static interface IRemoteControlButtonStatusListener {
        public void onEnabledRC(boolean var1);
    }
}

