/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.share.ShareView;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.ShareVideoScene;
import com.zipow.videobox.view.video.VideoRenderer;
import java.util.ArrayList;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class LargeShareVideoScene
extends ShareVideoScene {
    private final String TAG = LargeShareVideoScene.class.getSimpleName();
    private static final int GALLERY_ITEMS_PORTRAIT_COUNT = 3;
    private static final int GALLERY_ITEMS_PHONE_LANDSCAPE_COUNT = 4;
    private static final int GALLERY_ITEMS_TABLET_LANDSCAPE_COUNT = 6;
    private static final int MAX_GALLERY_ITEMS_PHONE_COUNT = 4;
    private static final int MAX_GALLERY_ITEMS_TABLET_COUNT = 6;
    private static final int GALLERY_UNIT_MARGIN_DIP = 3;
    private static final int GALLERY_lIST_MARGIN_lANDSCAPE_DIP = 2;
    private static final int GALLERY_lIST_MARGIN_PORTRAIT_DIP = 4;
    private static final int GALLERY_ACTION_BAR_DIP = 20;
    private int mCountUsers = 1;
    private int mGalleryScrollPosX = 0;
    private int mGalleryScrollPosY = 0;
    private boolean mIsScrollingGallery = false;
    private ArrayList<VideoUnit> mListGalleryUnits = new ArrayList();
    private boolean mIsGalleryVideoViewExpand = true;
    View.OnClickListener ExpandGalleryViewlistener = new View.OnClickListener(){

        public void onClick(View v) {
            LargeShareVideoScene.this.showOrHideGalleryVideoUnits(!LargeShareVideoScene.this.mIsGalleryVideoViewExpand);
        }
    };

    public LargeShareVideoScene(AbsVideoSceneMgr sceneMgr) {
        super(sceneMgr);
    }

    @Override
    protected void onCreateUnits() {
        if (this.mIsGalleryVideoViewExpand) {
            this.createGalleryUnits();
        }
        this.updateShareToolbarBtnPosition();
        super.onCreateUnits();
    }

    private void createGalleryUnits() {
        if (this.mListGalleryUnits != null && this.mListGalleryUnits.size() > 0) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        for (int i = 0; i <= this.getMaxGalleryItemsCount(); ++i) {
            VideoUnit unit;
            RendererUnitInfo unitInfo = this.createGalleryUnitInfo(i);
            if (unitInfo == null || (unit = videoMgr.createVideoUnit(false, unitInfo)) == null) continue;
            unit.setUnitName("GalleryUnit");
            unit.setVideoScene(this);
            unit.setBorderVisible(false);
            unit.setBackgroundColor(0);
            unit.setUserNameVisible(true);
            unit.setCanShowAudioOff(true);
            this.addUnit(unit);
            unit.onCreate();
            this.mListGalleryUnits.add(unit);
        }
    }

    private RendererUnitInfo createGalleryUnitInfo(int index) {
        int sceneWidth = this.getWidth();
        int sceneHeight = this.getHeight();
        int unitMargin = this.getGalleryUnitMargin();
        int unitWidth = 0;
        int unitHeight = 0;
        int x = 0;
        int y = 0;
        int posFirstUnit = 0;
        if (sceneHeight > sceneWidth) {
            unitWidth = this.getGalleryUnitPortraitWidth();
            unitHeight = unitWidth * 9 / 16;
            if (this.mCountUsers <= 3) {
                posFirstUnit = (sceneWidth - this.mCountUsers * (unitWidth + unitMargin) - unitMargin) / 2 + unitMargin;
                this.mGalleryScrollPosX = 0;
            } else {
                posFirstUnit = this.mGalleryScrollPosX < 0 ? -this.mGalleryScrollPosX + unitMargin : unitMargin - this.mGalleryScrollPosX % (unitWidth + unitMargin);
            }
            x = posFirstUnit + index * (unitWidth + unitMargin);
            y = this.getHeight() - unitHeight - this.getGalleryListPortraitMargin();
            if (index == 3 && Math.abs(this.getWidth() - x) < 3) {
                x = this.getWidth();
            }
        } else {
            unitHeight = this.getGalleryUnitLandscapeHeight();
            unitWidth = unitHeight * 16 / 9;
            if (this.mCountUsers <= this.getGalleryItemsLandscapeCount()) {
                posFirstUnit = (sceneHeight - this.mCountUsers * (unitHeight + unitMargin) - unitMargin) / 2 + unitMargin;
                this.mGalleryScrollPosY = 0;
            } else {
                posFirstUnit = this.mGalleryScrollPosY < 0 ? -this.mGalleryScrollPosY + unitMargin : unitMargin - this.mGalleryScrollPosY % (unitHeight + unitMargin);
            }
            y = posFirstUnit + index * (unitHeight + unitMargin);
            x = this.getWidth() - unitWidth - this.getGalleryListLandscapeMargin();
            if (index == this.getGalleryItemsLandscapeCount() && Math.abs(this.getHeight() - y) < 3) {
                y = this.getHeight();
            }
        }
        return new RendererUnitInfo(this.getLeft() + x, this.getTop() + y, unitWidth, unitHeight);
    }

    private void updateGalleryUnits() {
        if (this.mListGalleryUnits == null || this.mListGalleryUnits.size() == 0) {
            return;
        }
        for (int i = 0; i <= this.getGalleryItemsCount(); ++i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            RendererUnitInfo unitInfo = this.createGalleryUnitInfo(i);
            if (unit == null || unitInfo == null) continue;
            unit.updateUnitInfo(unitInfo);
        }
    }

    @Override
    protected void onUpdateUnits() {
        this.checkUpdateGalleryUnitsVideo();
        this.updateGalleryViewExpandButton();
        super.onUpdateUnits();
    }

    @Override
    protected void onDestroyUnits() {
        if (this.mListGalleryUnits != null) {
            this.mListGalleryUnits.clear();
        }
        super.onDestroyUnits();
    }

    @Override
    protected void onStart() {
        this.mCountUsers = !ConfMgr.getInstance().isViewOnlyMeeting() ? ConfLocalHelper.getTotalVideoCount() : 1;
        if (this.mCountUsers < 1) {
            this.mCountUsers = 1;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                if (!LargeShareVideoScene.this.isPreloadStatus()) {
                    LargeShareVideoScene.this.checkUpdateGalleryUnitsVideo();
                }
            }
        });
        super.onStart();
    }

    @Override
    public void updateContentSubscription() {
        if (!this.isPreloadStatus()) {
            this.checkUpdateGalleryUnitsVideo();
        }
        super.updateContentSubscription();
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mListGalleryUnits != null) {
            for (int i = 0; i < this.mListGalleryUnits.size(); ++i) {
                VideoUnit unit = this.mListGalleryUnits.get(i);
                if (unit == null) continue;
                unit.removeUser();
            }
        }
        this.updateGalleryViewExpandButton();
    }

    @Override
    protected void onResumeVideo() {
        if (!this.isPreloadStatus()) {
            this.checkUpdateGalleryUnitsVideo();
        }
        super.onResumeVideo();
    }

    @Override
    public void onUserAudioStatus(final long userId) {
        super.onUserAudioStatus(userId);
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeShareVideoScene.this.updateUserAudioStatus(userId);
            }
        });
    }

    private void updateUserAudioStatus(long userId) {
        if (this.mListGalleryUnits == null || this.mListGalleryUnits.size() == 0) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        for (int i = 0; i < this.getMaxGalleryItemsCount(); ++i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            if (unit == null || unit.getUser() == 0L || !confStatus.isSameUser(userId, unit.getUser())) continue;
            unit.onUserAudioStatus();
        }
    }

    @Override
    public void onUserVideoStatus(long userId) {
        super.onUserVideoStatus(userId);
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeShareVideoScene.this.checkUpdateGalleryUnitsVideo();
            }
        });
        super.onUserVideoStatus(userId);
    }

    @Override
    public void onUserVideoDataSizeChanged(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeShareVideoScene.this.checkUpdateGalleryUnitsVideo();
            }
        });
        super.onUserVideoDataSizeChanged(userId);
    }

    @Override
    public void onActiveVideoChanged(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeShareVideoScene.this.checkUpdateGalleryUnitsVideo();
            }
        });
        super.onActiveVideoChanged(userId);
    }

    @Override
    public void onUserEvent(int eventType, long userId, int flag) {
        if (this.isPreloadStatus()) {
            return;
        }
        this.mCountUsers = !ConfMgr.getInstance().isViewOnlyMeeting() ? ConfLocalHelper.getTotalVideoCount() : 1;
        if (this.mCountUsers <= 3) {
            this.mGalleryScrollPosX = 0;
        }
        if (this.mCountUsers <= this.getGalleryItemsLandscapeCount()) {
            this.mGalleryScrollPosY = 0;
        }
        int marginGallery = this.getGalleryUnitMargin();
        if (this.getHeight() > this.getWidth()) {
            if (this.mCountUsers >= 3) {
                int unitWidth = this.getGalleryUnitPortraitWidth();
                if (this.mGalleryScrollPosX + (marginGallery + unitWidth) * 3 > this.mCountUsers * (marginGallery + unitWidth)) {
                    this.mGalleryScrollPosX = this.mCountUsers * (marginGallery + unitWidth) - (marginGallery + unitWidth) * 3;
                }
                this.onScrollGalleryEnd();
            } else {
                this.checkUpdateGalleryUnitsVideo();
            }
            this.mGalleryScrollPosY = 0;
        } else {
            if (this.mCountUsers >= this.getGalleryItemsLandscapeCount()) {
                int unitHeight = this.getGalleryUnitLandscapeHeight();
                if (this.mGalleryScrollPosY + (marginGallery + unitHeight) * this.getGalleryItemsLandscapeCount() > this.mCountUsers * (marginGallery + unitHeight)) {
                    this.mGalleryScrollPosY = this.mCountUsers * (marginGallery + unitHeight) - (marginGallery + unitHeight) * this.getGalleryItemsLandscapeCount();
                }
                this.onScrollGalleryEnd();
            } else {
                this.checkUpdateGalleryUnitsVideo();
            }
            this.mGalleryScrollPosX = 0;
        }
        super.onUserEvent(eventType, userId, flag);
    }

    private void checkUpdateGalleryUnitsVideo() {
        if (this.mListGalleryUnits == null || this.mListGalleryUnits.size() == 0) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        int unitWidth = this.getGalleryUnitPortraitWidth();
        int unitHeight = this.getGalleryUnitLandscapeHeight();
        int unitMargin = this.getGalleryUnitMargin();
        long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
        for (int i = 0; i <= this.getMaxGalleryItemsCount(); ++i) {
            int userIndex;
            VideoUnit unit = this.mListGalleryUnits.get(i);
            RendererUnitInfo unitInfo = this.createGalleryUnitInfo(i);
            unit.updateUnitInfo(unitInfo);
            long userId = 0L;
            if (this.getHeight() > this.getWidth()) {
                if (this.mGalleryScrollPosX >= 0) {
                    userIndex = this.mGalleryScrollPosX / (unitWidth + unitMargin) + i;
                    userId = this.getGalleryUnitUserId(userIndex);
                } else {
                    userId = this.getGalleryUnitUserId(i);
                }
            } else if (this.mGalleryScrollPosY >= 0) {
                userIndex = this.mGalleryScrollPosY / (unitHeight + unitMargin) + i;
                userId = this.getGalleryUnitUserId(userIndex);
            } else {
                userId = this.getGalleryUnitUserId(i);
            }
            if (!this.isVideoPaused()) {
                if (userId == 0L) {
                    unit.stopVideo(true);
                    unit.removeUser();
                    unit.setBorderVisible(false);
                    unit.setBackgroundColor(0);
                    continue;
                }
                boolean stop = false;
                if (this.getHeight() > this.getWidth()) {
                    if (unitInfo.left < -unitInfo.width * 2 / 3 || unitInfo.left + unitInfo.width > this.getWidth() + unitInfo.width * 2 / 3) {
                        stop = true;
                    }
                } else if (unitInfo.top < -unitInfo.height * 2 / 3 || unitInfo.top + unitInfo.height > this.getHeight() + unitInfo.height * 2 / 3) {
                    stop = true;
                }
                if (stop) {
                    unit.removeUser();
                } else {
                    if (this.mIsScrollingGallery) {
                        unit.pause();
                    } else {
                        unit.resume();
                    }
                    unit.setType(0);
                    unit.setUser(userId);
                    long activeUserId = this.getVideoSceneMgr().getActiveSpeakerId();
                    CmmUser user = ConfMgr.getInstance().getUserById(activeUserId);
                    if (user != null) {
                        activeUserId = user.getNodeId();
                    }
                    if (!ConfMgr.getInstance().isViewOnlyMeeting()) {
                        if (lockedUserId == 0L && confStatus.isSameUser(userId, activeUserId)) {
                            unit.setBorderType(1);
                        } else if (userId == lockedUserId) {
                            unit.setBorderType(2);
                        } else {
                            unit.setBorderType(0);
                        }
                    } else {
                        unit.setBorderType(0);
                    }
                }
                unit.setBorderVisible(true);
                unit.setBackgroundColor(-16777216);
                continue;
            }
            if (unit.getUser() != 0L) {
                unit.removeUser();
            }
            unit.clearRenderer();
            unit.setBorderVisible(true);
            if (userId == 0L) {
                unit.setBorderVisible(false);
                unit.setBackgroundColor(0);
                continue;
            }
            unit.setBackgroundColor(-16777216);
            unit.setBorderType(0);
        }
    }

    private long getGalleryUnitUserId(int userIndex) {
        if (ConfMgr.getInstance().isViewOnlyMeeting()) {
            if (userIndex == 0) {
                return 1L;
            }
            return 0L;
        }
        if (userIndex == 0) {
            return ConfMgr.getInstance().getMyself().getNodeId();
        }
        int idx = 1;
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (confStatus == null || userList == null) {
            return 0L;
        }
        for (int i = 0; i < userList.getUserCount(); ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user.isMMRUser() || confStatus.isMyself(user.getNodeId())) continue;
            if (idx == userIndex) {
                return user.getNodeId();
            }
            ++idx;
        }
        return 0L;
    }

    @Override
    public void onDoubleTap(MotionEvent e) {
        if (!this.isOnGallery(e)) {
            super.onDoubleTap(e);
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent e) {
        if (super.onTouchEvent(e)) {
            return true;
        }
        if (this.mIsScrollingGallery && e.getPointerCount() == 1 && e.getActionMasked() == 1) {
            this.onScrollGalleryEnd();
        }
        return false;
    }

    @Override
    public boolean canDragSceneToLeft() {
        return false;
    }

    @Override
    public boolean canDragSceneToRight() {
        return !this.mIsScrollingGallery && super.canDragSceneToRight();
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.isOnGallery(e2)) {
            if (this.getHeight() > this.getWidth()) {
                this.onScrollGalleryX((int)distanceX);
            } else {
                this.onScrollGalleryY((int)distanceY);
            }
        } else {
            super.onScroll(e1, e2, distanceX, distanceY);
        }
    }

    @Override
    public void onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.isOnGallery(e1)) {
            return;
        }
        super.onFling(e1, e2, velocityX, velocityY);
    }

    private void onScrollGalleryX(int distanceX) {
        int i;
        int unitWidth;
        int unitMargin;
        int maxGalleryScrollPos;
        if (this.mCountUsers <= 3) {
            if (this.mIsScrollingGallery) {
                this.onScrollGalleryEnd();
            }
            return;
        }
        int lastScrollPos = this.mGalleryScrollPosX;
        this.mGalleryScrollPosX += distanceX;
        if (this.mGalleryScrollPosX < 0) {
            this.mGalleryScrollPosX = 0;
        }
        if (this.mGalleryScrollPosX > (maxGalleryScrollPos = (this.mCountUsers - 3) * ((unitMargin = this.getGalleryUnitMargin()) + (unitWidth = this.getGalleryUnitPortraitWidth())))) {
            this.mGalleryScrollPosX = maxGalleryScrollPos;
        }
        if (lastScrollPos == this.mGalleryScrollPosX) {
            return;
        }
        distanceX = this.mGalleryScrollPosX - lastScrollPos;
        int outCount = 0;
        for (i = 0; i <= 3; ++i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            if (unit.getRight() - distanceX <= 0) {
                unit.stopVideo(true);
                unit.removeUser();
                ++outCount;
                continue;
            }
            if (this.mGalleryScrollPosX <= 0 || unit.getLeft() - distanceX <= this.getWidth()) continue;
            unit.stopVideo(true);
            unit.removeUser();
            ++outCount;
        }
        if (distanceX > 0) {
            for (i = 0; i < outCount; ++i) {
                this.mListGalleryUnits.add(this.mListGalleryUnits.remove(0));
            }
        } else {
            for (i = 0; i < outCount; ++i) {
                this.mListGalleryUnits.add(0, this.mListGalleryUnits.remove(3));
            }
        }
        this.checkUpdateGalleryUnitsVideo();
        this.mIsScrollingGallery = true;
    }

    private void onScrollGalleryY(int distanceY) {
        int i;
        if (this.mCountUsers <= this.getGalleryItemsLandscapeCount()) {
            if (this.mIsScrollingGallery) {
                this.onScrollGalleryEnd();
            }
            return;
        }
        int lastScrollPos = this.mGalleryScrollPosY;
        this.mGalleryScrollPosY += distanceY;
        if (this.mGalleryScrollPosY < 0) {
            this.mGalleryScrollPosY = 0;
        }
        int unitMargin = this.getGalleryUnitMargin();
        int unitHeight = this.getGalleryUnitLandscapeHeight();
        int maxGalleryScrollPos = (this.mCountUsers - this.getGalleryItemsLandscapeCount()) * (unitMargin + unitHeight);
        if (this.mGalleryScrollPosY > maxGalleryScrollPos) {
            this.mGalleryScrollPosY = maxGalleryScrollPos;
        }
        if (lastScrollPos == this.mGalleryScrollPosY) {
            return;
        }
        distanceY = this.mGalleryScrollPosY - lastScrollPos;
        int outCount = 0;
        for (i = 0; i <= this.getGalleryItemsLandscapeCount(); ++i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            if (unit.getBottom() - distanceY <= 0) {
                unit.stopVideo(true);
                unit.removeUser();
                ++outCount;
                continue;
            }
            if (this.mGalleryScrollPosY <= 0 || unit.getTop() - distanceY <= this.getHeight()) continue;
            unit.stopVideo(true);
            unit.removeUser();
            ++outCount;
        }
        if (distanceY > 0) {
            for (i = 0; i < outCount; ++i) {
                this.mListGalleryUnits.add(this.mListGalleryUnits.remove(0));
            }
        } else {
            for (i = 0; i < outCount; ++i) {
                this.mListGalleryUnits.add(0, this.mListGalleryUnits.remove(this.getGalleryItemsLandscapeCount()));
            }
        }
        this.checkUpdateGalleryUnitsVideo();
        this.mIsScrollingGallery = true;
    }

    private boolean isOnGallery(MotionEvent evt) {
        if (this.mListGalleryUnits == null || this.mListGalleryUnits.size() == 0) {
            return false;
        }
        float x = evt.getX();
        float y = evt.getY();
        VideoUnit firstUnit = this.mListGalleryUnits.get(0);
        if (firstUnit == null) {
            return false;
        }
        if (this.getHeight() > this.getWidth()) {
            return y >= (float)firstUnit.getTop() && y < (float)firstUnit.getBottom();
        }
        return x >= (float)firstUnit.getLeft() && x < (float)firstUnit.getRight();
    }

    private void onScrollGalleryEnd() {
        if (this.mListGalleryUnits == null || this.mListGalleryUnits.size() == 0) {
            return;
        }
        int marginGallery = this.getGalleryUnitMargin();
        this.mIsScrollingGallery = false;
        VideoUnit lastUnit = this.mListGalleryUnits.get(this.getGalleryItemsCount());
        VideoUnit firstUnit = this.mListGalleryUnits.get(0);
        VideoUnit lastVisibleUnit = null;
        for (int i = this.getGalleryItemsCount(); i >= 0; --i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            if (!unit.isBorderVisible()) continue;
            lastVisibleUnit = unit;
            break;
        }
        if (this.getHeight() > this.getWidth()) {
            int unitWidth = firstUnit.getWidth();
            if (lastVisibleUnit != null && lastVisibleUnit.getRight() < 3 * (marginGallery + unitWidth)) {
                int idx = this.mCountUsers - 3;
                if (idx == 0) {
                    idx = 0;
                }
                this.scrollGalleryToUnitAtX(idx, marginGallery, unitWidth);
            } else if (firstUnit.getLeft() > marginGallery) {
                this.scrollGalleryToUnitAtX(0, marginGallery, unitWidth);
            } else if (marginGallery - firstUnit.getLeft() > unitWidth * 3 / 4) {
                firstUnit.stopVideo(true);
                firstUnit.removeUser();
                int idx = (firstUnit.getRight() + marginGallery + this.mGalleryScrollPosX) / (marginGallery + unitWidth);
                this.scrollGalleryToUnitAtX(idx, marginGallery, unitWidth);
                this.mListGalleryUnits.add(this.mListGalleryUnits.remove(0));
            } else {
                lastUnit.stopVideo(true);
                lastUnit.removeUser();
                int idx = (firstUnit.getLeft() + this.mGalleryScrollPosX) / (marginGallery + unitWidth);
                this.scrollGalleryToUnitAtX(idx, marginGallery, unitWidth);
            }
        } else {
            int unitHeight = firstUnit.getHeight();
            if (lastVisibleUnit != null && lastVisibleUnit.getBottom() < this.getGalleryItemsLandscapeCount() * (marginGallery + unitHeight)) {
                int idx = this.mCountUsers - this.getGalleryItemsLandscapeCount();
                if (idx == 0) {
                    idx = 0;
                }
                this.scrollGalleryToUnitAtY(idx, marginGallery, unitHeight);
            } else if (firstUnit.getTop() > marginGallery) {
                this.scrollGalleryToUnitAtY(0, marginGallery, unitHeight);
            } else if (marginGallery - firstUnit.getTop() > unitHeight * 3 / 4) {
                firstUnit.stopVideo(true);
                firstUnit.removeUser();
                int idx = (firstUnit.getBottom() + marginGallery + this.mGalleryScrollPosY) / (marginGallery + unitHeight);
                this.scrollGalleryToUnitAtY(idx, marginGallery, unitHeight);
                this.mListGalleryUnits.add(this.mListGalleryUnits.remove(0));
            } else {
                lastUnit.stopVideo(true);
                lastUnit.removeUser();
                int idx = (firstUnit.getTop() + this.mGalleryScrollPosY) / (marginGallery + unitHeight);
                this.scrollGalleryToUnitAtY(idx, marginGallery, unitHeight);
            }
        }
        this.checkUpdateGalleryUnitsVideo();
    }

    private void scrollGalleryToUnitAtX(int idx, int marginGallery, int unitWidth) {
        this.mGalleryScrollPosX = idx * (marginGallery + unitWidth);
    }

    private void scrollGalleryToUnitAtY(int idx, int marginGallery, int unitHeight) {
        this.mGalleryScrollPosY = idx * (marginGallery + unitHeight);
    }

    @Override
    public int getShareRenderHeight() {
        int shareRenderHeight = this.getHeight();
        if (this.getHeight() > this.getWidth()) {
            shareRenderHeight = this.mIsGalleryVideoViewExpand ? shareRenderHeight - this.getGalleryActionBarDip() - this.getGalleryUnitPortraitWidth() * 9 / 16 - this.getGalleryListPortraitMargin() * 2 : (shareRenderHeight -= this.getGalleryActionBarDip());
        }
        return shareRenderHeight;
    }

    @Override
    public int getShareRenderWidth() {
        int shareRenderWidth = this.getWidth();
        if (this.getHeight() < this.getWidth()) {
            shareRenderWidth = this.mIsGalleryVideoViewExpand ? shareRenderWidth - this.getGalleryActionBarDip() - this.getGalleryUnitLandscapeHeight() * 16 / 9 - this.getGalleryListLandscapeMargin() * 2 : (shareRenderWidth -= this.getGalleryActionBarDip());
        }
        return shareRenderWidth;
    }

    private int getGalleryActionBarDip() {
        return UIUtil.dip2px((Context)this.getConfActivity(), (float)20.0f);
    }

    private int getGalleryUnitMargin() {
        return UIUtil.dip2px((Context)this.getConfActivity(), (float)3.0f);
    }

    private int getGalleryListLandscapeMargin() {
        return UIUtil.dip2px((Context)this.getConfActivity(), (float)2.0f);
    }

    private int getGalleryListPortraitMargin() {
        return UIUtil.dip2px((Context)this.getConfActivity(), (float)4.0f);
    }

    private int getGalleryUnitPortraitWidth() {
        return (this.getWidth() - this.getGalleryUnitMargin() * 4) / 3;
    }

    private int getGalleryUnitLandscapeHeight() {
        return (this.getHeight() - this.getGalleryUnitMargin() * (this.getGalleryItemsLandscapeCount() + 1)) / this.getGalleryItemsLandscapeCount();
    }

    private int getGalleryItemsCount() {
        if (this.getHeight() > this.getWidth()) {
            return 3;
        }
        return this.getGalleryItemsLandscapeCount();
    }

    private int getGalleryItemsLandscapeCount() {
        if (UIUtil.isTabletOrTV((Context)this.getConfActivity())) {
            return 6;
        }
        return 4;
    }

    private int getMaxGalleryItemsCount() {
        if (UIUtil.isTabletOrTV((Context)this.getConfActivity())) {
            return 6;
        }
        return 4;
    }

    @Override
    public void onShareUserReceivingStatus(long userId) {
        super.onShareUserReceivingStatus(userId);
        this.updateGalleryViewExpandButton();
    }

    private void updateGalleryViewExpandButton() {
        View panelGalleryUnitViewPort = this.getConfActivity().findViewById(R.id.panelShareGalleryExpandPortView);
        ImageView arrowPortImgview = (ImageView)this.getConfActivity().findViewById(R.id.galleryViewExpandArrowImgPort);
        View panelGalleryUnitViewLand = this.getConfActivity().findViewById(R.id.panelShareGalleryExpandLandView);
        ImageView arrowLandImgview = (ImageView)this.getConfActivity().findViewById(R.id.galleryViewExpandArrowImgLand);
        if (this.isVisible() && this.isStarted() && this.hasContent()) {
            if (this.getHeight() > this.getWidth()) {
                ViewGroup.MarginLayoutParams marginParamsPort = (ViewGroup.MarginLayoutParams)panelGalleryUnitViewPort.getLayoutParams();
                marginParamsPort.topMargin = this.getTop() + this.getShareRenderHeight();
                panelGalleryUnitViewPort.setLayoutParams((ViewGroup.LayoutParams)marginParamsPort);
                panelGalleryUnitViewPort.getParent().requestLayout();
                if (this.mIsGalleryVideoViewExpand) {
                    arrowPortImgview.setImageResource(R.drawable.zm_arrow_down_normal);
                } else {
                    arrowPortImgview.setImageResource(R.drawable.zm_arrow_up_normal);
                }
                panelGalleryUnitViewPort.setVisibility(0);
                panelGalleryUnitViewPort.setOnClickListener(this.ExpandGalleryViewlistener);
                panelGalleryUnitViewLand.setVisibility(8);
            } else {
                ViewGroup.MarginLayoutParams marginParamsLand = (ViewGroup.MarginLayoutParams)panelGalleryUnitViewLand.getLayoutParams();
                marginParamsLand.leftMargin = this.getLeft() + this.getShareRenderWidth();
                panelGalleryUnitViewLand.setLayoutParams((ViewGroup.LayoutParams)marginParamsLand);
                panelGalleryUnitViewLand.getParent().requestLayout();
                if (this.mIsGalleryVideoViewExpand) {
                    arrowLandImgview.setImageResource(R.drawable.zm_arrow_right_normal);
                } else {
                    arrowLandImgview.setImageResource(R.drawable.zm_arrow_left_normal);
                }
                panelGalleryUnitViewLand.setVisibility(0);
                panelGalleryUnitViewLand.setOnClickListener(this.ExpandGalleryViewlistener);
                panelGalleryUnitViewPort.setVisibility(8);
            }
        } else {
            panelGalleryUnitViewPort.setOnClickListener(null);
            panelGalleryUnitViewLand.setOnClickListener(null);
            panelGalleryUnitViewLand.setVisibility(8);
            panelGalleryUnitViewPort.setVisibility(8);
        }
    }

    private void updateShareToolbarBtnPosition() {
        ShareView shareView = (ShareView)this.getConfActivity().findViewById(R.id.sharingView);
        if (shareView != null) {
            shareView.setToolbarBtnPosition(5, this.getShareRenderHeight() - this.getHeight() - 70);
        }
    }

    private void showOrHideGalleryVideoUnits(boolean expand) {
        if (this.mIsGalleryVideoViewExpand == expand) {
            return;
        }
        this.mIsGalleryVideoViewExpand = expand;
        this.updateGalleryViewExpandButton();
        if (!this.mIsGalleryVideoViewExpand) {
            this.destroyGalleryVideoUnits();
        } else {
            this.createGalleryUnits();
        }
        this.onUpdateUnits();
    }

    private void destroyGalleryVideoUnits() {
        if (this.mListGalleryUnits == null) {
            return;
        }
        for (int i = 0; i < this.mListGalleryUnits.size(); ++i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            if (unit == null) continue;
            unit.removeUser();
            unit.onDestroy();
            this.removeUnit(unit);
        }
        this.mListGalleryUnits.clear();
    }

    @Override
    public void onGLRendererChanged(VideoRenderer renderer, int width, int height) {
        super.onGLRendererChanged(renderer, width, height);
        this.updateShareToolbarBtnPosition();
    }

    @Override
    public boolean isNoVideoTileOnShareScreenEnabled() {
        return true;
    }

    @Override
    public boolean isLargeShareVideoMode() {
        return true;
    }
}

