/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.graphics.Rect;
import android.view.MotionEvent;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.GLButton;
import com.zipow.videobox.confapp.GLImage;
import com.zipow.videobox.confapp.IRendererUnit;
import com.zipow.videobox.confapp.IVideoUnit;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.VideoRenderer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbsVideoScene {
    private static final String TAG = AbsVideoScene.class.getSimpleName();
    private List<IRendererUnit> mVideoUnits = new ArrayList<IRendererUnit>();
    private AbsVideoSceneMgr mSceneMgr;
    private boolean mbVisible = false;
    private int mLeft = 0;
    private int mTop = 0;
    private int mWidth = 0;
    private int mHeight = 0;
    private boolean mbCreated = false;
    private boolean mbVideoPaused = false;
    private boolean mbStarted = false;
    private boolean mbPreloadEnabled = false;
    private boolean mCacheEnabled = false;
    private List<IRendererUnit> mUnitsGranted = new ArrayList<IRendererUnit>();
    private LinkedList<Runnable> mCachedTasks = new LinkedList();

    public AbsVideoScene(AbsVideoSceneMgr sceneMgr) {
        this.mSceneMgr = sceneMgr;
    }

    public AbsVideoSceneMgr getVideoSceneMgr() {
        return this.mSceneMgr;
    }

    public boolean isVisible() {
        return this.mbVisible;
    }

    public void setVisible(boolean visible) {
        this.mbVisible = visible;
    }

    public boolean isCreated() {
        return this.mbCreated;
    }

    public boolean isStarted() {
        return this.mbStarted;
    }

    public void setPreloadEnabled(boolean enabled) {
        this.mbPreloadEnabled = enabled;
    }

    public boolean isPreloadEnabled() {
        return this.mbPreloadEnabled;
    }

    public void setCacheEnabled(boolean enabled) {
        this.mCacheEnabled = enabled;
    }

    public boolean isCachedEnabled() {
        return this.mCacheEnabled;
    }

    public void cacheUnits() {
    }

    public void destroyCachedUnits() {
    }

    public boolean hasUnits() {
        return this.mVideoUnits.size() > 0;
    }

    public void addUnit(IRendererUnit unit) {
        this.mVideoUnits.add(unit);
    }

    public void removeUnit(IRendererUnit unit) {
        this.mVideoUnits.remove(unit);
    }

    public boolean hasUnit(IRendererUnit unit) {
        return this.mVideoUnits.indexOf(unit) >= 0;
    }

    public void start() {
        if (this.mbStarted) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.inSilentMode()) {
            return;
        }
        this.mbStarted = true;
        this.onStart();
    }

    public void stop() {
        if (!this.mbStarted) {
            return;
        }
        this.mbStarted = false;
        this.onStop();
    }

    public void pauseVideo() {
        this.mbVideoPaused = true;
        for (IRendererUnit unit : this.mVideoUnits) {
            if (unit == null) continue;
            unit.pause();
        }
        this.onPauseVideo();
    }

    public void resumeVideo() {
        this.mbVideoPaused = false;
        for (IRendererUnit unit : this.mVideoUnits) {
            if (unit == null) continue;
            unit.resume();
        }
        this.onResumeVideo();
    }

    public boolean isVideoPaused() {
        return this.mbVideoPaused;
    }

    public void onConfUIRelayout(ConfActivity confActivity) {
        this.updateUnits();
    }

    public void updateUnits() {
        this.onUpdateUnits();
    }

    public void onGLRendererChanged(VideoRenderer renderer, int width, int height) {
        if (this.mWidth == 0 && this.mHeight == 0) {
            this.doCachedTasks();
            this.create(width, height);
        } else {
            for (IRendererUnit unit : this.mVideoUnits) {
                if (unit == null) continue;
                unit.onGLViewSizeChanged(width, height);
            }
            this.update(width, height);
        }
    }

    public void create(int width, int height) {
        this.create(width, height, true);
    }

    public void create(int width, int height, boolean resetLocation) {
        if (this.mbCreated) {
            return;
        }
        if (resetLocation) {
            this.mLeft = 0;
            this.mTop = 0;
        }
        this.mWidth = width;
        this.mHeight = height;
        if (this.mWidth > 0 && this.mHeight > 0) {
            this.onCreateUnits();
            this.mbCreated = true;
            if (this.isStarted()) {
                this.onStart();
            }
        }
    }

    protected void update(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        if (this.mWidth > 0 && this.mHeight > 0) {
            this.onUpdateUnits();
        }
    }

    public void destroy() {
        this.destroy(false);
    }

    public void destroy(boolean ignorePreload) {
        if (!this.mbCreated) {
            return;
        }
        if (this.hasGrantedUnits()) {
            this.stopAndDestroyAllGrantedUnits();
        }
        if (this.mVideoUnits != null && this.mVideoUnits.size() > 0) {
            for (IRendererUnit unit : this.mVideoUnits) {
                if (unit == null) continue;
                unit.onDestroy();
            }
            this.mVideoUnits.clear();
        }
        this.onDestroyUnits();
        this.mbCreated = false;
        this.mbStarted = false;
        this.mLeft = 0;
        this.mTop = 0;
        this.mWidth = 0;
        this.mHeight = 0;
        if (!ignorePreload && this.isPreloadEnabled() && this.getConfActivity().isActive()) {
            this.preload();
        }
    }

    public void onIdle() {
        for (int i = 0; i < this.mVideoUnits.size(); ++i) {
            IRendererUnit unit = this.mVideoUnits.get(i);
            if (unit == null) continue;
            unit.onIdle();
        }
    }

    public void beforeSwitchCamera() {
    }

    public void afterSwitchCamera() {
    }

    public void onActiveVideoChanged(long userId) {
    }

    public void onUserActiveVideoForDeck(long userId) {
    }

    public void onShareActiveUser(long userId) {
    }

    public void onShareUserReceivingStatus(long userId) {
    }

    public void onShareUserSendingStatus(long userId) {
    }

    public void onShareDataSizeChanged(long userId) {
    }

    public void onUserVideoStatus(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        for (IRendererUnit unit : this.mVideoUnits) {
            VideoUnit videoUnit;
            if (unit == null || !(unit instanceof VideoUnit) || !videoMgr.isSameVideo((videoUnit = (VideoUnit)unit).getUser(), userId)) continue;
            videoUnit.onUserVideoStatus();
        }
    }

    public void onUserVideoDataSizeChanged(long userId) {
    }

    public void onUserVideoQualityChanged(long userId) {
    }

    public void onUserAudioStatus(long userId) {
    }

    public void onAudioTypeChanged(long userId) {
    }

    public void onUserActiveAudio(long userId) {
    }

    public void onUserPicReady(long userId) {
    }

    public void onAutoStartVideo() {
    }

    public void onConfReady() {
    }

    public void onConfOne2One() {
    }

    public void onMyVideoStatusChanged() {
    }

    public void onUserEvent(int eventType, long userId, int flag) {
    }

    public void onDoubleTap(MotionEvent e) {
    }

    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
    }

    public void onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
    }

    public void onDown(MotionEvent e) {
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.isVideoPaused()) {
            return false;
        }
        for (IRendererUnit unit : this.mVideoUnits) {
            if (!(unit instanceof GLButton ? ((GLButton)unit).onTouchEvent(e) : unit instanceof GLImage && ((GLImage)unit).onTouchEvent(e))) continue;
            return true;
        }
        return false;
    }

    public boolean onVideoViewSingleTapConfirmed(MotionEvent e) {
        return false;
    }

    public void onMyVideoRotationChanged(int action) {
    }

    public void onLaunchConfParamReady() {
    }

    public void onConfVideoSendingStatusChanged() {
    }

    public void onHostChanged(long userId, boolean isCurUserHost) {
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getRight() {
        return this.mLeft + this.mWidth;
    }

    public int getBottom() {
        return this.mTop + this.mHeight;
    }

    public void move(int distanceX, int distanceY) {
        this.mLeft += distanceX;
        this.mTop += distanceY;
        if (this.isCreated() && this.mWidth > 0 && this.mHeight > 0) {
            this.onUpdateUnits();
        }
    }

    public void setLocation(int x, int y) {
        this.mLeft = x;
        this.mTop = y;
        if (this.isCreated() && this.mWidth > 0 && this.mHeight > 0) {
            this.onUpdateUnits();
        }
    }

    public ConfActivity getConfActivity() {
        return this.mSceneMgr.getConfActivity();
    }

    public VideoRenderer getVideoRenderer() {
        return this.mSceneMgr.getVideoRenderer();
    }

    public void runOnRendererInited(Runnable action) {
        if (action == null) {
            return;
        }
        VideoRenderer renderer = this.getVideoSceneMgr().getVideoRenderer();
        if (renderer == null) {
            return;
        }
        if (renderer.isInitialized()) {
            action.run();
        } else {
            this.cacheTask(action);
        }
    }

    private void cacheTask(Runnable action) {
        this.mCachedTasks.add(action);
    }

    private void doCachedTasks() {
        for (Runnable task : this.mCachedTasks) {
            task.run();
        }
        this.mCachedTasks.clear();
    }

    public VideoSize getUserVideoSize(long userId) {
        VideoSize size = new VideoSize(100, 100);
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return size;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return size;
        }
        CmmVideoStatus status = user.getVideoStatusObj();
        if (status == null) {
            return size;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return size;
        }
        if (confStatus.isSameUser(userId, myself.getNodeId())) {
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr == null) {
                return size;
            }
            size = videoMgr.isVideoStarted() || videoMgr.isPreviewing() ? videoMgr.getMyVideoSize() : new VideoSize(100, 100);
        } else {
            boolean hasVideo;
            if (!status.getIsSending()) {
                return size;
            }
            CmmVideoStatus videoStatus = user.getVideoStatusObj();
            boolean bl = hasVideo = videoStatus != null && videoStatus.getIsSending();
            if (user.isPureCallInUser() || user.isH323User() && !hasVideo) {
                size.height = 100;
                size.width = 100;
            } else {
                long resolution = status.getResolution();
                size.height = (int)(resolution & 0xFFFFFFFFFFFF0000L) >> 16;
                size.width = (int)(resolution & 0xFFFFL);
            }
        }
        if (size.width <= 0 || size.height <= 0) {
            size.width = 16;
            size.height = 9;
        }
        return size;
    }

    public void grantUnitsTo(AbsVideoScene anotherScene) {
        for (IRendererUnit unit : this.mVideoUnits) {
            if (unit == null) continue;
            anotherScene.mUnitsGranted.add(unit);
        }
        this.mVideoUnits.clear();
    }

    public boolean hasGrantedUnits() {
        return this.mUnitsGranted.size() > 0;
    }

    public void stopAndDestroyAllGrantedUnits() {
        for (IRendererUnit unit : this.mUnitsGranted) {
            if (unit == null || !(unit instanceof IVideoUnit)) continue;
            ((IVideoUnit)unit).removeUser();
        }
        for (IRendererUnit unit : this.mUnitsGranted) {
            if (unit == null) continue;
            unit.onDestroy();
        }
        this.mUnitsGranted.clear();
        this.onGrantedUnitsDestroyed();
    }

    public void preload() {
        if (this.hasUnits()) {
            return;
        }
        this.setPreloadEnabled(true);
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                AbsVideoScene.this.setLocation(Integer.MIN_VALUE, 0);
                AbsVideoScene.this.create(AbsVideoScene.this.getVideoRenderer().getWidth(), AbsVideoScene.this.getVideoRenderer().getHeight(), false);
                AbsVideoScene.this.pauseVideo();
                AbsVideoScene.this.start();
            }
        });
    }

    public boolean isPreloadStatus() {
        return this.isPreloadEnabled() && this.mbVideoPaused;
    }

    public long getPreviewRenderInfo() {
        return 0L;
    }

    public Rect getBoundsForAccessbilityViewIndex(int index) {
        return new Rect();
    }

    public int getAccessbilityViewIndexAt(float x, float y) {
        return -1;
    }

    public CharSequence getAccessibilityDescriptionForIndex(int index) {
        return "";
    }

    public void getAccessibilityVisibleVirtualViews(List<Integer> virtualViewIds) {
    }

    public void updateAccessibilitySceneDescription() {
    }

    public void updateContentSubscription() {
    }

    protected void onPauseVideo() {
    }

    protected void onResumeVideo() {
    }

    protected void onDraggingIn() {
    }

    protected void onGrantedUnitsDestroyed() {
    }

    protected void onNetworkRestrictionModeChanged(boolean isNetworkRestrictionMode) {
    }

    protected abstract void onCreateUnits();

    protected abstract void onUpdateUnits();

    protected abstract void onDestroyUnits();

    protected abstract void onStart();

    protected abstract void onStop();
}

