/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.sip.ZoomSipPhoneAdapter;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class ZoomSipPhoneListView
extends ListView
implements AdapterView.OnItemClickListener {
    private ZoomSipPhoneAdapter mZoomSipPhoneAdapter;

    public ZoomSipPhoneListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public ZoomSipPhoneListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ZoomSipPhoneListView(Context context) {
        super(context);
        this.init();
    }

    public void reloadAllData() {
        this.mZoomSipPhoneAdapter.setData(ZMBuddySyncInstance.getInsatance().getAllSipBuddies());
        if (this.isShown()) {
            this.mZoomSipPhoneAdapter.notifyDataSetChanged();
        }
    }

    public void onBuddyInfoUpdate(List<String> infoChangeJids) {
        if (this.isShown()) {
            this.mZoomSipPhoneAdapter.notifyDataSetChanged();
        }
    }

    private void init() {
        this.mZoomSipPhoneAdapter = new ZoomSipPhoneAdapter(this.getContext());
        this.mZoomSipPhoneAdapter.setData(ZMBuddySyncInstance.getInsatance().getAllSipBuddies());
        this.setAdapter((ListAdapter)this.mZoomSipPhoneAdapter);
        this.setOnItemClickListener(this);
    }

    public void filter(String key) {
        this.mZoomSipPhoneAdapter.filter(key);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        IMAddrBookItem item = this.mZoomSipPhoneAdapter.getItem(position);
        if (item != null && !StringUtil.isEmptyOrNull((String)item.getSipPhoneNumber())) {
            if (!SipCallManager.getInstance().isSipAvailable()) {
                new ZMAlertDialog.Builder(this.getContext()).setTitle(R.string.zm_mm_msg_sip_unavailable_14480).setPositiveButton(R.string.zm_btn_ok, null).show();
                return;
            }
            SipCallManager.getInstance().callPeer(item.getSipPhoneNumber());
        }
    }
}

