/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.media.ToneGenerator;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.sip.server.ZoomAssistantIPCMessageUI;
import com.zipow.videobox.view.sip.DialKeyboardView;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class SipDialKeyboardFragment
extends ZMDialogFragment
implements View.OnClickListener,
DialKeyboardView.OnKeyDialListener,
View.OnLongClickListener {
    private static final String TAG = SipDialKeyboardFragment.class.getSimpleName();
    private String mDialNum;
    private DialKeyboardView mPanelKeybord;
    private View mPanelDialNum;
    private TextView mTxtDialNum;
    private View mBtnDial;
    private TextView mTxtRegisterSipNo;
    private TextView mTxtSipUnvailable;
    private ImageView mImgDelete;
    private Handler mHandler = new Handler();
    private static final int REQUEST_PERMISSION_MIC = 100;
    private ToneGenerator mDtmfGenerator = new ToneGenerator(2, 50);
    private ZoomAssistantIPCMessageUI.IZoomAssistantIPCMessageUIListener mListener = new ZoomAssistantIPCMessageUI.SimpleZoomAssistantIPCMessageUIListener(){

        @Override
        public void HandleSIPRegistrarResponse(int result) {
            SipDialKeyboardFragment.this.HandleSIPRegistrarResponse(result);
        }

        @Override
        public void HandleSIPOnSIPServiceStatusChangedNotification(int status) {
            SipDialKeyboardFragment.this.HandleSIPOnSIPServiceStatusChangedNotification(status);
        }

        @Override
        public void HandleSIPOnRegistrarNotification(int result, int respCode, String respDescription) {
            SipDialKeyboardFragment.this.HandleSIPOnRegistrarNotification(result, respCode, respDescription);
        }
    };
    private SipCallManager.OnSipCallEventListener mOnSipCallEventListener = new SipCallManager.OnSipCallEventListener(){

        @Override
        public void onSipCallEvent(int event, String callId) {
            SipDialKeyboardFragment.this.onSipCallEvent(event, callId);
        }
    };

    public static void showAsActivity(Fragment fragment, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, SipDialKeyboardFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_sip_dialpad, container, false);
        this.mPanelKeybord = (DialKeyboardView)view.findViewById(R.id.panelKeybord);
        this.mPanelDialNum = view.findViewById(R.id.panelDialNum);
        this.mTxtDialNum = (TextView)view.findViewById(R.id.txtDialNum);
        this.mBtnDial = view.findViewById(R.id.btnDial);
        this.mTxtRegisterSipNo = (TextView)view.findViewById(R.id.txtRegisterSipNo);
        this.mTxtSipUnvailable = (TextView)view.findViewById(R.id.txtSipUnvailable);
        this.mImgDelete = (ImageView)view.findViewById(R.id.imgDelete);
        this.mPanelKeybord.setOnKeyDialListener(this);
        view.findViewById(R.id.btnClose).setOnClickListener((View.OnClickListener)this);
        this.mImgDelete.setOnClickListener((View.OnClickListener)this);
        this.mImgDelete.setOnLongClickListener((View.OnLongClickListener)this);
        this.mBtnDial.setOnClickListener((View.OnClickListener)this);
        if (savedInstanceState != null) {
            this.mDialNum = savedInstanceState.getString("mDialNum");
        }
        SipCallManager.getInstance().addListener(this.mOnSipCallEventListener);
        return view;
    }

    public void HandleSIPRegistrarResponse(int result) {
        this.updateUI();
    }

    public void HandleSIPOnSIPServiceStatusChangedNotification(int status) {
        this.updateUI();
    }

    public void HandleSIPOnRegistrarNotification(int result, int respCode, String respDescription) {
        this.updateUI();
    }

    public void onResume() {
        super.onResume();
        ZoomAssistantIPCMessageUI.getInstance().addListener(this.mListener);
        this.updateUI();
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.setRequestedOrientation(7);
        }
    }

    public void onPause() {
        super.onPause();
        ZoomAssistantIPCMessageUI.getInstance().removeListener(this.mListener);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putString("mDialNum", this.mDialNum);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        SipCallManager.getInstance().removeListener(this.mOnSipCallEventListener);
    }

    private void updateUI() {
        this.updateDialNum();
        this.updateSipStatusUI();
    }

    private void updateSipStatusUI() {
        SipCallManager sipMgr = SipCallManager.getInstance();
        if (sipMgr.isSipAvailable()) {
            String no = SipCallManager.getInstance().getMyselfSipNo();
            if (StringUtil.isEmptyOrNull((String)no)) {
                this.mTxtRegisterSipNo.setVisibility(4);
            } else {
                this.mTxtRegisterSipNo.setVisibility(0);
                this.mTxtRegisterSipNo.setText((CharSequence)this.getString(R.string.zm_mm_lbl_sip_register_no_14480, new Object[]{no}));
            }
            this.mTxtSipUnvailable.setVisibility(8);
            this.mPanelDialNum.setVisibility(0);
            this.mPanelDialNum.setEnabled(true);
            this.mPanelDialNum.setAlpha(1.0f);
            this.mPanelKeybord.setEnabled(true);
            this.mPanelKeybord.setAlpha(1.0f);
        } else {
            this.mTxtSipUnvailable.setVisibility(0);
            this.mTxtSipUnvailable.setText((CharSequence)SipCallManager.getInstance().getRegisterErrorString());
            this.mTxtRegisterSipNo.setVisibility(4);
            this.mPanelDialNum.setVisibility(4);
            this.mPanelKeybord.setEnabled(false);
            this.mPanelKeybord.setAlpha(0.5f);
        }
        this.updateDialNum();
    }

    private void updateDialNum() {
        SipCallManager sipMgr = SipCallManager.getInstance();
        if (sipMgr.isSipAvailable()) {
            this.mBtnDial.setEnabled(true);
            this.mBtnDial.setAlpha(1.0f);
        } else {
            this.mBtnDial.setEnabled(false);
            this.mBtnDial.setAlpha(0.5f);
        }
        if (StringUtil.isEmptyOrNull((String)this.mDialNum)) {
            this.mTxtDialNum.setText((CharSequence)"");
            this.mImgDelete.setVisibility(4);
        } else {
            this.mImgDelete.setVisibility(0);
            this.mTxtDialNum.setText((CharSequence)this.mDialNum);
        }
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnClose) {
            this.dismiss();
        } else if (id2 == R.id.imgDelete) {
            this.onClickImgDelete();
        } else if (id2 == R.id.btnDial) {
            this.onClickBtnDial();
        }
    }

    private void onClickBtnDial() {
        if (StringUtil.isEmptyOrNull((String)this.mDialNum)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.RECORD_AUDIO") == -1) {
            this.zm_requestPermissions(new String[]{"android.permission.RECORD_AUDIO"}, 100);
            return;
        }
        SipCallManager mgr = SipCallManager.getInstance();
        if (mgr.callPeer(this.mDialNum)) {
            this.mDialNum = "";
            this.updateDialNum();
        }
    }

    private void onClickImgDelete() {
        if (!TextUtils.isEmpty((CharSequence)this.mDialNum)) {
            this.mDialNum = this.mDialNum.substring(0, this.mDialNum.length() - 1);
            this.updateDialNum();
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.pushLater("SipInCallActivityPermissionResult", new EventAction("SipInCallActivityPermissionResult"){

                public void run(IUIElement ui) {
                    ((SipDialKeyboardFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
                }
            });
        }
    }

    protected void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        if (requestCode == 100 && (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.RECORD_AUDIO") == 0)) {
            this.onClickBtnDial();
        }
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    @Override
    public void onKeyDial(String key) {
        if (this.mDialNum == null) {
            this.mDialNum = "";
        }
        this.mDialNum = this.mDialNum + key;
        this.updateDialNum();
        this.playTone(key);
    }

    private void playTone(String key) {
        if (!StringUtil.isEmptyOrNull((String)key)) {
            char c = key.charAt(0);
            int tone = 0;
            switch (c) {
                case '0': {
                    tone = 0;
                    break;
                }
                case '1': {
                    tone = 1;
                    break;
                }
                case '2': {
                    tone = 2;
                    break;
                }
                case '3': {
                    tone = 3;
                    break;
                }
                case '4': {
                    tone = 4;
                    break;
                }
                case '5': {
                    tone = 5;
                    break;
                }
                case '6': {
                    tone = 6;
                    break;
                }
                case '7': {
                    tone = 7;
                    break;
                }
                case '8': {
                    tone = 8;
                    break;
                }
                case '9': {
                    tone = 9;
                    break;
                }
                case '*': {
                    tone = 10;
                    break;
                }
                case '#': {
                    tone = 11;
                    break;
                }
            }
            this.mDtmfGenerator.startTone(tone, 1000);
            this.mDtmfGenerator.stopTone();
        }
    }

    public boolean onLongClick(View v) {
        int id2;
        if (v != null && (id2 = v.getId()) == R.id.imgDelete) {
            return this.onLongClickDelete();
        }
        return false;
    }

    private boolean onLongClickDelete() {
        this.mDialNum = "";
        this.updateDialNum();
        return true;
    }

    public void onSipCallEvent(int event, String callId) {
        this.updateUI();
    }
}

