/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.sip.CallHistory;
import com.zipow.videobox.view.sip.PhoneCallsListview;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.videomeetings.R;

public class PhoneCallsAdapter
extends BaseAdapter
implements View.OnClickListener {
    private List<CallHistory> mItems = new ArrayList<CallHistory>();
    private Context mContext;
    private boolean mIsDeleteMode;
    private PhoneCallsListview mListView;

    public PhoneCallsAdapter(Context context, PhoneCallsListview listView) {
        this.mContext = context;
        this.mListView = listView;
    }

    public void setDeleteMode(boolean mode) {
        this.mIsDeleteMode = mode;
    }

    public void updateData(List<CallHistory> items) {
        this.mItems.clear();
        if (items != null) {
            this.mItems.addAll(items);
        }
    }

    public void updateZoomBuddyInfo(List<String> buddyJids) {
        for (CallHistory item : this.mItems) {
            String buddyJid = item.getBuddyJid();
            if (StringUtil.isEmptyOrNull((String)buddyJid) || !buddyJid.contains(buddyJid)) continue;
            item.updateZOOMDisplayName();
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mItems == null ? 0 : this.mItems.size();
    }

    public CallHistory getItem(int position) {
        return this.mItems == null || this.mItems.size() <= position ? null : this.mItems.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createRecentCallItemView(position, convertView);
    }

    private View createRecentCallItemView(int position, View convertView) {
        CallHistory item;
        if (convertView == null || !"recentCall".equals(convertView.getTag())) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_call_contact_item, null);
            convertView.setTag((Object)"recentCall");
        }
        if ((item = this.getItem(position)) == null) {
            return convertView;
        }
        ImageView imgOutCall = (ImageView)convertView.findViewById(R.id.imgOutCall);
        TextView txtBuddyName = (TextView)convertView.findViewById(R.id.txtBuddyName);
        TextView txtCallNo = (TextView)convertView.findViewById(R.id.txtCallNo);
        TextView txtCallTime = (TextView)convertView.findViewById(R.id.txtCallTime);
        ImageView imgDeleteCall = (ImageView)convertView.findViewById(R.id.imgDeleteCall);
        imgDeleteCall.setVisibility(this.mIsDeleteMode ? 0 : 8);
        if (item.getState() == 1 || item.getState() == 4) {
            txtBuddyName.setTextColor(this.mContext.getResources().getColor(R.color.zm_call_history_name_miss));
        } else {
            txtBuddyName.setTextColor(this.mContext.getResources().getColor(R.color.zm_call_history_name));
        }
        if (item.getDirection() == 2) {
            imgOutCall.setVisibility(0);
        } else {
            imgOutCall.setVisibility(4);
        }
        txtBuddyName.setText((CharSequence)item.getZOOMDisplayName());
        if (item.getType() == 2) {
            txtCallNo.setText(R.string.zm_hint_call_zoom_audio_14480);
        } else if (item.getType() == 1) {
            txtCallNo.setText(R.string.zm_hint_call_zoom_video_14480);
        } else {
            txtCallNo.setText((CharSequence)item.getNumber());
        }
        txtCallTime.setText((CharSequence)this.formatTime(this.mContext, item.getTime()));
        imgDeleteCall.setOnClickListener((View.OnClickListener)this);
        imgDeleteCall.setTag((Object)item.getId());
        return convertView;
    }

    private String formatTime(Context context, long time) {
        long curTime = System.currentTimeMillis();
        long yesterday = curTime - 86400000L;
        if (TimeUtil.isSameDate((long)time, (long)curTime)) {
            return TimeUtil.formatTime((Context)context, (long)time);
        }
        if (TimeUtil.isSameDate((long)time, (long)yesterday)) {
            return context.getString(R.string.zm_lbl_yesterday);
        }
        return TimeUtil.formatDateTime((Context)context, (long)time);
    }

    public boolean removeCall(String jid) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            CallHistory item = this.mItems.get(i);
            if (!StringUtil.isSameString((String)jid, (String)item.getId())) continue;
            this.mItems.remove(i);
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        String jid;
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.imgDeleteCall && !StringUtil.isEmptyOrNull((String)(jid = (String)v.getTag())) && this.mListView != null) {
            this.mListView.deleteHistoryCall(jid);
        }
    }
}

