/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.sip.CallHistoryMgr;
import com.zipow.videobox.view.sip.PhoneCallsListview;
import com.zipow.videobox.view.sip.SipDialKeyboardFragment;
import com.zipow.videobox.view.sip.ZoomSipPhoneListView;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class PhoneCallFragment
extends ZMDialogFragment
implements View.OnClickListener,
SimpleActivity.ExtListener,
TextView.OnEditorActionListener,
ZMBuddySyncInstance.ZMBuddyListListener {
    private boolean mIsAllCallHistoryMode = true;
    private PhoneCallsListview mListviewAllCalls;
    private PhoneCallsListview mListviewMissedCalls;
    private Button mBtnClearAll;
    private Button mBtnEdit;
    private Button mBtnKeyboard;
    private View mPanelTitleBar;
    private EditText mEdtSearch;
    private FrameLayout mPanelListViews;
    private Drawable mDimmedForground = null;
    private View mPanelSearchBarReal;
    private View mPanelSearch;
    private EditText mEdtSearchReal;
    private Button mBtnClearSearchView;
    private ZoomSipPhoneListView mSipPhoneListView;
    private TextView mTxtEmptyView;
    private View mPanelTabAll;
    private View mPanelTabMissed;
    private boolean mIsInEditMode;
    private boolean isKeyboardOpen = false;
    private Handler mHandler = new Handler();
    private Runnable mRunnableFilter = new Runnable(){

        @Override
        public void run() {
            String key = PhoneCallFragment.this.mEdtSearchReal.getText().toString();
            PhoneCallFragment.this.mSipPhoneListView.filter(key);
            if (key.length() > 0 && PhoneCallFragment.this.mSipPhoneListView.getCount() > 0 || PhoneCallFragment.this.mPanelTitleBar.getVisibility() == 0) {
                PhoneCallFragment.this.mPanelListViews.setForeground(null);
            } else {
                PhoneCallFragment.this.mPanelListViews.setForeground(PhoneCallFragment.this.mDimmedForground);
            }
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_sip_call, container, false);
        this.mPanelTabAll = view.findViewById(R.id.panelTabAll);
        this.mPanelTabMissed = view.findViewById(R.id.panelTabMissed);
        this.mListviewAllCalls = (PhoneCallsListview)view.findViewById(R.id.listviewAllCalls);
        this.mListviewMissedCalls = (PhoneCallsListview)view.findViewById(R.id.listviewMissedCalls);
        this.mBtnClearAll = (Button)view.findViewById(R.id.btnClearAll);
        this.mBtnEdit = (Button)view.findViewById(R.id.btnEdit);
        this.mBtnKeyboard = (Button)view.findViewById(R.id.btnKeyboard);
        this.mPanelTitleBar = view.findViewById(R.id.panelTitleBar);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mPanelListViews = (FrameLayout)view.findViewById(R.id.panelListViews);
        this.mPanelSearchBarReal = view.findViewById(R.id.panelSearchBarReal);
        this.mEdtSearchReal = (EditText)view.findViewById(R.id.edtSearchReal);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mPanelSearch = view.findViewById(R.id.panelSearch);
        this.mSipPhoneListView = (ZoomSipPhoneListView)view.findViewById(R.id.sipPhoneListView);
        this.mTxtEmptyView = (TextView)view.findViewById(R.id.txtEmptyView);
        this.mPanelTabAll.setOnClickListener((View.OnClickListener)this);
        this.mPanelTabMissed.setOnClickListener((View.OnClickListener)this);
        this.mBtnClearAll.setOnClickListener((View.OnClickListener)this);
        this.mBtnEdit.setOnClickListener((View.OnClickListener)this);
        this.mBtnKeyboard.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setCursorVisible(false);
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        if (savedInstanceState != null) {
            this.mIsAllCallHistoryMode = savedInstanceState.getBoolean("mIsAllCallHistoryMode", true);
            this.mIsInEditMode = savedInstanceState.getBoolean("mIsInEditMode");
        }
        this.mListviewAllCalls.setParentFragment(this);
        this.mListviewMissedCalls.setParentFragment(this);
        this.mListviewMissedCalls.setShowMissedHistory(true);
        Resources res = this.getResources();
        if (res != null) {
            this.mDimmedForground = new ColorDrawable(res.getColor(R.color.zm_dimmed_forground));
        }
        this.mEdtSearchReal.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mEdtSearchReal.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                PhoneCallFragment.this.mHandler.removeCallbacks(PhoneCallFragment.this.mRunnableFilter);
                PhoneCallFragment.this.mHandler.postDelayed(PhoneCallFragment.this.mRunnableFilter, 300L);
                PhoneCallFragment.this.updateClearSearchView();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putBoolean("mIsAllCallHistoryMode", this.mIsAllCallHistoryMode);
            outState.putBoolean("mIsInEditMode", this.mIsInEditMode);
        }
    }

    public void onCallHistoryDeleted(String calld) {
        this.mListviewAllCalls.onDeleteHistoryCall(calld);
        this.mListviewMissedCalls.onDeleteHistoryCall(calld);
        this.updateEmptyView();
    }

    public void onResume() {
        super.onResume();
        this.mListviewAllCalls.loadAllRecentCalls();
        this.mListviewMissedCalls.loadAllRecentCalls();
        this.mSipPhoneListView.reloadAllData();
        this.updateUIMode();
        ZMBuddySyncInstance.getInsatance().addListener(this);
    }

    public void onPause() {
        ZMBuddySyncInstance.getInsatance().removeListener(this);
        super.onPause();
    }

    private void updateUIMode() {
        this.mPanelTabAll.setSelected(this.mIsAllCallHistoryMode);
        this.mPanelTabMissed.setSelected(!this.mIsAllCallHistoryMode);
        if (this.mIsAllCallHistoryMode) {
            this.mListviewAllCalls.setVisibility(0);
            this.mListviewMissedCalls.setVisibility(8);
        } else {
            this.mListviewAllCalls.setVisibility(8);
            this.mListviewMissedCalls.setVisibility(0);
        }
        this.upateEditMode();
        this.mListviewAllCalls.setDeleteMode(this.mIsInEditMode);
        this.mListviewMissedCalls.setDeleteMode(this.mIsInEditMode);
        this.updateEmptyView();
    }

    private void upateEditMode() {
        if (this.mIsInEditMode) {
            this.mBtnKeyboard.setVisibility(8);
            this.mBtnEdit.setText(R.string.zm_btn_done);
            this.mBtnClearAll.setVisibility(0);
        } else {
            this.mBtnKeyboard.setVisibility(0);
            this.mBtnEdit.setText(R.string.zm_btn_edit);
            this.mBtnClearAll.setVisibility(8);
            boolean isDataEmpty = this.mListviewAllCalls.getVisibility() == 0 ? this.mListviewAllCalls.getCount() == 0 : this.mListviewMissedCalls.getCount() == 0;
            this.mBtnEdit.setEnabled(!isDataEmpty);
        }
    }

    private void updateEmptyView() {
        if (this.mListviewAllCalls.getVisibility() == 0) {
            if (this.mListviewAllCalls.getCount() == 0) {
                this.mTxtEmptyView.setVisibility(0);
                this.mIsInEditMode = false;
                this.upateEditMode();
            } else {
                this.mTxtEmptyView.setVisibility(8);
            }
        } else if (this.mListviewMissedCalls.getCount() == 0) {
            this.mTxtEmptyView.setVisibility(0);
            this.mIsInEditMode = false;
            this.upateEditMode();
        } else {
            this.mTxtEmptyView.setVisibility(8);
        }
    }

    private void onClickPanelTabAll() {
        this.mIsAllCallHistoryMode = true;
        this.updateUIMode();
    }

    private void onClickPanelTabMissed() {
        this.mIsAllCallHistoryMode = false;
        this.updateUIMode();
    }

    private void onClickBtnClear() {
        this.mIsInEditMode = false;
        this.updateUIMode();
    }

    private void onClickBtnEdit() {
        this.mIsInEditMode = !this.mIsInEditMode;
        this.updateUIMode();
    }

    private void onClickBtnKeyboard() {
        SipDialKeyboardFragment.showAsActivity((Fragment)this, 0);
    }

    private void onClickBtnClearAll() {
        new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_mm_msg_sip_clear_all_recent_14480).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CallHistoryMgr mgr = PTApp.getInstance().getCallHistoryMgr();
                mgr.clearAllCallHistory();
                PhoneCallFragment.this.mListviewAllCalls.loadAllRecentCalls();
                PhoneCallFragment.this.mListviewMissedCalls.loadAllRecentCalls();
                PhoneCallFragment.this.updateEmptyView();
            }
        }).setNegativeButton(R.string.zm_btn_cancel, null).show();
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearchReal.setText((CharSequence)"");
        if (!this.isKeyboardOpen) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mSipPhoneListView.setVisibility(8);
            this.mPanelSearch.setVisibility(0);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    (PhoneCallFragment.this.mIsAllCallHistoryMode ? PhoneCallFragment.this.mListviewAllCalls : PhoneCallFragment.this.mListviewMissedCalls).requestLayout();
                }
            });
        }
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.panelTabAll) {
            this.onClickPanelTabAll();
        } else if (id2 == R.id.panelTabMissed) {
            this.onClickPanelTabMissed();
        } else if (id2 == R.id.btnClear) {
            this.onClickBtnClear();
        } else if (id2 == R.id.btnEdit) {
            this.onClickBtnEdit();
        } else if (id2 == R.id.btnKeyboard) {
            this.onClickBtnKeyboard();
        } else if (id2 == R.id.btnClearAll) {
            this.onClickBtnClearAll();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        }
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        this.isKeyboardOpen = true;
        if (this.mEdtSearch.hasFocus()) {
            this.mPanelTitleBar.setVisibility(8);
            this.mPanelListViews.setForeground(this.mDimmedForground);
            this.mPanelSearchBarReal.setVisibility(0);
            this.mPanelSearch.setVisibility(8);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mEdtSearchReal.requestFocus();
            this.mSipPhoneListView.setVisibility(0);
        }
    }

    @Override
    public void onKeyboardClosed() {
        this.isKeyboardOpen = false;
        if (this.mEdtSearch == null) {
            return;
        }
        if (this.mEdtSearchReal.length() == 0 || this.mSipPhoneListView.getCount() == 0) {
            this.mPanelListViews.setForeground(null);
            this.mEdtSearchReal.setText((CharSequence)"");
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mPanelSearch.setVisibility(0);
            this.mSipPhoneListView.setVisibility(8);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                (PhoneCallFragment.this.mIsAllCallHistoryMode ? PhoneCallFragment.this.mListviewAllCalls : PhoneCallFragment.this.mListviewMissedCalls).requestLayout();
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return this.handleBackPressed();
    }

    public boolean handleBackPressed() {
        if (this.mPanelSearchBarReal.getVisibility() == 0) {
            this.mPanelTitleBar.setVisibility(0);
            this.mPanelSearchBarReal.setVisibility(4);
            this.mSipPhoneListView.setVisibility(8);
            this.mEdtSearchReal.setText((CharSequence)"");
            return true;
        }
        return false;
    }

    private void updateClearSearchView() {
        this.mBtnClearSearchView.setVisibility(this.mEdtSearchReal.getText().length() > 0 ? 0 : 8);
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.edtSearch) {
            UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
            return true;
        }
        return false;
    }

    @Override
    public void onBuddyListUpdate() {
        this.mListviewAllCalls.loadAllRecentCalls();
        this.mListviewMissedCalls.loadAllRecentCalls();
        this.mSipPhoneListView.reloadAllData();
    }

    @Override
    public void onBuddyInfoUpdate(List<String> presenceChangeJids, List<String> infoChangeJids) {
        this.mListviewAllCalls.updateZoomBuddyInfo(infoChangeJids);
        this.mListviewMissedCalls.updateZoomBuddyInfo(infoChangeJids);
        this.mSipPhoneListView.onBuddyInfoUpdate(infoChangeJids);
    }
}

