/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zipow.videobox.view.sip.DialPadNumView;
import us.zoom.videomeetings.R;

public class DialKeyboardView
extends LinearLayout
implements View.OnClickListener,
View.OnLongClickListener {
    private OnKeyDialListener mOnKeyDialListener;

    public DialKeyboardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public DialKeyboardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DialKeyboardView(Context context) {
        super(context);
        this.init();
    }

    public void setOnKeyDialListener(OnKeyDialListener onKeyDialListener) {
        this.mOnKeyDialListener = onKeyDialListener;
    }

    public void setOnDrakMode() {
        this.setOnDardMode((ViewGroup)this);
    }

    private void setOnDardMode(ViewGroup viewGroup) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof DialPadNumView) {
                ((DialPadNumView)view).setOnDrakMode();
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.setOnDardMode((ViewGroup)view);
        }
    }

    private void init() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_dialpad, (ViewGroup)this);
        if (!this.isInEditMode()) {
            this.findViewById(R.id.btnKey1).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey2).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey3).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey4).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey5).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey6).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey7).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey8).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey9).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey0).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKeyStar).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKeyNO).setOnClickListener((View.OnClickListener)this);
            this.findViewById(R.id.btnKey0).setOnLongClickListener((View.OnLongClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        this.findViewById(R.id.btnKey1).setEnabled(enabled);
        this.findViewById(R.id.btnKey2).setEnabled(enabled);
        this.findViewById(R.id.btnKey3).setEnabled(enabled);
        this.findViewById(R.id.btnKey4).setEnabled(enabled);
        this.findViewById(R.id.btnKey5).setEnabled(enabled);
        this.findViewById(R.id.btnKey6).setEnabled(enabled);
        this.findViewById(R.id.btnKey7).setEnabled(enabled);
        this.findViewById(R.id.btnKey8).setEnabled(enabled);
        this.findViewById(R.id.btnKey9).setEnabled(enabled);
        this.findViewById(R.id.btnKey0).setEnabled(enabled);
        this.findViewById(R.id.btnKeyStar).setEnabled(enabled);
        this.findViewById(R.id.btnKeyNO).setEnabled(enabled);
    }

    public void onClick(View v) {
        this.onClickBtnDefault(v);
    }

    private void onClickBtnDefault(View view) {
        if (view == null || !(view instanceof DialPadNumView)) {
            return;
        }
        DialPadNumView num = (DialPadNumView)view;
        if (this.mOnKeyDialListener != null && num.getDialKey() != null) {
            this.mOnKeyDialListener.onKeyDial(num.getDialKey());
        }
    }

    public boolean onLongClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnKey0 && this.mOnKeyDialListener != null) {
            this.mOnKeyDialListener.onKeyDial("+");
            return true;
        }
        return false;
    }

    public static interface OnKeyDialListener {
        public void onKeyDial(String var1);
    }
}

