/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.view.ZMGifView;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import com.zipow.videobox.view.mm.sticker.StickerManager;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMPopupWindow;
import us.zoom.videomeetings.R;

public class PrivateStickerPreviewHelper {
    private Context mContext;
    private ZMPopupWindow mPopWin;
    private String mFileId;

    public PrivateStickerPreviewHelper(Context context) {
        this.mContext = context;
    }

    public boolean isShowing() {
        return this.mPopWin != null && this.mPopWin.isShowing();
    }

    public String getCurrentFileId() {
        return this.mFileId;
    }

    public void hidePreview() {
        if (this.mPopWin != null) {
            this.mPopWin.dismiss();
        }
    }

    public void showPreview(View anchor, String fileId) {
        if (this.mContext == null || anchor == null || StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(fileId);
        if (file == null) {
            return;
        }
        this.hidePreview();
        String imgPath = null;
        String localPath = file.getLocalPath();
        if (!StringUtil.isEmptyOrNull((String)localPath) && ImageUtil.isValidImageFile(localPath)) {
            imgPath = localPath;
        } else {
            String previewPath;
            MMPrivateStickerMgr stickerMgr;
            if (!StickerManager.isStickerLocalPathDownloading(fileId) && (stickerMgr = PTApp.getInstance().getZoomPrivateStickerMgr()) != null) {
                String reqId = stickerMgr.downloadSticker(fileId, PendingFileDataHelper.getContenFilePath(fileId, file.getFileName()));
                StickerManager.addStickerLocalPathReqId(fileId, reqId);
            }
            if (!StringUtil.isEmptyOrNull((String)(previewPath = file.getPicturePreviewPath()))) {
                imgPath = previewPath;
            }
        }
        mgr.destroyFileObject(file);
        if (StringUtil.isEmptyOrNull((String)imgPath)) {
            return;
        }
        RelativeLayout viewContent = new RelativeLayout(this.mContext);
        this.mPopWin = new ZMPopupWindow((View)viewContent, -1, -1);
        this.mPopWin.setDismissOnTouchOutside(true);
        viewContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PrivateStickerPreviewHelper.this.mPopWin.dismiss();
            }
        });
        Rect rect = new Rect();
        anchor.getGlobalVisibleRect(rect);
        boolean isFullScreen = false;
        if (this.mContext instanceof Activity) {
            isFullScreen = UIUtil.isFullScreen((Activity)((Activity)this.mContext));
        }
        int arrowPosition = (rect.left + rect.right) / 2;
        PicPreview preview = new PicPreview(this.mContext);
        preview.setPicPath(imgPath);
        preview.measure(0, 0);
        int width = preview.getMeasuredWidth();
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        lp.topMargin = rect.top - (isFullScreen ? 0 : UIUtil.getStatusBarHeight((Context)this.mContext)) - preview.getMeasuredHeight();
        int displayWidth = UIUtil.getDisplayWidth((Context)this.mContext);
        int padding = UIUtil.dip2px((Context)this.mContext, (float)10.0f);
        lp.leftMargin = arrowPosition + width / 2 > displayWidth - padding ? displayWidth - width - padding : (arrowPosition - width / 2 < padding ? padding : arrowPosition - width / 2);
        preview.setArrowXPosition((rect.left + rect.right) / 2 - lp.leftMargin);
        viewContent.addView((View)preview, (ViewGroup.LayoutParams)lp);
        this.mPopWin.showAtLocation(anchor.getRootView(), 48, 0, 0);
        this.mFileId = fileId;
    }

    static class PicPreview
    extends RelativeLayout {
        private ZMGifView mGifView;
        private ImageView mImgArrow;

        public PicPreview(Context context) {
            super(context);
            this.init();
        }

        public void setPicPath(String picPath) {
            if ("image/gif".equals(ImageUtil.getImageMimeType(picPath))) {
                this.mGifView.setGifResourse(picPath);
            } else {
                this.mGifView.setImageDrawable(new LazyLoadDrawable(picPath));
            }
        }

        public void setArrowXPosition(int xPosition) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mImgArrow.getLayoutParams();
            Drawable draw = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.zm_mm_sticker_preview_arrow);
            lp.leftMargin = xPosition - draw.getIntrinsicWidth() / 2;
        }

        private void init() {
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
            ImageView bgImg = new ImageView(this.getContext());
            bgImg.setImageResource(R.drawable.zm_mm_sticker_preview_bg);
            this.addView((View)bgImg, (ViewGroup.LayoutParams)lp);
            bgImg.setId(R.id.stickerPreviewContent);
            this.mGifView = new ZMGifView(this.getContext());
            lp = new RelativeLayout.LayoutParams(-1, -1);
            lp.addRule(5, R.id.stickerPreviewContent);
            lp.addRule(7, R.id.stickerPreviewContent);
            lp.addRule(6, R.id.stickerPreviewContent);
            lp.addRule(8, R.id.stickerPreviewContent);
            lp.topMargin = UIUtil.dip2px((Context)this.getContext(), (float)10.0f);
            lp.bottomMargin = UIUtil.dip2px((Context)this.getContext(), (float)20.0f);
            lp.leftMargin = UIUtil.dip2px((Context)this.getContext(), (float)3.0f);
            lp.rightMargin = UIUtil.dip2px((Context)this.getContext(), (float)3.0f);
            this.addView((View)this.mGifView, (ViewGroup.LayoutParams)lp);
            lp = new RelativeLayout.LayoutParams(-2, -2);
            this.mImgArrow = new ImageView(this.getContext());
            this.mImgArrow.setImageResource(R.drawable.zm_mm_sticker_preview_arrow);
            lp.addRule(8, R.id.stickerPreviewContent);
            this.mImgArrow.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.addView((View)this.mImgArrow, (ViewGroup.LayoutParams)lp);
        }
    }
}

