/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import com.zipow.videobox.view.mm.sticker.MMPrivateStickerFragment;
import com.zipow.videobox.view.mm.sticker.PrivateStickerPreviewHelper;
import com.zipow.videobox.view.mm.sticker.StickerEvent;
import com.zipow.videobox.view.mm.sticker.StickerManager;
import com.zipow.videobox.view.mm.sticker.StickerPanelView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMSquareImageView;
import us.zoom.androidlib.widget.ZMViewPager;
import us.zoom.videomeetings.R;

public class PrivateStickerPanelView
extends StickerPanelView
implements View.OnClickListener,
View.OnLongClickListener,
View.OnTouchListener,
ZMViewPager.Page {
    private List<StickerEvent> mStickers;
    private PrivateStickerPreviewHelper mPreViewHelper;
    private static final String PREFIX_DOWNLOADING = "Down Loading";

    public PrivateStickerPanelView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setGravity(17);
        this.setOrientation(1);
        this.mPreViewHelper = new PrivateStickerPreviewHelper(this.getContext());
    }

    @Override
    public void setContent(List<StickerEvent> stickers) {
        this.mStickers = stickers;
        this.createPanel();
    }

    @Override
    public void onStickerDownloaded(String req_id, int result) {
        if (result == 0) {
            String previewFileId;
            String fileId = StickerManager.getStickerPreviewFileIdByReqId(req_id);
            if (StringUtil.isEmptyOrNull((String)fileId)) {
                fileId = StickerManager.getStickerLocalPathFileIdByReqId(req_id);
            }
            if (StringUtil.isEmptyOrNull((String)fileId)) {
                return;
            }
            this.updatePrivateSticker(fileId);
            if (this.mPreViewHelper != null && this.mPreViewHelper.isShowing() && StringUtil.isSameString((String)fileId, (String)(previewFileId = this.mPreViewHelper.getCurrentFileId()))) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ViewGroup group = (ViewGroup)this.getChildAt(i);
                    for (int j = 0; j < group.getChildCount(); ++j) {
                        StickerEvent event;
                        View child = group.getChildAt(j);
                        Object tag = child.getTag();
                        if (tag == null || !(tag instanceof StickerEvent) || !StringUtil.isSameString((String)(event = (StickerEvent)tag).getStickerId(), (String)fileId)) continue;
                        this.mPreViewHelper.showPreview(child, fileId);
                    }
                }
            }
        }
    }

    private void updatePrivateSticker(String fileId) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ViewGroup group = (ViewGroup)this.getChildAt(i);
            for (int j = 0; j < group.getChildCount(); ++j) {
                String stickerId;
                View child = group.getChildAt(j);
                Object tag = child.getTag();
                if (tag == null || !(tag instanceof String) || !(stickerId = (String)tag).endsWith(PREFIX_DOWNLOADING) || !stickerId.startsWith(fileId)) continue;
                MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
                if (mgr == null) {
                    return;
                }
                ZoomFile file = mgr.getFileWithWebFileID(fileId);
                if (file == null) {
                    return;
                }
                String previewPath = file.getPicturePreviewPath();
                String localPath = file.getLocalPath();
                if (StringUtil.isEmptyOrNull((String)previewPath)) {
                    previewPath = localPath;
                }
                if (StringUtil.isEmptyOrNull((String)previewPath)) {
                    return;
                }
                mgr.destroyFileObject(file);
                View cell = this.createStickerCell(new StickerEvent(fileId), mgr, PTApp.getInstance().getZoomPrivateStickerMgr());
                int padding = UIUtil.dip2px((Context)this.getContext(), (float)4.0f);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1);
                lp.weight = 1.0f;
                lp.leftMargin = padding;
                lp.rightMargin = padding;
                group.removeViewAt(j);
                group.addView(cell, j, (ViewGroup.LayoutParams)lp);
            }
        }
    }

    private void createPanel() {
        if (this.mStickers == null) {
            return;
        }
        ArrayList<StickerEvent> stickers = new ArrayList<StickerEvent>();
        for (StickerEvent sticker : this.mStickers) {
            if (sticker.getEventType() != 3) continue;
            stickers.add(sticker);
        }
        this.removeAllViews();
        LinearLayout panelRow = new LinearLayout(this.getContext());
        panelRow.setOrientation(0);
        panelRow.setGravity(16);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, UIUtil.dip2px((Context)this.getContext(), (float)70.0f));
        lp.bottomMargin = UIUtil.dip2px((Context)this.getContext(), (float)5.0f);
        this.addView((View)panelRow, (ViewGroup.LayoutParams)lp);
        int padding = UIUtil.dip2px((Context)this.getContext(), (float)4.0f);
        LinearLayout panelCell = new LinearLayout(this.getContext());
        panelCell.setGravity(17);
        ZMSquareImageView settingView = new ZMSquareImageView(this.getContext());
        settingView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        settingView.setImageResource(R.drawable.zm_mm_sticker_setting);
        panelCell.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MMPrivateStickerFragment.showAsActivity((ZMActivity)PrivateStickerPanelView.this.getContext());
            }
        });
        lp = new LinearLayout.LayoutParams(-1, -1);
        lp.gravity = 17;
        panelCell.addView((View)settingView, (ViewGroup.LayoutParams)lp);
        lp = new LinearLayout.LayoutParams(0, -1);
        lp.weight = 1.0f;
        lp.leftMargin = padding;
        lp.rightMargin = padding;
        panelRow.addView((View)panelCell, (ViewGroup.LayoutParams)lp);
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        MMPrivateStickerMgr stickerMgr = PTApp.getInstance().getZoomPrivateStickerMgr();
        if (stickerMgr == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            if (panelRow.getChildCount() == 5) {
                panelRow = new LinearLayout(this.getContext());
                panelRow.setOrientation(0);
                panelRow.setGravity(16);
                lp = new LinearLayout.LayoutParams(-1, UIUtil.dip2px((Context)this.getContext(), (float)70.0f));
                this.addView((View)panelRow, (ViewGroup.LayoutParams)lp);
            }
            Object cell = null;
            cell = i < stickers.size() ? this.createStickerCell((StickerEvent)stickers.get(i), mgr, stickerMgr) : new ImageView(this.getContext());
            lp = new LinearLayout.LayoutParams(0, -1);
            lp.weight = 1.0f;
            lp.leftMargin = padding;
            lp.rightMargin = padding;
            panelRow.addView((View)cell, (ViewGroup.LayoutParams)lp);
        }
    }

    private View createStickerCell(StickerEvent sticker, MMFileContentMgr mgr, MMPrivateStickerMgr stickerMgr) {
        String reqId;
        LinearLayout cellPanel;
        String localPath;
        if (sticker == null || StringUtil.isEmptyOrNull((String)sticker.getStickerId()) || mgr == null || stickerMgr == null) {
            return new ImageView(this.getContext());
        }
        ZoomFile file = mgr.getFileWithWebFileID(sticker.getStickerId());
        if (file == null && StringUtil.isEmptyOrNull((String)sticker.getStickerPath())) {
            return new ImageView(this.getContext());
        }
        LinearLayout cell = null;
        String path = sticker.getStickerPath();
        String string2 = localPath = file == null ? null : file.getLocalPath();
        if (StringUtil.isEmptyOrNull((String)path) && file != null) {
            String previewPath = file.getPicturePreviewPath();
            path = StringUtil.isEmptyOrNull((String)previewPath) ? localPath : previewPath;
        }
        if (!StringUtil.isEmptyOrNull((String)path) && ImageUtil.isValidImageFile(path)) {
            cellPanel = new LinearLayout(this.getContext());
            int padding = UIUtil.dip2px((Context)this.getContext(), (float)2.0f);
            cellPanel.setPadding(padding, padding, padding, padding);
            cellPanel.setBackgroundResource(R.drawable.zm_mm_private_sticker_bg);
            cellPanel.setGravity(17);
            ZMSquareImageView imgView = new ZMSquareImageView(this.getContext());
            imgView.setScaleType(ImageView.ScaleType.FIT_CENTER);
            LazyLoadDrawable draw = new LazyLoadDrawable(path);
            draw.setMaxArea(UIUtil.dip2px((Context)this.getContext(), (float)1600.0f));
            imgView.setImageDrawable((Drawable)draw);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
            lp.gravity = 17;
            cellPanel.addView((View)imgView, (ViewGroup.LayoutParams)lp);
            cellPanel.setTag((Object)sticker);
            cellPanel.setOnClickListener((View.OnClickListener)this);
            cellPanel.setOnLongClickListener((View.OnLongClickListener)this);
            cellPanel.setOnTouchListener((View.OnTouchListener)this);
            cell = cellPanel;
        } else {
            if (!StickerManager.isStickerPreviewDownloading(sticker.getStickerId()) && !StringUtil.isEmptyOrNull((String)(reqId = stickerMgr.downloadStickerPreview(sticker.getStickerId())))) {
                StickerManager.addStickerPreviewReqId(sticker.getStickerId(), reqId);
            }
            cellPanel = new LinearLayout(this.getContext());
            ProgressBar bar = new ProgressBar(this.getContext());
            cellPanel.setGravity(17);
            cellPanel.addView((View)bar);
            cellPanel.setTag((Object)(sticker.getStickerId() + PREFIX_DOWNLOADING));
            cell = cellPanel;
        }
        if (file != null && NetworkUtil.getDataNetworkType((Context)this.getContext()) == 1 && StringUtil.isEmptyOrNull((String)localPath) && !StickerManager.isStickerLocalPathDownloading(sticker.getStickerId()) && !StringUtil.isEmptyOrNull((String)(reqId = stickerMgr.downloadSticker(sticker.getStickerId(), PendingFileDataHelper.getContenFilePath(sticker.getStickerId(), file.getFileName()))))) {
            StickerManager.addStickerLocalPathReqId(sticker.getStickerId(), reqId);
        }
        if (file != null) {
            mgr.destroyFileObject(file);
        }
        return cell;
    }

    @Override
    public int getCategory() {
        return 2;
    }

    public void onClick(View v) {
        this.onStickerOnClick(v);
    }

    private void onStickerOnClick(View v) {
        if (this.mOnStickerEventLisener == null) {
            return;
        }
        Object tag = v.getTag();
        if (tag != null && tag instanceof StickerEvent) {
            this.mOnStickerEventLisener.onStickerEvent((StickerEvent)tag);
        }
    }

    public boolean onLongClick(View v) {
        if (this.getResources().getConfiguration().orientation != 1) {
            return false;
        }
        Object tag = v.getTag();
        if (tag != null && tag instanceof StickerEvent) {
            StickerEvent event = (StickerEvent)tag;
            this.mPreViewHelper.showPreview(v, event.getStickerId());
            v.setBackgroundResource(R.drawable.zm_mm_private_sticker_press_bg);
        }
        return false;
    }

    @Override
    public int getMaxStickerSize() {
        return 9;
    }

    public boolean onTouch(View v, MotionEvent event) {
        Object t = v.getTag();
        if (t == null || !(t instanceof StickerEvent)) {
            return false;
        }
        StickerEvent sticker = (StickerEvent)t;
        if (sticker.getStickerId() != null && sticker.getStickerId().equals(this.mPreViewHelper.getCurrentFileId())) {
            if (event.getAction() == 1) {
                this.mPreViewHelper.hidePreview();
                v.setBackgroundResource(R.drawable.zm_mm_private_sticker_bg);
            } else {
                Rect rect = new Rect();
                v.getGlobalVisibleRect(rect);
                if (!rect.contains((int)event.getRawX(), (int)event.getRawY())) {
                    this.mPreViewHelper.hidePreview();
                    v.setBackgroundResource(R.drawable.zm_mm_private_sticker_bg);
                }
            }
        }
        return false;
    }

    public boolean canScrollHorizontal(int dx, int x, int y) {
        return this.mPreViewHelper.isShowing();
    }
}

