/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.dialog.ShareAlertDialog;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.fragment.SimpleMessageDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PrivateStickerUICallBack;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.view.mm.sticker.MMPrivateStickerGridView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.videomeetings.R;

public class MMPrivateStickerFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private TextView mTitleView;
    private View mBtnDelete;
    private MMPrivateStickerGridView mStickerGridView;
    private static final int REQUEST_CHOOSE_PICTURE = 100;
    private static final int REQUEST_PERMISSION_BY_WRITE_EXTERNAL_STORAGE = 10000;
    private PrivateStickerUICallBack.SimpleZoomPrivateStickerUIListener mLisener = new PrivateStickerUICallBack.SimpleZoomPrivateStickerUIListener(){

        @Override
        public void OnNewStickerUploaded(String req_id, int result, String stickerId) {
            MMPrivateStickerFragment.this.OnNewStickerUploaded(req_id, result, stickerId);
        }

        @Override
        public void OnMakePrivateSticker(int result, String src_file_id, String stickerId) {
            MMPrivateStickerFragment.this.OnMakePrivateSticker(result, src_file_id, stickerId);
        }

        @Override
        public void OnDiscardPrivateSticker(int result, String stickerId) {
            MMPrivateStickerFragment.this.OnDiscardPrivateSticker(result, stickerId);
        }

        @Override
        public void OnPrivateStickersUpdated() {
            MMPrivateStickerFragment.this.OnPrivateStickersUpdated();
        }

        @Override
        public void OnStickerDownloaded(String req_id, int result) {
            MMPrivateStickerFragment.this.OnStickerDownloaded(req_id, result);
        }
    };
    private ZoomMessengerUI.IZoomMessengerUIListener mMessengerListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
            MMPrivateStickerFragment.this.FT_UploadToMyList_OnProgress(reqID, ratio, completeSize, bitPerSecond);
        }

        @Override
        public void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
            MMPrivateStickerFragment.this.Indicate_UploadToMyFiles_Sent(reqID, webFileID, result);
        }
    };

    public static void showAsActivity(Fragment fragment) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMPrivateStickerFragment.class.getName(), args, 0, 1);
    }

    public static void showAsActivity(ZMActivity activity) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, MMPrivateStickerFragment.class.getName(), args, 0, 1);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_set_private_stickers, container, false);
        this.mTitleView = (TextView)view.findViewById(R.id.txtTitle);
        this.mBtnDelete = view.findViewById(R.id.btnDelete);
        this.mStickerGridView = (MMPrivateStickerGridView)view.findViewById(R.id.gridViewStickers);
        this.mStickerGridView.setParentFragment(this);
        this.mBtnDelete.setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.mStickerGridView.refreshData();
        ZoomMessengerUI.getInstance().addListener(this.mMessengerListener);
        PrivateStickerUICallBack.getInstance().addListener(this.mLisener);
    }

    public void onPause() {
        PrivateStickerUICallBack.getInstance().removeListener(this.mLisener);
        ZoomMessengerUI.getInstance().removeListener(this.mMessengerListener);
        super.onPause();
    }

    public void onStickerSelected(List<String> selectStickers) {
        if (CollectionsUtil.isListEmpty(selectStickers)) {
            this.mTitleView.setText(R.string.zm_title_edit_emoji_no_selected);
            this.mBtnDelete.setVisibility(4);
        } else {
            int count = selectStickers.size();
            this.mTitleView.setText((CharSequence)this.getResources().getQuantityString(R.plurals.zm_title_edit_emoji_selected, count, new Object[]{count}));
            this.mBtnDelete.setVisibility(0);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && resultCode == -1 && null != data) {
            Uri uri = null;
            if (data != null) {
                uri = data.getData();
            }
            if (uri != null) {
                String path = ImageUtil.getPathFromUri((Context)this.getActivity(), uri);
                if (path == null) {
                    this.alertImageInvalid();
                    return;
                }
                this.uploadSticker(path);
            }
        }
    }

    private void uploadSticker(String path) {
        File file = new File(path);
        if (file.length() >= 0x800000L) {
            SimpleMessageDialog.newInstance(R.string.zm_msg_sticker_too_large, false).show(this.getFragmentManager(), SimpleMessageDialog.class.getName());
            return;
        }
        MMPrivateStickerMgr mgr = PTApp.getInstance().getZoomPrivateStickerMgr();
        if (mgr == null) {
            return;
        }
        mgr.uploadAndMakePrivateSticker(path);
    }

    private void alertImageInvalid() {
        String message = this.getString(R.string.zm_alert_invalid_image);
        ShareAlertDialog.showDialog(this.getFragmentManager(), message, true);
    }

    private boolean checkExternalSoragePermission() {
        return Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public void onAddStickerClick() {
        if (this.checkExternalSoragePermission()) {
            this.takePhoto();
        } else {
            ArrayList<String> list = new ArrayList<String>();
            if (this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                list.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            String[] permissions = list.toArray(new String[list.size()]);
            this.zm_requestPermissions(permissions, 10000);
        }
    }

    private void takePhoto() {
        AndroidAppUtil.selectImageNoDefault((Fragment)this, (int)R.string.zm_select_a_image, (int)100);
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.pushLater("MMPrivateStickerFragmentPermissionResult", new EventAction("MMPrivateStickerFragmentPermissionResult"){

                public void run(IUIElement ui) {
                    ((MMPrivateStickerFragment)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
                }
            });
        }
    }

    protected void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        if (requestCode == 10000 && this.checkExternalSoragePermission()) {
            this.takePhoto();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnDelete) {
            this.onClickBtnDelete();
        } else if (id2 == R.id.btnBack) {
            this.dismiss();
        }
    }

    private void onClickBtnDelete() {
        if (!NetworkUtil.hasDataNetwork((Context)this.getActivity())) {
            this.showConnectionError();
            return;
        }
        List<String> selectStickers = this.mStickerGridView.getSelectStickers();
        if (CollectionsUtil.isListEmpty(selectStickers)) {
            return;
        }
        MMPrivateStickerMgr mgr = PTApp.getInstance().getZoomPrivateStickerMgr();
        if (mgr == null) {
            return;
        }
        for (String sticker : selectStickers) {
            mgr.discardPrivateSticker(sticker);
        }
        this.mStickerGridView.removeSticker(selectStickers);
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)0).show();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    private void OnNewStickerUploaded(String req_id, int result, String stickerId) {
        if (this.mStickerGridView.hasSticker(stickerId)) {
            String msg = this.getString(R.string.zm_msg_duplicate_emoji);
            ErrorMsgDialog.newInstance(msg, -1).show(this.getFragmentManager(), ErrorMsgDialog.class.getName());
        }
        this.mStickerGridView.OnNewStickerUploaded(req_id, result, stickerId);
    }

    private void OnMakePrivateSticker(int result, String src_file_id, String stickerId) {
        if (result == 0) {
            this.mStickerGridView.onAddSticker(stickerId);
        }
    }

    private void OnDiscardPrivateSticker(int result, String stickerId) {
        if (result == 0) {
            this.mStickerGridView.onRemoveSticker(stickerId);
        }
    }

    private void OnPrivateStickersUpdated() {
        this.mStickerGridView.refreshData();
    }

    private void OnStickerDownloaded(String req_id, int result) {
        if (result == 0) {
            this.mStickerGridView.onStickerDownloaded(req_id);
        }
    }

    private void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
        this.mStickerGridView.updateOrAddUploadSticker(reqID, ratio);
    }

    private void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
        this.mStickerGridView.Indicate_UploadToMyFiles_Sent(reqID, webFileID, result);
    }
}

