/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.util.EmojiHelper;
import com.zipow.videobox.view.mm.sticker.CommonEmoji;
import com.zipow.videobox.view.mm.sticker.CommonEmojiHelper;
import com.zipow.videobox.view.mm.sticker.EmojiCategory;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.OnZMScrollChangedListener;
import us.zoom.androidlib.widget.ZMHorizontalScrollView;
import us.zoom.androidlib.widget.ZMPopupWindow;
import us.zoom.videomeetings.R;

public class CommonEmojiPanelView
extends LinearLayout
implements View.OnClickListener,
CommonEmojiHelper.OnEmojiPackageInstallListener,
View.OnLongClickListener,
View.OnTouchListener,
OnZMScrollChangedListener {
    private View mPanelInstall;
    private TextView mTxtProcess;
    private View mPanelDownloadIng;
    private View mPanelNoInstall;
    private View mPanelInstallIng;
    private ZMHorizontalScrollView mPanelEmojisScrollView;
    private View mPanelEmojis;
    private OnCommonEmojiClickListener mOnCommonEmojiClickListener;
    private ZMPopupWindow mPopWin;
    private ProgressBar mProgressBar;
    private List<View> mDiversitiesEmojiViews = new ArrayList<View>();
    private View mPanelDownloadError;
    private LinearLayout mPanelZoomEmojis;
    private LinearLayout mPanelEmojiOne;
    private View mPanelEmojiOneUninstall;
    private TextView mTxtCategoryAnchor;
    private TextView mTxtCategoryLeft;
    private TextView mTxtCategoryRight;
    private LinearLayout mPanelEmojiCategories;
    private List<View> mHeadViewInCategory = new ArrayList<View>();
    private int mScreenWidth;

    public CommonEmojiPanelView(Context context) {
        super(context);
        this.init();
    }

    public CommonEmojiPanelView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void setOnCommonEmojiClickListener(OnCommonEmojiClickListener onCommonEmojiClickListener) {
        this.mOnCommonEmojiClickListener = onCommonEmojiClickListener;
    }

    private void init() {
        this.mScreenWidth = UIUtil.getDisplayWidth((Context)this.getContext());
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_emoji_common_panel, (ViewGroup)this);
        this.mPanelEmojisScrollView = (ZMHorizontalScrollView)this.findViewById(R.id.panelEmojisScrollView);
        this.mPanelInstall = this.findViewById(R.id.panelInstall);
        this.mTxtProcess = (TextView)this.findViewById(R.id.txtProcess);
        this.mPanelDownloadIng = this.findViewById(R.id.panelDownloadIng);
        this.mPanelNoInstall = this.findViewById(R.id.panelNoInstall);
        this.mPanelEmojis = this.findViewById(R.id.panelEmojis);
        this.mTxtCategoryAnchor = (TextView)this.findViewById(R.id.txtCategoryAnchor);
        this.mTxtCategoryLeft = (TextView)this.findViewById(R.id.txtCategoryLeft);
        this.mTxtCategoryRight = (TextView)this.findViewById(R.id.txtCategoryRight);
        this.mPanelInstallIng = this.findViewById(R.id.panelInstallIng);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.mPanelDownloadError = this.findViewById(R.id.panelDownloadError);
        this.mPanelEmojiOne = (LinearLayout)this.findViewById(R.id.panelEmojiOne);
        this.mPanelZoomEmojis = (LinearLayout)this.findViewById(R.id.panelZoomEmojis);
        this.mPanelEmojiCategories = (LinearLayout)this.findViewById(R.id.panelEmojiCategories);
        this.mPanelEmojiOneUninstall = this.findViewById(R.id.panelEmojiOneUninstall);
        this.findViewById(R.id.btnStartUse).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btnRetry).setOnClickListener((View.OnClickListener)this);
        this.mPanelEmojisScrollView.setOnTouchListener((View.OnTouchListener)this);
        this.mPanelEmojisScrollView.setOnZMScrollChangedListener((OnZMScrollChangedListener)this);
        this.updateUI();
    }

    private void updateUI() {
        this.updateUI(false);
    }

    private void updateUI(boolean downloadFailed) {
        final CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
        if (helper.isEmojiInstalled()) {
            final List<EmojiCategory> categories = helper.getEmojiCategories();
            if (!CollectionsUtil.isListEmpty(categories) && this.mPanelEmojisScrollView.getChildCount() == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        final LinearLayout emojisGroupView = new LinearLayout(CommonEmojiPanelView.this.getContext());
                        emojisGroupView.setOrientation(0);
                        emojisGroupView.setGravity(16);
                        List<EmojiCategory> categoryList = helper.getEmojiCategories();
                        if (CollectionsUtil.isListEmpty(categoryList)) {
                            return;
                        }
                        CommonEmojiPanelView.this.mHeadViewInCategory.clear();
                        for (int i = 0; i < categories.size(); ++i) {
                            EmojiCategory category = categoryList.get(i);
                            List<CommonEmoji> emojis = category.getEmojis();
                            LinearLayout panelCommonEmojis = null;
                            int index = 0;
                            for (CommonEmoji emoji : emojis) {
                                if (emoji.isIllegal()) continue;
                                if (panelCommonEmojis == null || index >= panelCommonEmojis.getChildCount()) {
                                    index = 0;
                                }
                                if (index == 0) {
                                    View view = View.inflate((Context)CommonEmojiPanelView.this.getContext(), (int)R.layout.zm_mm_emoji_common_panel_item, null);
                                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                                    if (panelCommonEmojis == null) {
                                        CommonEmojiPanelView.this.mHeadViewInCategory.add(view);
                                        if (i != 0) {
                                            lp.leftMargin = UIUtil.dip2px((Context)VideoBoxApplication.getGlobalContext(), (float)5.0f);
                                        }
                                    }
                                    emojisGroupView.addView(view, (ViewGroup.LayoutParams)lp);
                                    panelCommonEmojis = (LinearLayout)view.findViewById(R.id.panelCommonEmojis);
                                }
                                TextView textView = (TextView)panelCommonEmojis.getChildAt(index);
                                textView.setText(emoji.getOutput());
                                textView.setTag((Object)emoji);
                                textView.setOnClickListener((View.OnClickListener)CommonEmojiPanelView.this);
                                textView.setOnLongClickListener((View.OnLongClickListener)CommonEmojiPanelView.this);
                                textView.setOnTouchListener((View.OnTouchListener)CommonEmojiPanelView.this);
                                ++index;
                            }
                        }
                        CommonEmojiPanelView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                if (!ViewCompat.isAttachedToWindow((View)CommonEmojiPanelView.this) || emojisGroupView.getChildCount() == 0) {
                                    return;
                                }
                                CommonEmojiPanelView.this.mTxtCategoryAnchor.setText((CharSequence)CommonEmojiPanelView.this.getCategoryTitleLable(helper.getEmojiCategories().get(0).getName()));
                                CommonEmojiPanelView.this.installEmojiCategory();
                                ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-2, -1);
                                CommonEmojiPanelView.this.mPanelEmojisScrollView.removeAllViews();
                                CommonEmojiPanelView.this.mPanelEmojisScrollView.addView((View)emojisGroupView, lp);
                                CommonEmojiPanelView.this.mPanelEmojis.setVisibility(0);
                                CommonEmojiPanelView.this.mPanelInstall.setVisibility(8);
                            }
                        });
                    }
                }.start();
            }
            this.mPanelEmojis.setVisibility(0);
            this.mPanelInstall.setVisibility(8);
            this.mPanelDownloadError.setVisibility(8);
        } else {
            this.installZoomEmoji();
            this.mPanelInstall.setVisibility(0);
            this.mPanelEmojis.setVisibility(8);
            int process = helper.getDownloadProcess();
            if (process == -1) {
                if (downloadFailed) {
                    this.mPanelDownloadIng.setVisibility(8);
                    this.mPanelNoInstall.setVisibility(8);
                    this.mPanelDownloadError.setVisibility(0);
                } else {
                    this.mPanelDownloadIng.setVisibility(8);
                    this.mPanelNoInstall.setVisibility(0);
                    this.mPanelDownloadError.setVisibility(8);
                }
            } else {
                this.mPanelDownloadError.setVisibility(8);
                this.mPanelDownloadIng.setVisibility(0);
                this.mPanelNoInstall.setVisibility(8);
                this.mTxtProcess.setText((CharSequence)this.getResources().getString(R.string.zm_lbl_download_emoji_process_23626, new Object[]{process}));
                this.mProgressBar.setProgress(process);
            }
            helper.addListener(this);
        }
    }

    private void installEmojiCategory() {
        CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
        if (!helper.isEmojiInstalled()) {
            return;
        }
        this.mPanelEmojiCategories.removeAllViews();
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1);
        lp.weight = 1.0f;
        for (EmojiCategory category : helper.getEmojiCategories()) {
            LinearLayout panel = new LinearLayout(this.getContext());
            panel.setId(R.id.emojiCategory);
            panel.setTag((Object)category);
            panel.setContentDescription((CharSequence)category.getLabel());
            panel.setGravity(17);
            ImageView image = new ImageView(this.getContext());
            int padding = UIUtil.dip2px((Context)this.getContext(), (float)1.0f);
            image.setPadding(padding, padding, padding, padding);
            image.setImageResource(category.getIconResource());
            panel.addView((View)image);
            this.mPanelEmojiCategories.addView((View)panel, (ViewGroup.LayoutParams)lp);
            panel.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mPanelEmojiCategories.getChildCount() > 0) {
            this.mPanelEmojiCategories.getChildAt(0).setSelected(true);
        }
    }

    private void installZoomEmoji() {
        if (this.mPanelZoomEmojis.getChildCount() > 0) {
            return;
        }
        if (!OsUtil.isAtLeastKLP()) {
            this.mPanelEmojiOneUninstall.setVisibility(8);
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mPanelZoomEmojis.getLayoutParams();
            lp.width = -1;
            this.mPanelZoomEmojis.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        LinearLayout panelCommonEmojis = null;
        int index = 0;
        List<EmojiHelper.EmojiIndex> emojis = EmojiHelper.getInstance().getZMEmojis();
        for (EmojiHelper.EmojiIndex emoji : emojis) {
            if (panelCommonEmojis == null || index >= panelCommonEmojis.getChildCount()) {
                index = 0;
            }
            if (index == 0) {
                View view = View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_emoji_zoom_panel_item, null);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                if (!OsUtil.isAtLeastKLP()) {
                    lp = new LinearLayout.LayoutParams(0, -2);
                    lp.weight = 1.0f;
                }
                this.mPanelZoomEmojis.addView(view, (ViewGroup.LayoutParams)lp);
                panelCommonEmojis = (LinearLayout)view.findViewById(R.id.panelCommonEmojis);
            }
            ImageView img = (ImageView)panelCommonEmojis.getChildAt(index);
            img.setImageResource(emoji.getDrawResource());
            img.setTag((Object)emoji);
            img.setOnClickListener((View.OnClickListener)this);
            ++index;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        CommonEmojiHelper.getInstance().addListener(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        CommonEmojiHelper.getInstance().removeListener(this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnStartUse) {
            CommonEmojiHelper.getInstance().installEmoji();
            this.updateUI();
        } else if (id2 == R.id.btnCancel) {
            CommonEmojiHelper.getInstance().cancelInstallEmoji();
            this.updateUI();
        } else if (id2 == R.id.btnRetry) {
            CommonEmojiHelper.getInstance().installEmoji();
            this.updateUI();
        } else if (id2 == R.id.emojiCategory) {
            this.onClickEmojiCategory(v);
        } else {
            Object tag = v.getTag();
            if (tag instanceof CommonEmoji) {
                if (this.mOnCommonEmojiClickListener != null) {
                    this.mOnCommonEmojiClickListener.onCommonEmojiClick((CommonEmoji)tag);
                }
            } else if (tag instanceof EmojiHelper.EmojiIndex && this.mOnCommonEmojiClickListener != null) {
                this.mOnCommonEmojiClickListener.onZoomEmojiClick((EmojiHelper.EmojiIndex)tag);
            }
        }
    }

    private void onClickEmojiCategory(View v) {
        if (v == null || this.mHeadViewInCategory == null || v.isSelected()) {
            return;
        }
        Object tag = v.getTag();
        if (tag == null || !(tag instanceof EmojiCategory)) {
            return;
        }
        EmojiCategory category = (EmojiCategory)tag;
        List<EmojiCategory> categories = CommonEmojiHelper.getInstance().getEmojiCategories();
        int index = categories.indexOf(category);
        if (index < 0) {
            return;
        }
        if (index >= this.mHeadViewInCategory.size()) {
            return;
        }
        View view = this.mHeadViewInCategory.get(index);
        this.mPanelEmojisScrollView.scrollTo(view.getLeft(), 0);
        for (int i = 0; i < this.mPanelEmojiCategories.getChildCount(); ++i) {
            View child;
            child.setSelected((child = this.mPanelEmojiCategories.getChildAt(i)) == v);
        }
    }

    @Override
    public void onEmojiPkgDownload(int progress) {
        this.updateUI();
    }

    @Override
    public void onEmojiPkgInstalled() {
        this.updateUI();
        this.mPanelInstall.setVisibility(0);
        this.mPanelEmojis.setVisibility(8);
        this.mPanelInstallIng.setVisibility(0);
        this.mPanelNoInstall.setVisibility(8);
        this.mPanelDownloadIng.setVisibility(8);
        this.mPanelDownloadIng.setVisibility(8);
    }

    @Override
    public void onEmojiPkgDownloadFailed() {
        this.updateUI(true);
    }

    public boolean onLongClick(View v) {
        this.showSkinTones(v);
        return false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mPopWin != null && this.mPopWin.isShowing()) {
            float x = event.getRawX();
            Rect rect = new Rect();
            View selectView = null;
            for (View view : this.mDiversitiesEmojiViews) {
                view.getGlobalVisibleRect(rect);
                if (x >= (float)rect.left && x <= (float)rect.right) {
                    selectView = view;
                    view.setBackgroundColor(this.getResources().getColor(R.color.zm_highlight));
                    continue;
                }
                view.setBackgroundColor(this.getResources().getColor(R.color.zm_white));
            }
            if (event.getAction() == 1) {
                if (selectView != null) {
                    this.onClick(selectView);
                }
                this.mPopWin.dismiss();
                this.mPopWin = null;
            }
            return true;
        }
        return false;
    }

    private String getCategoryTitleLable(String categoryName) {
        Resources resources = this.getResources();
        if (resources == null) {
            return null;
        }
        int id2 = 0;
        Context context = VideoBoxApplication.getGlobalContext();
        if (context != null) {
            id2 = resources.getIdentifier(String.format("zm_lbl_emoji_one_category_%s_23626", categoryName), "string", context.getPackageName());
        }
        if (id2 == 0) {
            return categoryName;
        }
        return resources.getString(id2);
    }

    private void showSkinTones(View anchor) {
        if (anchor == null) {
            return;
        }
        Object tag = anchor.getTag();
        if (!(tag instanceof CommonEmoji)) {
            return;
        }
        CommonEmoji emoji = (CommonEmoji)tag;
        List<CommonEmoji> emojis = emoji.getDiversityEmojis();
        if (CollectionsUtil.isListEmpty(emojis)) {
            return;
        }
        emojis = new ArrayList<CommonEmoji>();
        emojis.add(emoji);
        emojis.addAll(emoji.getDiversityEmojis());
        this.mDiversitiesEmojiViews.clear();
        Context context = this.getContext();
        LinearLayout groupView = (LinearLayout)View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_emoji_common_diversities, null).findViewById(R.id.panelCommonEmojis);
        for (int i = 0; i < groupView.getChildCount(); ++i) {
            TextView t = (TextView)groupView.getChildAt(i);
            if (i < emojis.size()) {
                CommonEmoji e = emojis.get(i);
                t.setText(e.getOutput());
                t.setTag((Object)e);
                this.mDiversitiesEmojiViews.add((View)t);
                continue;
            }
            t.setVisibility(8);
        }
        RelativeLayout viewContent = new RelativeLayout(context);
        this.mPopWin = new ZMPopupWindow((View)viewContent, -1, -1);
        this.mPopWin.setDismissOnTouchOutside(true);
        Rect rect = new Rect();
        anchor.getGlobalVisibleRect(rect);
        boolean isFullScreen = false;
        if (context instanceof Activity) {
            isFullScreen = UIUtil.isFullScreen((Activity)((Activity)context));
        }
        groupView.measure(0, 0);
        int width = groupView.getMeasuredWidth();
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
        lp.topMargin = rect.top - (isFullScreen ? 0 : UIUtil.getStatusBarHeight((Context)context)) - groupView.getMeasuredHeight();
        int arrowPosition = (rect.left + rect.right) / 2;
        int displayWidth = UIUtil.getDisplayWidth((Context)context);
        int padding = UIUtil.dip2px((Context)context, (float)10.0f);
        lp.leftMargin = arrowPosition + width / 2 > displayWidth - padding ? displayWidth - width - padding : (arrowPosition - width / 2 < padding ? padding : arrowPosition - width / 2);
        viewContent.addView((View)groupView, (ViewGroup.LayoutParams)lp);
        this.mPopWin.showAtLocation(anchor.getRootView(), 48, 0, 0);
    }

    public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        View visiableView = null;
        int currentSection = -1;
        int visiableCategoryStart = 0;
        for (int i = 0; i < this.mHeadViewInCategory.size(); ++i) {
            View view = this.mHeadViewInCategory.get(i);
            int start = view.getLeft();
            if (start - scrollX > 0 && start - scrollX <= this.mScreenWidth) {
                visiableView = view;
                currentSection = i;
                visiableCategoryStart = start - scrollX;
                break;
            }
            if (start - scrollX <= this.mScreenWidth) continue;
            currentSection = i - 1;
            break;
        }
        if (currentSection == -1) {
            currentSection = this.mHeadViewInCategory.size() - 1;
        }
        List<EmojiCategory> categories = CommonEmojiHelper.getInstance().getEmojiCategories();
        this.mTxtCategoryLeft.setVisibility(8);
        this.mTxtCategoryRight.setVisibility(8);
        if (visiableView == null) {
            if (currentSection >= categories.size()) {
                return;
            }
            this.mTxtCategoryAnchor.setText((CharSequence)this.getCategoryTitleLable(categories.get(currentSection).getName()));
            this.mTxtCategoryAnchor.setVisibility(0);
            for (int i = 0; i < this.mPanelEmojiCategories.getChildCount(); ++i) {
                this.mPanelEmojiCategories.getChildAt(i).setSelected(i == currentSection);
            }
        } else {
            if (currentSection <= 0 || currentSection >= categories.size()) {
                return;
            }
            Rect anchorRect = new Rect();
            this.mTxtCategoryAnchor.getLocalVisibleRect(anchorRect);
            int categoryStart = visiableCategoryStart;
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mTxtCategoryRight.getLayoutParams();
            lp.leftMargin = categoryStart;
            if (categoryStart >= anchorRect.left && categoryStart <= anchorRect.right) {
                this.mTxtCategoryAnchor.setVisibility(8);
                this.mTxtCategoryLeft.setVisibility(0);
                String preName = this.getCategoryTitleLable(categories.get(currentSection - 1).getName());
                this.mTxtCategoryLeft.setText((CharSequence)preName);
                this.mTxtCategoryLeft.measure(0, 0);
                lp = (RelativeLayout.LayoutParams)this.mTxtCategoryLeft.getLayoutParams();
                lp.leftMargin = categoryStart - this.mTxtCategoryLeft.getMeasuredWidth();
            } else {
                this.mTxtCategoryAnchor.setVisibility(0);
                this.mTxtCategoryAnchor.setText((CharSequence)this.getCategoryTitleLable(categories.get(currentSection - 1).getName()));
            }
            this.mTxtCategoryRight.setVisibility(0);
            this.mTxtCategoryRight.setText((CharSequence)this.getCategoryTitleLable(categories.get(currentSection).getName()));
        }
    }

    public static interface OnCommonEmojiClickListener {
        public void onCommonEmojiClick(CommonEmoji var1);

        public void onZoomEmojiClick(EmojiHelper.EmojiIndex var1);
    }
}

