/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class UnshareAlertDialogFragment
extends ZMDialogFragment {
    static final String TAG = UnshareAlertDialogFragment.class.getSimpleName();
    static final String ARG_FILE_ID = "fileId";
    static final String ARG_SHARE_ACTION = "shareAction";
    private String mFileId;
    private List<MMZoomShareAction> mActions;

    public static void showUnshareAlertDialog(FragmentManager fm, String fileId, MMZoomShareAction action) {
        if (action != null) {
            UnshareAlertDialogFragment.showUnshareAlertDialog(fm, fileId, Arrays.asList(action));
        }
    }

    public static void showUnshareAlertDialog(FragmentManager fm, String fileId, @NonNull List<MMZoomShareAction> actions) {
        if (fm == null || StringUtil.isEmptyOrNull((String)fileId) || CollectionsUtil.isCollectionEmpty(actions)) {
            return;
        }
        UnshareAlertDialogFragment dialog = new UnshareAlertDialogFragment();
        Bundle args = new Bundle();
        args.putString(ARG_FILE_ID, fileId);
        args.putString(ARG_SHARE_ACTION, new Gson().toJson(actions));
        dialog.setArguments(args);
        dialog.show(fm, UnshareAlertDialogFragment.class.getName());
    }

    public UnshareAlertDialogFragment() {
        this.setCancelable(true);
    }

    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        if (args != null) {
            this.mFileId = args.getString(ARG_FILE_ID);
            String json = args.getString(ARG_SHARE_ACTION);
            if (!TextUtils.isEmpty((CharSequence)json)) {
                try {
                    this.mActions = (List)new Gson().fromJson(json, new TypeToken<List<MMZoomShareAction>>(){}.getType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(this.getResources().getString(R.string.zm_alert_unshare_group_msg_25025, new Object[]{this.mActions == null ? "" : this.mActions.get(0).getShareeName((Context)this.getActivity())})).setPositiveButton(R.string.zm_btn_delete, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                UnshareAlertDialogFragment.this.unshareZoomFile(UnshareAlertDialogFragment.this.mFileId, UnshareAlertDialogFragment.this.mActions);
            }
        }).setNegativeButton(R.string.zm_btn_cancel, null).create();
    }

    private void unshareZoomFile(String fileId, List<MMZoomShareAction> actions) {
        if (StringUtil.isEmptyOrNull((String)fileId) || actions == null || actions.isEmpty()) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ArrayList<String> sharees = new ArrayList<String>();
        for (MMZoomShareAction action : actions) {
            sharees.add(action.getSharee());
        }
        String reqId = mgr.unshareFile(fileId, sharees);
        if (StringUtil.isEmptyOrNull((String)reqId)) {
            ErrorMsgDialog.newInstance(this.getString(R.string.zm_alert_unshare_file_failed), -1).show(this.getFragmentManager(), ErrorMsgDialog.class.getName());
        }
    }
}

