/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.text.TextUtils;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.io.Serializable;

public class MMZoomGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String groupName;
    private int memberCount;
    private boolean isPublic;
    private boolean isPrivate;
    private String owner;
    private long createTime;
    private String groupId;
    private String groupOwnerName;
    private int mucType;
    private boolean isE2E;
    private boolean isRoom;
    private String adminScreenName = "";
    private int notifyType;

    private MMZoomGroup() {
    }

    public static MMZoomGroup initWithZoomGroup(ZoomGroup group) {
        if (group == null) {
            return null;
        }
        MMZoomGroup mmGroup = new MMZoomGroup();
        if (group.isPublicRoom()) {
            mmGroup.setPublic(true);
        } else if (group.isPrivateRoom()) {
            mmGroup.setPrivate(true);
        }
        mmGroup.setRoom(group.isRoom());
        mmGroup.setGroupId(group.getGroupID());
        mmGroup.setGroupName(group.getGroupDisplayName(VideoBoxApplication.getGlobalContext()));
        mmGroup.setMemberCount(group.getBuddyCount());
        mmGroup.setOwner(group.getGroupOwner());
        mmGroup.setMucType(group.getMucType());
        mmGroup.setE2E(group.isForceE2EGroup());
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            ZoomBuddy admin;
            ZoomBuddy buddy = messenger.getBuddyWithJID(mmGroup.getOwner());
            if (buddy != null) {
                mmGroup.setGroupOwnerName(buddy.getScreenName());
            }
            if (group.getGroupAdmins() != null && group.getGroupAdmins().size() > 0 && (admin = messenger.getBuddyWithJID(group.getGroupAdmins().get(0))) != null) {
                mmGroup.setAdminScreenName(admin.getScreenName());
            }
        }
        return mmGroup;
    }

    public void syncGroupWithSDK(ZoomMessenger messenger) {
        if (messenger == null || TextUtils.isEmpty((CharSequence)this.groupId)) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.groupId);
        if (group == null) {
            return;
        }
        if (group.isPublicRoom()) {
            this.setPublic(true);
        } else if (group.isPrivateRoom()) {
            this.setPrivate(true);
        }
        this.setRoom(group.isRoom());
        this.setGroupId(group.getGroupID());
        this.setGroupName(group.getGroupDisplayName(VideoBoxApplication.getGlobalContext()));
        this.setMemberCount(group.getBuddyCount());
        this.setOwner(group.getGroupOwner());
        this.setMucType(group.getMucType());
        this.setE2E(group.isForceE2EGroup());
        ZoomBuddy buddy = messenger.getBuddyWithJID(this.getOwner());
        if (buddy != null) {
            this.setGroupOwnerName(buddy.getScreenName());
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupOwnerName() {
        return this.groupOwnerName;
    }

    public void setGroupOwnerName(String groupOwnerName) {
        this.groupOwnerName = groupOwnerName;
    }

    public String getAdminScreenName() {
        return this.adminScreenName;
    }

    public void setAdminScreenName(String name) {
        this.adminScreenName = name;
    }

    public int getMucType() {
        return this.mucType;
    }

    public void setMucType(int mucType) {
        this.mucType = mucType;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public boolean isE2E() {
        return this.isE2E;
    }

    public void setE2E(boolean isE2E) {
        this.isE2E = isE2E;
    }

    public boolean isRoom() {
        return this.isRoom;
    }

    public void setRoom(boolean isRoom) {
        this.isRoom = isRoom;
    }

    public int getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(int notifyType) {
        this.notifyType = notifyType;
    }
}

