/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomFileShareInfo;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomShareAction;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class MMZoomFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long shareTimeStamp;
    private long timeStamp;
    private int fileType;
    private String localPath;
    private String fileURL;
    private String fileName;
    private boolean isFileDownloading;
    private boolean isFileDownloaded;
    private String sessionID;
    private String ownerJid;
    private String ownerName;
    private String webID;
    private String picturePreviewPath;
    private int fileSize;
    private int fileTransferState;
    private int transferredSize;
    private boolean isDeletePending;
    private String reqId;
    private List<MMZoomShareAction> shareAction;
    private List<FileMatchInfo> mMatchInfos;
    private int ratio;
    private int completeSize;
    private int bitPerSecond;
    private boolean isPending;
    private boolean uploadFailed;
    private boolean showAllShareActions;
    private List<String> operatorAbleSessions = new ArrayList<String>();
    private boolean isDisabled;

    public static MMZoomFile initWithZoomFile(ZoomFile file, MMFileContentMgr mgr) {
        if (file == null) {
            return null;
        }
        if (mgr == null) {
            return null;
        }
        MMZoomFile mmFile = new MMZoomFile(file);
        mgr.destroyFileObject(file);
        return mmFile;
    }

    public MMZoomFile() {
    }

    protected MMZoomFile(ZoomFile file) {
        if (file == null) {
            return;
        }
        this.setFileDownloaded(file.isFileDownloaded());
        this.setFileDownloading(file.isFileDownloading());
        this.setFileSize(file.getFileSize());
        this.setFileTransferState(file.getFileTransferState());
        this.setFileType(file.getFileType());
        this.setFileName(file.getFileName());
        this.setFileURL(file.getFileURL());
        this.setLocalPath(file.getLocalPath());
        this.setSessionID(file.getSessionID());
        this.setTransferredSize(file.getTransferredSize());
        this.setTimeStamp(file.getTimeStamp());
        this.setOwnerJid(file.getOwner());
        this.setWebID(file.getWebFileID());
        this.setDeletePending(file.isDeletePending());
        this.setPicturePreviewPath(file.getPicturePreviewPath());
        ZoomFileShareInfo shareInfo = file.getShareInfo();
        if (shareInfo != null) {
            long count = shareInfo.getShareActionCount();
            ArrayList<MMZoomShareAction> actions = new ArrayList<MMZoomShareAction>();
            for (long i = 0L; i < count; ++i) {
                ZoomShareAction action = shareInfo.getShareAction(i);
                if (action == null) continue;
                actions.add(MMZoomShareAction.createWithZoomShareAction(action));
            }
            this.setShareAction(actions);
        }
        if (!StringUtil.isEmptyOrNull((String)this.ownerJid)) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(this.ownerJid);
            if (buddy != null) {
                this.setOwnerName(buddy.getScreenName());
            }
        }
    }

    public int getRatio() {
        return this.ratio;
    }

    public void setRatio(int ratio) {
        this.ratio = ratio;
    }

    public int getCompleteSize() {
        return this.completeSize;
    }

    public void setCompleteSize(int completeSize) {
        this.completeSize = completeSize;
    }

    public int getBitPerSecond() {
        return this.bitPerSecond;
    }

    public void setBitPerSecond(int bitPerSecond) {
        this.bitPerSecond = bitPerSecond;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public int getTransferredSize() {
        return this.transferredSize;
    }

    public void setTransferredSize(int transferredSize) {
        this.transferredSize = transferredSize;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public boolean isFileDownloading() {
        return this.isFileDownloading;
    }

    public void setFileDownloading(boolean isFileDownloading) {
        this.isFileDownloading = isFileDownloading;
    }

    public boolean isFileDownloaded() {
        return this.isFileDownloaded;
    }

    public void setFileDownloaded(boolean isFileDownloaded) {
        this.isFileDownloaded = isFileDownloaded;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public int getFileTransferState() {
        return this.fileTransferState;
    }

    public void setFileTransferState(int fileTransferState) {
        this.fileTransferState = fileTransferState;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public List<MMZoomShareAction> getShareAction() {
        return this.shareAction;
    }

    public void setShareAction(List<MMZoomShareAction> shareAction) {
        this.shareAction = shareAction;
    }

    public String getOwnerJid() {
        return this.ownerJid;
    }

    public long getShareTimeInSession(String sessionJid) {
        ZoomMessenger messenger;
        if (this.shareTimeStamp != 0L) {
            return this.shareTimeStamp;
        }
        if (this.shareAction != null && this.shareAction.size() > 0) {
            for (MMZoomShareAction action : this.shareAction) {
                if (!StringUtil.isSameString((String)action.getSharee(), (String)sessionJid)) continue;
                if (this.shareTimeStamp == 0L) {
                    this.shareTimeStamp = action.getShareTime();
                    continue;
                }
                if (action.getShareTime() >= this.shareTimeStamp) continue;
                this.shareTimeStamp = action.getShareTime();
            }
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
            return 0L;
        }
        ZoomChatSession session = messenger.getSessionById(sessionJid);
        if (session == null) {
            return 0L;
        }
        if (!session.isGroup() || session.getSessionGroup() != null && !session.getSessionGroup().isRoom()) {
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return this.shareTimeStamp;
            }
            String jid = myself.getJid();
            if (StringUtil.isEmptyOrNull((String)jid)) {
                return this.shareTimeStamp;
            }
            if (this.shareAction != null && this.shareAction.size() > 0) {
                for (MMZoomShareAction action : this.shareAction) {
                    if (!StringUtil.isSameString((String)action.getSharee(), (String)jid) || action.getShareTime() >= this.shareTimeStamp) continue;
                    this.shareTimeStamp = action.getShareTime();
                }
            }
        }
        if (this.shareTimeStamp == 0L) {
            this.shareTimeStamp = this.getTimeStamp();
        }
        return this.shareTimeStamp;
    }

    public long getLastedShareTime() {
        long date = 0L;
        if (this.shareAction != null && this.shareAction.size() > 0) {
            for (MMZoomShareAction action : this.shareAction) {
                long tmp = action.getShareTime();
                if (tmp <= date) continue;
                date = tmp;
            }
        }
        if (date <= 0L) {
            return this.getTimeStamp();
        }
        return date;
    }

    public long getEarliestShareTime() {
        long date = 0L;
        if (this.shareAction != null && this.shareAction.size() > 0) {
            date = this.shareAction.get(0).getShareTime();
            for (MMZoomShareAction action : this.shareAction) {
                long tmp = action.getShareTime();
                if (tmp >= date) continue;
                date = tmp;
            }
        }
        if (date <= 0L) {
            return this.getTimeStamp();
        }
        return date;
    }

    public void setOwnerJid(String ownerJid) {
        this.ownerJid = ownerJid;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getWebID() {
        return this.webID;
    }

    public void setWebID(String webID) {
        this.webID = webID;
    }

    public String getPicturePreviewPath() {
        return this.picturePreviewPath;
    }

    public void setPicturePreviewPath(String picturePreviewPath) {
        this.picturePreviewPath = picturePreviewPath;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public void setPending(boolean isPending) {
        this.isPending = isPending;
    }

    public boolean isUploadFailed() {
        return this.uploadFailed;
    }

    public void setUploadFailed(boolean uploadFailed) {
        this.uploadFailed = uploadFailed;
    }

    public String getReqId() {
        return this.reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public boolean isDeletePending() {
        return this.isDeletePending;
    }

    public void setDeletePending(boolean isDeletePending) {
        this.isDeletePending = isDeletePending;
    }

    public boolean isShowAllShareActions() {
        return this.showAllShareActions;
    }

    public void setShowAllShareActions(boolean showAllShareActions) {
        this.showAllShareActions = showAllShareActions;
    }

    public List<FileMatchInfo> getMatchInfos() {
        return this.mMatchInfos;
    }

    public void setMatchInfos(List<FileMatchInfo> matchInfos) {
        this.mMatchInfos = matchInfos;
    }

    public List<String> getOperatorAbleSessions() {
        return this.operatorAbleSessions;
    }

    public void addOperatorAbleSession(String sessionId) {
        this.operatorAbleSessions.add(sessionId);
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public static class FileMatchInfo {
        int mType;
        String mContent;
        List<HighlightPosition> mHighlightPositions = new ArrayList<HighlightPosition>();
    }

    public static class HighlightPosition {
        int start;
        int end;
    }
}

