/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomSubscribeRequest;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMSystemNotificationListView
extends ListView
implements AdapterView.OnItemLongClickListener,
AdapterView.OnItemClickListener {
    private static final String TAG = MMSystemNotificationListView.class.getSimpleName();
    private ZMDialogFragment mParentFragment;
    private MMNewFriendRequestsListAdapter mAdapter;
    private boolean mIsImChatDisabled = false;

    public MMSystemNotificationListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public MMSystemNotificationListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMSystemNotificationListView(Context context) {
        super(context);
        this.initView();
    }

    public void onZoomMessengerNotifySubscribeRequest() {
        this.reloadAllItems();
        if (this.isParentFragmentResumed()) {
            NotificationMgr.playNotificationVibrate(this.getContext());
        }
    }

    public void onIndicateBuddyListUpdated() {
        this.reloadAllItems();
    }

    public void onIndicateInfoUpdatedWithJID(String jid) {
        this.reloadAllItems();
    }

    public void onNotifySubscribeRequestUpdated(String jid) {
        this.reloadAllItems();
    }

    public void setParentFragment(ZMDialogFragment fragment) {
        this.mParentFragment = fragment;
    }

    public boolean isParentFragmentResumed() {
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.isResumed();
    }

    public void reloadAllItems() {
        if (this.mAdapter == null) {
            return;
        }
        this.mAdapter.clear();
        this.loadAllItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    private void initView() {
        this.mAdapter = new MMNewFriendRequestsListAdapter(this.getContext(), this);
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemLongClickListener(this);
        this.setOnItemClickListener(this);
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || messenger.imChatGetOption() == 2) {
            this.mIsImChatDisabled = true;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    private void loadAllItems(MMNewFriendRequestsListAdapter adapter) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        int count = messenger.getSubscribeRequestCount();
        int unreadCount = messenger.getUnreadRequestCount();
        for (int i = 0; i < count; ++i) {
            ZoomBuddy buddy;
            String requestJid;
            ZoomSubscribeRequest request = messenger.getSubscribeRequestAt(i);
            if (request == null || request.getRequestStatus() == 3 || StringUtil.isEmptyOrNull((String)(requestJid = request.getRequestJID())) || (buddy = messenger.getBuddyWithJID(requestJid)) == null) continue;
            if (StringUtil.isEmptyOrNull((String)buddy.getScreenName())) {
                messenger.refreshBuddyVCard(requestJid, true);
            }
            request.setIMAddrBookItem(IMAddrBookItem.fromZoomBuddy(buddy));
            request.setMyBuddy(messenger.isMyContact(requestJid));
            adapter.addItem(request);
        }
        if (messenger.setAllRequestAsReaded() && unreadCount > 0) {
            messenger.syncAllSubScribeReqAsReaded();
        }
    }

    private void onSelectDeleteRequest(ZoomSubscribeRequest request) {
        if (request == null) {
            return;
        }
        ZoomMessenger messagener = PTApp.getInstance().getZoomMessenger();
        if (messagener == null) {
            return;
        }
        messagener.deleteSubscribeRequest(request.getRequestIndex());
        this.reloadAllItems();
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        final ZoomSubscribeRequest request = this.mAdapter.getItem(position);
        if (request == null) {
            return false;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return false;
        }
        IMAddrBookItem item = request.getIMAddrBookItem();
        if (item == null) {
            return false;
        }
        ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ArrayList<SubscribeRequestContextMenuItem> items = new ArrayList<SubscribeRequestContextMenuItem>();
        String title = item.getScreenName();
        items.add(new SubscribeRequestContextMenuItem(activity.getString(R.string.zm_system_notification_delete_reqeust), 0));
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(title).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMSystemNotificationListView.this.onSelectDeleteRequest(request);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
        return true;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mIsImChatDisabled) {
            return;
        }
        ZoomSubscribeRequest request = this.mAdapter.getItem(position);
        if (request != null && request.isMyBuddy() && request.getRequestStatus() == 1) {
            this.showChatUI(request);
        }
    }

    private void showChatUI(ZoomSubscribeRequest request) {
        if (request == null) {
            return;
        }
        Context context = this.getContext();
        if (!(context instanceof ZMActivity)) {
            return;
        }
        ZoomMessenger messagener = PTApp.getInstance().getZoomMessenger();
        if (messagener == null) {
            return;
        }
        ZoomBuddy buddy = messagener.getBuddyWithJID(request.getRequestJID());
        if (buddy == null) {
            return;
        }
        MMChatActivity.showAsOneToOneChat((ZMActivity)context, buddy);
    }

    static class SubscribeRequestContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_DELETE = 0;

        public SubscribeRequestContextMenuItem(String label, int action) {
            super(action, label);
        }
    }

    private static class MMNewFriendRequestsListAdapter
    extends BaseAdapter {
        private static final int ITEM_TYPE_NORMAL = 0;
        private List<ZoomSubscribeRequest> mItems = new ArrayList<ZoomSubscribeRequest>();
        private Context mContext;
        private MMSystemNotificationListView mListView;

        public MMNewFriendRequestsListAdapter(Context context, MMSystemNotificationListView listView) {
            assert (context != null);
            this.mContext = context;
            this.mListView = listView;
        }

        public void clear() {
            this.mItems.clear();
        }

        public void addItem(ZoomSubscribeRequest item) {
            this.updateItem(item);
        }

        public void updateItem(ZoomSubscribeRequest item) {
            if (item == null || item.getRequestStatus() == 3) {
                return;
            }
            this.mItems.add(item);
        }

        public int getCount() {
            return this.mItems.size();
        }

        public ZoomSubscribeRequest getItem(int position) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            if (position < 0 || position >= this.getCount()) {
                return null;
            }
            ZoomSubscribeRequest item = this.getItem(position);
            View view = null;
            if (convertView != null && "MMSystemNotificationListViewItem".equals(convertView.getTag())) {
                view = convertView;
            } else {
                view = View.inflate((Context)this.mContext, (int)R.layout.zm_system_notification_item, null);
                view.setTag((Object)"MMSystemNotificationListViewItem");
            }
            AvatarView avatarView = (AvatarView)view.findViewById(R.id.avatarView);
            TextView txtScreenName = (TextView)view.findViewById(R.id.txtScreenName);
            TextView txtDescription = (TextView)view.findViewById(R.id.txtDescription);
            TextView txtEmail = (TextView)view.findViewById(R.id.txtEmail);
            View btnAccept = view.findViewById(R.id.btnAccept);
            View btnDecline = view.findViewById(R.id.btnDecline);
            View txtDeclined = view.findViewById(R.id.txtDeclined);
            View txtChat = view.findViewById(R.id.txtChat);
            View txtpending = view.findViewById(R.id.txtpending);
            int status = item.getRequestStatus();
            txtDeclined.setVisibility(status == 2 ? 0 : 8);
            txtChat.setVisibility(!this.mListView.mIsImChatDisabled && status == 1 ? 0 : 8);
            txtChat.setEnabled(item.isMyBuddy());
            if (item.getRequestType() == 0) {
                btnAccept.setVisibility(status == 0 ? 0 : 8);
                btnDecline.setVisibility(status == 0 ? 0 : 8);
                txtpending.setVisibility(8);
                txtDescription.setText(status == 1 ? R.string.zm_description_contact_request_accept_byme : R.string.zm_description_recive_contact_request);
            } else {
                txtpending.setVisibility(status == 0 ? 0 : 8);
                txtDescription.setText(status == 1 ? R.string.zm_description_contact_request_accept_byother : R.string.zm_description_sent_contact_request);
                btnAccept.setVisibility(8);
                btnDecline.setVisibility(8);
            }
            IMAddrBookItem bookItem = item.getIMAddrBookItem();
            if (bookItem != null) {
                String showName;
                this.loadAvatar(bookItem, avatarView);
                String string2 = showName = (bookItem.isPending() || item.getRequestStatus() == 2) && item.getRequestType() != 0 ? bookItem.getAccountEmail() : bookItem.getScreenName();
                if (StringUtil.isEmptyOrNull((String)showName)) {
                    showName = bookItem.getScreenName();
                }
                txtScreenName.setText((CharSequence)showName);
                txtEmail.setVisibility(bookItem.getAccountEmail() == null ? 8 : 0);
                txtEmail.setText((CharSequence)bookItem.getAccountEmail());
            }
            btnAccept.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MMNewFriendRequestsListAdapter.this.acknowledgeSubscription(position, true);
                }
            });
            btnDecline.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MMNewFriendRequestsListAdapter.this.acknowledgeSubscription(position, false);
                }
            });
            return view;
        }

        private void loadAvatar(IMAddrBookItem item, AvatarView avatarView) {
            if (avatarView != null && !avatarView.isInEditMode()) {
                String fromJid = item.getJid();
                avatarView.setName(item.getScreenName());
                avatarView.setBgColorSeedString(item.getJid());
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger != null) {
                    File file;
                    ZoomBuddy buddy = null;
                    ZoomBuddy myself = messenger.getMyself();
                    buddy = myself != null && fromJid != null && fromJid.equals(myself.getJid()) ? myself : messenger.getBuddyWithJID(fromJid);
                    String avatarPath = null;
                    if (buddy != null) {
                        avatarPath = buddy.getLocalPicturePath();
                    }
                    boolean hasAvatarFile = false;
                    if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                        avatarView.setAvatar(avatarPath);
                        hasAvatarFile = true;
                    }
                    if (!hasAvatarFile) {
                        avatarView.setAvatar(item.getAvatarBitmap(this.mContext));
                    }
                }
            }
        }

        private void acknowledgeSubscription(int position, boolean accept) {
            ZoomSubscribeRequest item = this.getItem(position);
            if (item == null) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            if (!messenger.isConnectionGood() || !NetworkUtil.hasDataNetwork((Context)this.mContext)) {
                this.showConnectionError(this.mContext);
                return;
            }
            messenger.ackBuddySubscribe(item.getRequestJID(), accept);
            this.mListView.reloadAllItems();
        }

        private void showConnectionError(Context context) {
            if (context == null || !(context instanceof Activity)) {
                return;
            }
            Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
        }
    }
}

