/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMSlashCommandPopupView
extends PopupWindow {
    private static final String TAG = MMSlashCommandPopupView.class.getSimpleName();
    private ListView mListView;
    private String mGroupId;
    private OnSlashCommandClickListener onSlashCommandClickListener;
    private View mParent;
    private String mFilter;
    private List<SlashItem> list = new ArrayList<SlashItem>();
    private List<SlashItem> filterList = new ArrayList<SlashItem>();
    private SlashCommandAdapter commandAdapter;

    public void setOnSlashCommandClickListener(OnSlashCommandClickListener onSlashCommandClickListener) {
        this.onSlashCommandClickListener = onSlashCommandClickListener;
    }

    public void setmFilter(String mFilter) {
        this.mFilter = mFilter;
        this.filterListByString(mFilter);
        if (this.filterList.isEmpty()) {
            this.dismiss();
        } else if (this.commandAdapter != null) {
            if (!this.isShowing()) {
                this.show();
            }
            this.commandAdapter.notifyDataSetChanged();
        }
    }

    public MMSlashCommandPopupView(Context context, View parent, String mGroupId) {
        this.mParent = parent;
        Rect rect = new Rect();
        parent.getGlobalVisibleRect(rect);
        this.mGroupId = mGroupId;
        this.setContentView(View.inflate((Context)context, (int)R.layout.zm_mm_slash_command_popup, null));
        this.setWidth(-1);
        this.setHeight(rect.bottom - rect.top + (int)context.getResources().getDimension(R.dimen.zm_pt_titlebar_height));
        this.setOutsideTouchable(false);
        this.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.setFocusable(false);
        this.mListView = (ListView)this.getContentView().findViewById(R.id.slash_command_listView);
        this.list = this.loadAndSortData();
        if (this.list != null && !this.list.isEmpty()) {
            this.filterList.addAll(this.list);
            this.commandAdapter = new SlashCommandAdapter(context, this.filterList);
            this.mListView.setAdapter((ListAdapter)this.commandAdapter);
            this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (MMSlashCommandPopupView.this.onSlashCommandClickListener != null) {
                        MMSlashCommandPopupView.this.onSlashCommandClickListener.onSlashCommandClick((SlashItem)MMSlashCommandPopupView.this.filterList.get(position));
                        MMSlashCommandPopupView.this.dismiss();
                    }
                }
            });
        }
    }

    private List<SlashItem> filterListByString(String filter) {
        if (TextUtils.isEmpty((CharSequence)filter)) {
            this.filterList.clear();
        } else {
            this.filterList.clear();
            if (this.list != null && !this.list.isEmpty()) {
                for (SlashItem item : this.list) {
                    if (!item.getCommand().startsWith(filter)) continue;
                    this.filterList.add(item);
                }
            }
        }
        return this.filterList;
    }

    private List<SlashItem> loadAndSortData() {
        ArrayList<SlashItem> list = new ArrayList<SlashItem>();
        ABContactsCache cache = null;
        if (PTApp.getInstance().isPhoneNumberRegistered() && !(cache = ABContactsCache.getInstance()).isCached() && !cache.reloadAllContacts()) {
            return list;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return list;
        }
        List<String> robotBuddies = messenger.getAllRobotBuddies(this.mGroupId);
        if (robotBuddies != null) {
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return list;
            }
            String myselfJid = myself.getJid();
            for (int i = 0; i < robotBuddies.size(); ++i) {
                IMAddrBookItem item;
                String jid = robotBuddies.get(i);
                ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
                if (buddy == null || StringUtil.isSameString((String)buddy.getJid(), (String)myselfJid) || buddy.isZoomRoom() || !buddy.isRobot() || (item = IMAddrBookItem.fromZoomBuddy(buddy)) == null) continue;
                list.add(new SlashItem(item));
            }
        }
        if (list.size() > 1) {
            Collections.sort(list, new SlashCommandItemComparator(CompatUtils.getLocalDefault()));
        }
        return list;
    }

    public void show() {
        if (this.filterList != null && !this.filterList.isEmpty()) {
            this.showAtLocation(this.mParent, 48, 0, 0);
        }
    }

    public class SlashCommandItemComparator
    implements Comparator<SlashItem> {
        private Collator mCollator;

        public SlashCommandItemComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(SlashItem lhs, SlashItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            String str1 = this.getItemSortKey(lhs);
            String str2 = this.getItemSortKey(rhs);
            return this.mCollator.compare(str1, str2);
        }

        private String getItemSortKey(SlashItem item) {
            String owner = item.getOwner();
            if (owner == null) {
                owner = "";
            }
            return owner;
        }
    }

    private class SlashCommandAdapter
    extends BaseAdapter {
        private List<SlashItem> mList = new ArrayList<SlashItem>();
        private Context context;

        public SlashCommandAdapter(Context context, List<SlashItem> mList) {
            this.mList = mList;
            this.context = context;
        }

        public int getCount() {
            return this.mList.size();
        }

        public Object getItem(int position) {
            return this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.zm_mm_slash_command_item, parent, false);
            }
            LinearLayout ownerLinear = (LinearLayout)convertView.findViewById(R.id.slash_command_item_owner_linear);
            TextView owner = (TextView)convertView.findViewById(R.id.slash_command_item_owner);
            TextView command = (TextView)convertView.findViewById(R.id.slash_command_item_command);
            TextView dec = (TextView)convertView.findViewById(R.id.slash_command_item_dec);
            SlashItem item = (SlashItem)this.getItem(position);
            if (position == 0) {
                ownerLinear.setVisibility(0);
                owner.setText((CharSequence)item.getOwner());
            } else if (position > 0) {
                SlashItem preItem = (SlashItem)this.getItem(position - 1);
                if (item.getOwner().equals(preItem.getOwner())) {
                    ownerLinear.setVisibility(8);
                } else {
                    ownerLinear.setVisibility(0);
                    owner.setText((CharSequence)item.getOwner());
                }
            } else {
                ownerLinear.setVisibility(8);
            }
            command.setText((CharSequence)item.getCommand());
            dec.setText((CharSequence)item.getDec());
            return convertView;
        }
    }

    public class SlashItem {
        private String owner = "";
        private String command = "";
        private String dec = "";
        private String jid = "";

        public SlashItem(IMAddrBookItem item) {
            if (item != null) {
                this.owner = item.getScreenName();
                this.command = item.getRobotCmdPrefix();
                this.jid = item.getJid();
            }
        }

        public SlashItem(String owner, String command) {
            this.owner = owner;
            this.command = command;
        }

        public SlashItem(String owner, String command, String dec, String jid) {
            this.owner = owner;
            this.command = command;
            this.dec = dec;
            this.jid = jid;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getDec() {
            return this.dec;
        }

        public void setDec(String dec) {
            this.dec = dec;
        }
    }

    public static interface OnSlashCommandClickListener {
        public void onSlashCommandClick(SlashItem var1);
    }
}

