/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.Toast;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFileListActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMSetGroupInformationFragment
extends ZMDialogFragment
implements View.OnClickListener {
    public static final String EXTRA_ARGS_GROUP_JID = "groupJid";
    public static final String RESULT_ARGS_UPDATE_SUCCESS = "updateSuccess";
    private static final String TAG = MMSetGroupInformationFragment.class.getSimpleName();
    private Button mBtnDone;
    private EditText mEdtTopic;
    private String mGroupId;
    private View mPanelConvertPrivateGroup;
    private CheckedTextView mChkAccessHistory;
    private View mOptionAccessHistory;
    private ZMDialogFragment mWaitingDialog;
    private View mPanelAccessHistory;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onGroupAction(int result, GroupAction action, String messageId) {
            MMSetGroupInformationFragment.this.onGroupAction(result, action, messageId);
        }

        @Override
        public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
            MMSetGroupInformationFragment.this.onNotify_MUCGroupInfoUpdatedImpl(groupID);
        }
    };

    public static void showAsActivity(Fragment fragment, String groupJid, int requestCode) {
        if (StringUtil.isEmptyOrNull((String)groupJid)) {
            return;
        }
        Bundle args = new Bundle();
        args.putString(EXTRA_ARGS_GROUP_JID, groupJid);
        SimpleActivity.show(fragment, MMSetGroupInformationFragment.class.getName(), args, requestCode, false, 1);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_set_group_information, container, false);
        this.mBtnDone = (Button)view.findViewById(R.id.btnDone);
        this.mBtnDone.setEnabled(false);
        this.mEdtTopic = (EditText)view.findViewById(R.id.edtTopic);
        this.mPanelConvertPrivateGroup = view.findViewById(R.id.panelConvertPrivateGroup);
        this.mChkAccessHistory = (CheckedTextView)view.findViewById(R.id.chkAccessHistory);
        this.mPanelAccessHistory = view.findViewById(R.id.panelAccessHistory);
        this.mOptionAccessHistory = view.findViewById(R.id.optionAccessHistory);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnConvertPrivateGroup).setOnClickListener((View.OnClickListener)this);
        this.mBtnDone.setOnClickListener((View.OnClickListener)this);
        this.mOptionAccessHistory.setOnClickListener((View.OnClickListener)this);
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        return view;
    }

    public void onDestroyView() {
        super.onDestroyView();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void onResume() {
        super.onResume();
        this.updateData();
    }

    private void updateData() {
        if (StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        this.mEdtTopic.setText((CharSequence)group.getGroupName());
        this.mEdtTopic.setSelection(this.mEdtTopic.length());
        this.mPanelAccessHistory.setVisibility(this.isGroupOwner() ? 0 : 8);
        if ((group.getMucType() & 0x20) != 0) {
            this.mChkAccessHistory.setChecked(false);
        } else {
            this.mChkAccessHistory.setChecked(true);
        }
    }

    private boolean isGroupOwner() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return false;
        }
        return group.isGroupOperatorable();
    }

    private void onGroupAction(final int result, final GroupAction action, String messageId) {
        if (action.getActionType() == 1 || action.getActionType() == 6) {
            String groupId = action.getGroupId();
            if (!StringUtil.isSameString((String)groupId, (String)this.mGroupId)) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            if (!StringUtil.isSameString((String)myself.getJid(), (String)action.getActionOwnerId())) {
                if (this.isResumed()) {
                    this.updateData();
                }
                return;
            }
            EventTaskManager eventTaskManager = this.getEventTaskManager();
            if (eventTaskManager != null) {
                eventTaskManager.pushLater(new EventAction("GroupAction.ACTION_MODIFY_NAME"){

                    public void run(IUIElement ui) {
                        MMSetGroupInformationFragment f = (MMSetGroupInformationFragment)ui;
                        if (f != null) {
                            f.handleGroupAction(result, action);
                        }
                    }
                });
            }
        }
    }

    private void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        if (StringUtil.isSameString((String)groupID, (String)this.mGroupId)) {
            this.updateData();
        }
    }

    private void handleGroupAction(int result, GroupAction action) {
        this.dismissWaitingDialog();
        if (result == 0) {
            this.updateData();
        } else if (action.getActionType() == 1) {
            this.showChangeTopicFailureMessage(result);
        } else if (action.getActionType() == 6) {
            this.showChangeTypeFailureMessage(result);
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Bundle args = this.getArguments();
        this.mGroupId = args.getString(EXTRA_ARGS_GROUP_JID);
        this.mEdtTopic.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                MMSetGroupInformationFragment.this.mBtnDone.setEnabled(false);
                if (StringUtil.isEmptyOrNull((String)MMSetGroupInformationFragment.this.mGroupId) || TextUtils.isEmpty((CharSequence)s)) {
                    return;
                }
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                ZoomGroup group = messenger.getGroupById(MMSetGroupInformationFragment.this.mGroupId);
                if (group == null) {
                    return;
                }
                if (s.toString().equalsIgnoreCase(group.getGroupName())) {
                    return;
                }
                MMSetGroupInformationFragment.this.mBtnDone.setEnabled(true);
            }
        });
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.dismiss();
        } else if (id2 == R.id.btnDone) {
            this.onClickBtnDone();
        } else if (id2 == R.id.btnConvertPrivateGroup) {
            this.onClickConvertPrivateGroup();
        } else if (v == this.mOptionAccessHistory) {
            this.onChkAccessHistory();
        }
    }

    private void onChkAccessHistory() {
        if (StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        if (group.isNewMUC() || group.isRoom()) {
            this.setGroupAccessHistory(!this.mChkAccessHistory.isChecked());
        } else if (this.mChkAccessHistory.isChecked()) {
            AccessHistoryDialog.showDialog(this.getFragmentManager());
        }
    }

    private void onClickConvertPrivateGroup() {
        ShowConvertDialog.showDialog(this.getFragmentManager());
    }

    private void onClickBtnDone() {
        if (StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            return;
        }
        String groupName = this.mEdtTopic.getText().toString();
        if (StringUtil.isEmptyOrNull((String)groupName) || groupName.trim().length() == 0) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        if (groupName.equalsIgnoreCase(group.getGroupName())) {
            return;
        }
        if (messenger.checkGroupNameIsExist(groupName)) {
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.zm_mm_create_same_group_name_error_22375).setPositiveButton(R.string.zm_btn_ok, null);
            builder.show();
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (int i = 0; i < group.getBuddyCount(); ++i) {
            ZoomBuddy buddy = group.getBuddyAt(i);
            buddies.add(buddy.getJid());
        }
        int res = messenger.editGroupChat(this.mGroupId, groupName, buddies, group.getMucType());
        if (res == 0) {
            this.showWaitingDialog();
        } else if (res == 2) {
            this.showChangeTopicFailureMessage(1);
        }
    }

    private void setGroupAccessHistory(boolean isAllow) {
        if (StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (int i = 0; i < group.getBuddyCount(); ++i) {
            ZoomBuddy buddy = group.getBuddyAt(i);
            buddies.add(buddy.getJid());
        }
        int type = group.getMucType();
        type = !isAllow ? (type |= 0x20) : (type &= 0xFFFFFFDF);
        int res = messenger.editGroupChat(this.mGroupId, group.getGroupName(), buddies, type);
        if (res == 0) {
            this.showWaitingDialog();
        } else if (res == 2) {
            this.showChangeTypeFailureMessage(1);
        }
    }

    private void doConvertPrivateGroup() {
        if (StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(this.mGroupId);
        if (group == null) {
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        for (int i = 0; i < group.getBuddyCount(); ++i) {
            ZoomBuddy buddy = group.getBuddyAt(i);
            buddies.add(buddy.getJid());
        }
        int type = group.getMucType();
        type &= 0xFFFFFFF3;
        type &= 0xFFFFFFF1;
        int res = messenger.editGroupChat(this.mGroupId, group.getGroupName(), buddies, type |= 0xC);
        if (res == 0) {
            this.showWaitingDialog();
        } else if (res == 2) {
            this.showChangeTypeFailureMessage(1);
        }
    }

    private void showWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        this.mWaitingDialog = new WaitingDialog(R.string.zm_msg_waiting);
        this.mWaitingDialog.setCancelable(true);
        this.mWaitingDialog.show(fm, "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        FragmentManager fm = this.getFragmentManager();
        if (fm == null) {
            return;
        }
        ZMDialogFragment waitingDialog = (ZMDialogFragment)fm.findFragmentByTag("WaitingDialog");
        if (waitingDialog != null) {
            waitingDialog.dismissAllowingStateLoss();
        } else if (this.mWaitingDialog != null) {
            try {
                this.mWaitingDialog.dismissAllowingStateLoss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mWaitingDialog = null;
    }

    private void showChangeTopicFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
            return;
        }
        String msg = context.getString(R.string.zm_mm_msg_change_group_topic_failed);
        Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
    }

    private void showChangeTypeFailureMessage(int result) {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        if (result == 10) {
            this.showConnectionError();
            return;
        }
        String msg = context.getString(R.string.zm_mm_msg_convert_private_group_failed);
        Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)1).show();
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public static class ShowConvertDialog
    extends ZMDialogFragment {
        public static void showDialog(FragmentManager fragmentMgr) {
            ShowConvertDialog dlg = new ShowConvertDialog();
            Bundle args = new Bundle();
            dlg.setArguments(args);
            dlg.show(fragmentMgr, ZMFileListActivity.ShowAlertDialog.class.getName());
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ShowConvertDialog.this.onClickConvertPrivateGroup();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, null);
            builder.setMessage(R.string.zm_msg_convert_private_group);
            return builder.create();
        }

        private void onClickConvertPrivateGroup() {
            MMSetGroupInformationFragment fragment = (MMSetGroupInformationFragment)this.getFragmentManager().findFragmentByTag(MMSetGroupInformationFragment.class.getName());
            if (fragment != null) {
                fragment.doConvertPrivateGroup();
            }
        }
    }

    public static class AccessHistoryDialog
    extends ZMDialogFragment {
        public static void showDialog(FragmentManager fragmentMgr) {
            AccessHistoryDialog dlg = new AccessHistoryDialog();
            Bundle args = new Bundle();
            dlg.setArguments(args);
            dlg.show(fragmentMgr, AccessHistoryDialog.class.getName());
        }

        @NonNull
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    AccessHistoryDialog.this.onClickDisableAccessHistory();
                }
            }).setNegativeButton(R.string.zm_btn_cancel, null);
            builder.setMessage(R.string.zm_msg_access_history_alert_42597);
            return builder.create();
        }

        private void onClickDisableAccessHistory() {
            MMSetGroupInformationFragment fragment = (MMSetGroupInformationFragment)this.getFragmentManager().findFragmentByTag(MMSetGroupInformationFragment.class.getName());
            if (fragment != null) {
                fragment.setGroupAccessHistory(false);
            }
        }
    }
}

