/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.GroupAvatarDrawable_v2;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMSelectSessionListItem {
    private String sessionId;
    private String title;
    private String avatar;
    private boolean isGroup;
    private long timeStamp;
    private IMAddrBookItem fromContact;
    private Handler mHandler = new Handler();

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public void setIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public IMAddrBookItem getFromContact() {
        return this.fromContact;
    }

    public void setFromContact(IMAddrBookItem fromContact) {
        this.fromContact = fromContact;
    }

    public boolean isBuddyWithPhoneNumberInSession(String phoneNumber) {
        if (phoneNumber == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        if (this.isGroup) {
            ZoomGroup group = messenger.getGroupById(this.sessionId);
            if (group == null) {
                return false;
            }
            int count = group.getBuddyCount();
            for (int i = 0; i < count; ++i) {
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null || !StringUtil.isSameString((String)phoneNumber, (String)buddy.getPhoneNumber())) continue;
                return true;
            }
        } else {
            ZoomBuddy buddy = messenger.getBuddyWithPhoneNumber(phoneNumber);
            if (buddy == null) {
                return false;
            }
            return StringUtil.isSameString((String)phoneNumber, (String)buddy.getPhoneNumber());
        }
        return false;
    }

    public boolean isBuddyWithJIDInSession(String jid) {
        if (jid == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        if (this.isGroup) {
            ZoomGroup group = messenger.getGroupById(this.sessionId);
            if (group == null) {
                return false;
            }
            int count = group.getBuddyCount();
            for (int i = 0; i < count; ++i) {
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null || !StringUtil.isSameString((String)jid, (String)buddy.getJid())) continue;
                return true;
            }
        } else {
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy == null) {
                return false;
            }
            return StringUtil.isSameString((String)this.sessionId, (String)buddy.getJid());
        }
        return false;
    }

    public View getView(Context context, View convertView, ViewGroup parent, MemCache<String, Drawable> avatarCache, boolean disableLazyLoadAvatar) {
        IMAddrBookItem addrItem;
        if (context == null) {
            return null;
        }
        View view = null;
        String tag = "MMSelectSessionListItem";
        if (convertView != null && "MMSelectSessionListItem".equals(convertView.getTag())) {
            view = convertView;
        } else {
            LayoutInflater factory = LayoutInflater.from((Context)context);
            if (factory == null) {
                return null;
            }
            view = factory.inflate(R.layout.zm_mm_select_session_list_item, parent, false);
            view.setTag((Object)"MMSelectSessionListItem");
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return view;
        }
        AvatarView avatarView = (AvatarView)view.findViewById(R.id.avatarView);
        TextView txtTitle = (TextView)view.findViewById(R.id.txtTitle);
        ImageView imgPresence = (ImageView)view.findViewById(R.id.imgPresence);
        if (avatarView != null) {
            if (!this.isGroup) {
                avatarView.setName(this.title);
                addrItem = this.getFromContact();
                if (addrItem != null) {
                    avatarView.setBgColorSeedString(addrItem.getJid());
                }
            }
            if (disableLazyLoadAvatar) {
                this.loadAvatar(avatarView, context, false, avatarCache);
            } else if (!this.loadAvatar(avatarView, context, true, avatarCache)) {
                this.lazyLoadAvatar(avatarView, context, avatarCache);
            }
        }
        if (txtTitle != null && this.title != null) {
            txtTitle.setText((CharSequence)this.title);
        }
        if (!this.isGroup) {
            addrItem = this.getFromContact();
            if (addrItem == null) {
                return view;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(addrItem.getJid());
            if (buddy == null) {
                return view;
            }
            boolean isBuddy = messenger.isMyContact(addrItem.getJid());
            if (!(isBuddy || PTApp.getInstance().isPhoneNumberRegistered() && addrItem.getContactId() >= 0)) {
                imgPresence.setVisibility(8);
            } else {
                imgPresence.setVisibility(0);
                this.loadPresenceStatus(messenger, imgPresence, buddy);
            }
        } else {
            imgPresence.setVisibility(8);
        }
        return view;
    }

    private void loadPresenceStatus(ZoomMessenger messenger, ImageView imgPresence, ZoomBuddy buddy) {
        if (messenger.isConnectionGood() && (buddy.isDesktopOnline() || buddy.isMobileOnline())) {
            switch (buddy.getPresence()) {
                case 3: {
                    imgPresence.setImageResource(R.drawable.zm_status_available);
                    imgPresence.setContentDescription((CharSequence)imgPresence.getResources().getString(R.string.zm_description_mm_presence_available));
                    break;
                }
                case 1: {
                    imgPresence.setImageResource(R.drawable.zm_status_idle);
                    imgPresence.setContentDescription((CharSequence)imgPresence.getResources().getString(R.string.zm_description_mm_presence_idle));
                    break;
                }
                case 2: {
                    imgPresence.setImageResource(R.drawable.zm_status_dnd);
                    imgPresence.setContentDescription((CharSequence)imgPresence.getResources().getString(R.string.zm_description_mm_presence_dnd_19903));
                    break;
                }
                case 4: {
                    imgPresence.setImageResource(R.drawable.zm_status_dnd);
                    imgPresence.setContentDescription((CharSequence)imgPresence.getResources().getString(R.string.zm_description_mm_presence_xa_19903));
                    break;
                }
                default: {
                    if (buddy.isMobileOnline()) {
                        imgPresence.setImageResource(R.drawable.zm_status_available);
                        imgPresence.setContentDescription((CharSequence)imgPresence.getResources().getString(R.string.zm_description_mm_presence_available));
                        break;
                    }
                    imgPresence.setImageResource(R.drawable.zm_offline);
                    imgPresence.setContentDescription((CharSequence)imgPresence.getResources().getString(R.string.zm_description_mm_presence_offline));
                    break;
                }
            }
        } else {
            imgPresence.setImageResource(R.drawable.zm_offline);
            imgPresence.setContentDescription((CharSequence)imgPresence.getResources().getString(R.string.zm_description_mm_presence_offline));
        }
    }

    private void lazyLoadAvatar(final AvatarView avatarView, final Context context, final MemCache<String, Drawable> avatarCache) {
        avatarView.setCornerRadiusRatio(0.5f);
        avatarView.setAvatar((Drawable)null);
        avatarView.setTag(this);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Object tag = avatarView.getTag();
                if (tag != MMSelectSessionListItem.this) {
                    return;
                }
                MMSelectSessionListItem.this.loadAvatar(avatarView, context, false, avatarCache);
            }
        }, 300L);
    }

    private boolean loadAvatar(AvatarView avatarView, Context context, boolean fromMemCacheOnly, MemCache<String, Drawable> avatarCache) {
        Bitmap bmp;
        File file;
        Drawable drawable2;
        if (avatarCache != null && (drawable2 = avatarCache.getCachedItem(this.sessionId)) != null) {
            avatarView.setCornerRadiusRatio(this.isGroup ? 0.0f : 0.5f);
            avatarView.setAvatar(drawable2);
            avatarView.setTag(this);
            return true;
        }
        boolean needClearIfNoCache = true;
        Object tag = avatarView.getTag();
        if (tag instanceof MMSelectSessionListItem) {
            MMSelectSessionListItem lastItem = (MMSelectSessionListItem)tag;
            if (StringUtil.isSameString((String)lastItem.sessionId, (String)this.sessionId)) {
                needClearIfNoCache = false;
            }
        }
        avatarView.setTag(this);
        String avatar = this.getAvatar();
        if (!StringUtil.isEmptyOrNull((String)avatar) && (file = new File(avatar)).exists() && file.isFile() && (bmp = ZMBitmapFactory.decodeFile(avatar, fromMemCacheOnly)) != null) {
            avatarView.setCornerRadiusRatio(0.5f);
            BitmapDrawable drawable3 = new BitmapDrawable(context.getResources(), bmp);
            avatarView.setAvatar(avatar);
            if (avatarCache != null) {
                avatarCache.cacheItem(this.sessionId, (Drawable)drawable3);
            }
            return true;
        }
        if (this.fromContact != null) {
            Bitmap bmp2 = this.fromContact.getAvatarBitmap(context, fromMemCacheOnly);
            if (bmp2 != null) {
                avatarView.setCornerRadiusRatio(0.5f);
                BitmapDrawable drawable4 = new BitmapDrawable(context.getResources(), bmp2);
                avatarView.setAvatar((Drawable)drawable4);
                if (avatarCache != null) {
                    avatarCache.cacheItem(this.sessionId, (Drawable)drawable4);
                }
                return true;
            }
            if (!fromMemCacheOnly || needClearIfNoCache) {
                avatarView.setCornerRadiusRatio(0.5f);
                avatarView.setAvatar((Drawable)null);
            }
        } else {
            if (this.isGroup) {
                avatarView.setAvatar(new GroupAvatarDrawable_v2(this.getSessionId()));
                return true;
            }
            if (!fromMemCacheOnly || needClearIfNoCache) {
                avatarView.setCornerRadiusRatio(0.5f);
                avatarView.setAvatar((Drawable)null);
            }
        }
        return false;
    }
}

