/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.mm.MMSelectSessionListItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMSelectSessionListAdapter
extends BaseAdapter {
    private static final int ITEM_TYPE_NORMAL = 0;
    private static final String TAG_ACTION_ITEM = "actionItem";
    private List<MMSelectSessionListItem> items = new ArrayList<MMSelectSessionListItem>();
    private List<MMSelectSessionListItem> filteredItems = new ArrayList<MMSelectSessionListItem>();
    private Context mContext;
    private String mFilter;
    private MemCache<String, Drawable> mAvatarCache;
    private boolean mLazyLoadAvatarDisabled = false;

    public MMSelectSessionListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void setAvatarCache(MemCache<String, Drawable> avatarCache) {
        this.mAvatarCache = avatarCache;
    }

    public void clear() {
        this.items.clear();
        this.filteredItems.clear();
    }

    public void addItem(MMSelectSessionListItem item) {
        assert (item != null);
        int oldIdx = this.findItem(item.getSessionId());
        if (oldIdx >= 0) {
            this.items.set(oldIdx, item);
        } else {
            this.items.add(item);
        }
    }

    public boolean removeItem(String sessionId) {
        int pos = this.findItem(sessionId);
        if (pos >= 0) {
            this.items.remove(pos);
            return true;
        }
        if (this.mFilter != null) {
            for (int i = 0; i < this.filteredItems.size(); ++i) {
                MMSelectSessionListItem item = this.filteredItems.get(i);
                if (!sessionId.equals(item.getSessionId())) continue;
                this.filteredItems.remove(i);
                break;
            }
        }
        return false;
    }

    private int findItem(String sessionId) {
        if (sessionId == null) {
            return -1;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            MMSelectSessionListItem item = this.items.get(i);
            if (!sessionId.equals(item.getSessionId())) continue;
            return i;
        }
        return -1;
    }

    public MMSelectSessionListItem getItemBySessionId(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            MMSelectSessionListItem item = this.items.get(i);
            if (!sessionId.equals(item.getSessionId())) continue;
            return item;
        }
        return null;
    }

    public int getCount() {
        if (this.mFilter != null) {
            return this.filteredItems.size();
        }
        return this.items.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        if (this.mFilter != null) {
            return this.filteredItems.get(position);
        }
        return this.items.get(position);
    }

    public int getChatsItemsCount() {
        return this.items.size();
    }

    public MMSelectSessionListItem getChatsItem(int position) {
        if (position < 0 || position >= this.getChatsItemsCount()) {
            return null;
        }
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        if (this.mFilter != null) {
            return 0;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public void setLazyLoadAvatarDisabled(boolean disabled) {
        this.mLazyLoadAvatarDisabled = disabled;
    }

    private void sort() {
        Collections.sort(this.items, new MMSelectSessionListItemComparator());
    }

    public void notifyDataSetChanged() {
        this.sort();
        if (this.mFilter != null) {
            this.forceFilter(this.mFilter);
        }
        super.notifyDataSetChanged();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        Object item = this.getItem(position);
        if (item == null) {
            return null;
        }
        if (item instanceof MMSelectSessionListItem) {
            return ((MMSelectSessionListItem)item).getView(this.mContext, convertView, parent, this.mAvatarCache, this.mLazyLoadAvatarDisabled);
        }
        if (item instanceof ActionItem) {
            return this.getActionItemView((ActionItem)item, this.mContext, convertView, parent);
        }
        return null;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        Object item = this.getItem(position);
        if (item == null) {
            return false;
        }
        if (item instanceof MMSelectSessionListItem) {
            return true;
        }
        if (item instanceof ActionItem) {
            return ((ActionItem)item).enabled;
        }
        return false;
    }

    private View getActionItemView(ActionItem item, Context context, View convertView, ViewGroup parent) {
        LayoutInflater factory = LayoutInflater.from((Context)context);
        if (factory == null) {
            return null;
        }
        View view = null;
        if (convertView == null || !TAG_ACTION_ITEM.equals(convertView.getTag())) {
            view = factory.inflate(R.layout.zm_mm_chats_list_action_item, parent, false);
            view.setTag((Object)TAG_ACTION_ITEM);
        } else {
            view = convertView;
        }
        ImageView imgIcon = (ImageView)view.findViewById(R.id.imgIcon);
        TextView txtLabel = (TextView)view.findViewById(R.id.txtLabel);
        TextView txtDesc = (TextView)view.findViewById(R.id.txtDesc);
        if (imgIcon != null) {
            imgIcon.setImageResource(item.icon);
            imgIcon.setEnabled(item.enabled);
        }
        if (txtLabel != null) {
            txtLabel.setText((CharSequence)item.label);
            txtLabel.setEnabled(item.enabled);
        }
        if (txtDesc != null) {
            if (StringUtil.isEmptyOrNull((String)item.desc)) {
                txtDesc.setVisibility(8);
            } else {
                txtDesc.setVisibility(8);
                txtDesc.setText((CharSequence)item.desc);
                txtDesc.setEnabled(item.enabled);
            }
        }
        view.setEnabled(item.enabled);
        return view;
    }

    public void filter(String filter) {
        if (StringUtil.isSameString((String)this.mFilter, (String)(filter = StringUtil.isEmptyOrNull((String)filter) ? null : filter.trim().toLowerCase(CompatUtils.getLocalDefault())))) {
            return;
        }
        this.forceFilter(filter);
        super.notifyDataSetChanged();
    }

    private void forceFilter(String filter) {
        this.mFilter = filter;
        this.filteredItems.clear();
        if (this.mFilter == null) {
            return;
        }
        Locale locale = CompatUtils.getLocalDefault();
        for (MMSelectSessionListItem item : this.items) {
            String title = item.getTitle();
            if (title == null || title.toLowerCase(locale).indexOf(filter) < 0) continue;
            this.filteredItems.add(item);
        }
    }

    public static class ActionItem {
        public static final int ACTION_HOST_MEETING = 0;
        public static final int ACTION_JOIN_MEETING = 1;
        public static final int ACTION_BACK_TO_MEETING = 2;
        public int action = 0;
        public int icon = 0;
        public String label = null;
        public String desc = null;
        public boolean enabled = true;

        public ActionItem(int action, int icon, String label, String desc) {
            this.action = action;
            this.icon = icon;
            this.label = label;
            this.desc = desc;
        }
    }

    static class MMSelectSessionListItemComparator
    implements Comparator<MMSelectSessionListItem> {
        MMSelectSessionListItemComparator() {
        }

        @Override
        public int compare(MMSelectSessionListItem lhs, MMSelectSessionListItem rhs) {
            if (lhs.getTimeStamp() > rhs.getTimeStamp()) {
                return -1;
            }
            if (lhs.getTimeStamp() < rhs.getTimeStamp()) {
                return 1;
            }
            return 0;
        }
    }
}

