/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.fragment.MMSelectSessionAndBuddyFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZMSortUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddySearchData;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.WebSearchResult;
import com.zipow.videobox.view.mm.MMSelectSessionAndBuddyListAdapter;
import com.zipow.videobox.view.mm.MMZoomGroup;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMSelectSessionAndBuddyListView
extends ListView
implements AdapterView.OnItemClickListener {
    private static final String TAG = MMSelectSessionAndBuddyListView.class.getSimpleName();
    private static final int MAX_LOCAL_CONTACTS_NUM = 100;
    private MMSelectSessionAndBuddyListAdapter mAdapter;
    private MMSelectSessionAndBuddyFragment mParentFragment;
    private Handler mHandler = new Handler();
    private Runnable mTaskLazyNotifyDataSetChanged = null;
    private String mFilter;
    private List<IMAddrBookItem> mContactsCache;
    private List<MMZoomGroup> mGroupsCache;
    private List<MMZoomGroup> mAllGroupsCache;
    private boolean mIsWebSearchMode;
    private WebSearchResult mWebSearchResult;
    private Runnable mFilterRunnabel;
    private boolean mContainsE2E;
    private boolean mContainsBlock;

    public MMSelectSessionAndBuddyListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMSelectSessionAndBuddyListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMSelectSessionAndBuddyListView(Context context) {
        super(context);
        this.initView();
    }

    public void setParentFragment(MMSelectSessionAndBuddyFragment fragment) {
        this.mParentFragment = fragment;
    }

    public boolean isParentFragmentResumed() {
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.isResumed();
    }

    public void onParentFragmentResume() {
        this.loadData();
        this.mAdapter.notifyDataSetChanged();
    }

    public void onParentFragmentStart() {
        this.mAdapter.notifyDataSetChanged();
    }

    private void initView() {
        this.mAdapter = new MMSelectSessionAndBuddyListAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
    }

    public void loadData() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        List<String> blockUsers = messenger.blockUserGetAll();
        if (blockUsers == null) {
            blockUsers = new ArrayList<String>();
        }
        if (StringUtil.isEmptyOrNull((String)this.mFilter)) {
            ZoomBuddy buddy;
            this.mContactsCache = new ArrayList<IMAddrBookItem>();
            this.mGroupsCache = new ArrayList<MMZoomGroup>();
            int cntSessions = messenger.getChatSessionCount();
            int myOption = messenger.e2eGetMyOption();
            List<String> buddies = new ArrayList<String>();
            for (int i = 0; i < cntSessions; ++i) {
                ZoomChatSession session = messenger.getSessionAt(i);
                if (session == null || session.isGroup() || (buddy = session.getSessionBuddy()) == null || !this.mContainsBlock && blockUsers.contains(buddy.getJid()) || buddy.isRobot() || !this.mContainsE2E && buddy.getE2EAbility(myOption) == 2) continue;
                buddies.add(session.getSessionId());
            }
            if ((buddies = ZMSortUtil.sortBuddies(buddies, 0, this.mFilter)) != null) {
                for (String jid : buddies) {
                    IMAddrBookItem item;
                    buddy = messenger.getBuddyWithJID(jid);
                    if (buddy == null || buddy.isRobot() || (item = IMAddrBookItem.fromZoomBuddy(buddy)) == null) continue;
                    this.mContactsCache.add(item);
                }
            }
        } else {
            this.mContactsCache = this.getSearchedBuddies(messenger);
        }
        this.mGroupsCache = this.getSearchedGroups(messenger);
        this.updateListData();
        this.mAdapter.notifyDataSetChanged();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putBoolean("mIsWebSearchMode", this.mIsWebSearchMode);
        bundle.putSerializable("mWebSearchResult", (Serializable)this.mWebSearchResult);
        bundle.putString("mFilter", this.mFilter);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state != null && state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mIsWebSearchMode = bundle.getBoolean("mIsWebSearchMode");
            state = bundle.getParcelable("superState");
            this.mFilter = bundle.getString("mFilter");
            this.mWebSearchResult = (WebSearchResult)bundle.getSerializable("mWebSearchResult");
            this.loadData();
        }
        super.onRestoreInstanceState(state);
    }

    private void updateListData() {
        this.mAdapter.clear();
        ArrayList<Object> data = new ArrayList<Object>();
        if (this.mContactsCache != null && this.mContactsCache.size() > 0 || !this.mIsWebSearchMode && this.mFilter != null && this.mFilter.length() >= 3) {
            data.add(this.getContext().getString(R.string.zm_lbl_share_category_contact));
        }
        if (this.mContactsCache != null) {
            data.addAll(this.mContactsCache);
        }
        if (!this.mIsWebSearchMode && this.mFilter != null && this.mFilter.length() >= 3) {
            if (this.mContactsCache.size() > 0) {
                data.add(new MMSelectSessionAndBuddyListAdapter.ItemViewMore());
            } else {
                this.mParentFragment.onClickViewMore();
            }
        }
        if (this.mGroupsCache != null && this.mGroupsCache.size() > 0) {
            data.add(this.getContext().getString(R.string.zm_lbl_share_category_groups_chats));
            data.addAll(this.mGroupsCache);
        }
        this.mAdapter.addItems(data);
    }

    private List<IMAddrBookItem> getSearchedBuddies(ZoomMessenger messenger) {
        if (messenger == null || TextUtils.isEmpty((CharSequence)this.mFilter)) {
            return null;
        }
        HashSet<String> buddies = new HashSet<String>();
        List<String> localBuddies = messenger.localStrictSearchBuddies(this.mFilter, null);
        buddies.addAll(localBuddies);
        if (this.mIsWebSearchMode) {
            this.mWebSearchResult = new WebSearchResult();
            ZoomBuddySearchData searchData = messenger.getBuddySearchData();
            if (searchData != null) {
                ZoomBuddySearchData.SearchKey searchKey = searchData.getSearchKey();
                ArrayList<String> webSearched = new ArrayList<String>();
                if (searchKey != null && TextUtils.equals((CharSequence)searchData.getSearchKey().getKey(), (CharSequence)this.mFilter)) {
                    this.mWebSearchResult.setKey(this.mFilter);
                    for (int i = 0; i < searchData.getBuddyCount(); ++i) {
                        ZoomBuddy buddy = searchData.getBuddyAt(i);
                        if (buddy == null) continue;
                        String jid = buddy.getJid();
                        webSearched.add(jid);
                        IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
                        if (item == null) continue;
                        this.mWebSearchResult.putItem(jid, item);
                    }
                    messenger.getBuddiesPresence(webSearched, false);
                } else if (this.mWebSearchResult != null && StringUtil.isSameString((String)this.mFilter, (String)this.mWebSearchResult.getKey())) {
                    for (String jid : this.mWebSearchResult.getJids()) {
                        webSearched.add(jid);
                    }
                }
                buddies.addAll(webSearched);
            }
        }
        List<String> sorted = null;
        ArrayList<String> source = new ArrayList<String>();
        source.addAll(buddies);
        sorted = ZMSortUtil.sortBuddies(source, 0, this.mFilter);
        ArrayList<IMAddrBookItem> searchBuddiesList = new ArrayList<IMAddrBookItem>();
        if (sorted != null && sorted.size() > 0) {
            int maxNum = sorted.size();
            if (!this.mIsWebSearchMode) {
                maxNum = sorted.size() > 100 ? 100 : sorted.size();
            }
            int i = 0;
            ZoomBuddy mySelf = messenger.getMyself();
            if (mySelf != null) {
                List<String> blockUsers = messenger.blockUserGetAll();
                if (blockUsers == null) {
                    blockUsers = new ArrayList<String>();
                }
                int myOption = messenger.e2eGetMyOption();
                while (searchBuddiesList.size() < maxNum && i < sorted.size()) {
                    IMAddrBookItem item;
                    String jid = sorted.get(i);
                    ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
                    if (!(buddy == null || !this.mContainsBlock && blockUsers.contains(buddy.getJid()) || buddy.isRobot() || !this.mContainsE2E && buddy.getE2EAbility(myOption) == 2 || (item = IMAddrBookItem.fromZoomBuddy(buddy)) == null || TextUtils.equals((CharSequence)item.getJid(), (CharSequence)mySelf.getJid()))) {
                        searchBuddiesList.add(item);
                    }
                    ++i;
                }
            }
        }
        return searchBuddiesList;
    }

    private List<MMZoomGroup> getSearchedGroups(ZoomMessenger messenger) {
        if (messenger == null) {
            return null;
        }
        Locale locale = CompatUtils.getLocalDefault();
        if (this.mAllGroupsCache == null) {
            this.mAllGroupsCache = new ArrayList<MMZoomGroup>();
            int groupCount = messenger.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                MMZoomGroup mmGroup;
                ZoomGroup zoomGroup = messenger.getGroupAt(i);
                if (zoomGroup == null || (mmGroup = MMZoomGroup.initWithZoomGroup(zoomGroup)) == null || !this.mContainsE2E && mmGroup.isE2E()) continue;
                this.mAllGroupsCache.add(mmGroup);
            }
            this.mAllGroupsCache = ZMSortUtil.sortGroups(this.mAllGroupsCache);
        }
        if (this.mAllGroupsCache == null) {
            return null;
        }
        ArrayList<MMZoomGroup> cache = new ArrayList<MMZoomGroup>();
        for (MMZoomGroup mMZoomGroup : this.mAllGroupsCache) {
            String name;
            if (!StringUtil.isEmptyOrNull((String)this.mFilter) && (StringUtil.isEmptyOrNull((String)(name = mMZoomGroup.getGroupName())) || !(name = name.toLowerCase(locale)).contains(this.mFilter))) continue;
            cache.add(mMZoomGroup);
        }
        return ZMSortUtil.sortGroups(cache);
    }

    public void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void onIndicateBuddyInfoUpdatedWithJID(String jid) {
        if (!this.mParentFragment.isResumed()) {
            return;
        }
        if (this.mContactsCache == null || this.mContactsCache.size() == 0) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        boolean dataUpdated = false;
        for (int i = 0; i < this.mContactsCache.size(); ++i) {
            ZoomBuddy buddy;
            IMAddrBookItem item = this.mContactsCache.get(i);
            if (item == null || !StringUtil.isSameString((String)item.getJid(), (String)jid) || (buddy = messenger.getBuddyWithJID(jid)) == null) continue;
            IMAddrBookItem temp = IMAddrBookItem.fromZoomBuddy(buddy);
            if (temp != null) {
                this.mContactsCache.set(i, temp);
            }
            dataUpdated = true;
            break;
        }
        if (dataUpdated && this.mParentFragment.isResumed()) {
            this.lazyNotifyDataSetChanged();
        }
    }

    private void lazyNotifyDataSetChanged() {
        if (this.mTaskLazyNotifyDataSetChanged == null) {
            this.mTaskLazyNotifyDataSetChanged = new Runnable(){

                @Override
                public void run() {
                    if (MMSelectSessionAndBuddyListView.this.mParentFragment.isResumed()) {
                        MMSelectSessionAndBuddyListView.this.updateListData();
                        MMSelectSessionAndBuddyListView.this.notifyDataSetChanged();
                    }
                }
            };
        }
        this.mHandler.removeCallbacks(this.mTaskLazyNotifyDataSetChanged);
        this.mHandler.postDelayed(this.mTaskLazyNotifyDataSetChanged, 1000L);
    }

    public void setContainsE2E(boolean containsE2E) {
        this.mContainsE2E = containsE2E;
    }

    public void setContainsBlock(boolean containsBlock) {
        this.mContainsBlock = containsBlock;
    }

    public void setIsWebSearchMode(boolean isWebsearchMode) {
        this.mIsWebSearchMode = isWebsearchMode;
    }

    public void filter(String filter) {
        if (TextUtils.equals((CharSequence)this.mFilter, (CharSequence)filter)) {
            return;
        }
        this.mFilter = !TextUtils.isEmpty((CharSequence)filter) ? filter.toLowerCase(CompatUtils.getLocalDefault()) : filter;
        this.mIsWebSearchMode = false;
        this.mWebSearchResult = null;
        this.loadData();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.mAdapter.getItem(position);
        if (oItem instanceof MMZoomGroup) {
            MMZoomGroup group = (MMZoomGroup)oItem;
            if (this.mParentFragment != null) {
                this.mParentFragment.onSelect(group.getGroupId(), true);
            }
        } else if (oItem instanceof IMAddrBookItem) {
            IMAddrBookItem item = (IMAddrBookItem)oItem;
            if (this.mParentFragment != null) {
                this.mParentFragment.onSelect(item.getJid(), false);
            }
        } else if (oItem instanceof MMSelectSessionAndBuddyListAdapter.ItemViewMore && this.mParentFragment != null) {
            this.mParentFragment.onClickViewMore();
        }
    }

    public void onGroupAction(int result, GroupAction action, String msgId) {
        if (action == null) {
            return;
        }
        String groupId = action.getGroupId();
        this.updateZoomGroupByJid(groupId);
    }

    private void updateZoomGroupByJid(String groupId) {
        boolean isDeleted;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)groupId)) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(groupId);
        boolean bl = isDeleted = group == null;
        if (this.mAllGroupsCache != null) {
            for (int i = 0; i < this.mAllGroupsCache.size(); ++i) {
                MMZoomGroup zmGroup = this.mAllGroupsCache.get(i);
                if (!StringUtil.isSameString((String)zmGroup.getGroupId(), (String)groupId)) continue;
                if (isDeleted) {
                    this.mAllGroupsCache.remove(i);
                    break;
                }
                zmGroup.syncGroupWithSDK(messenger);
                break;
            }
        }
        if (this.isParentFragmentResumed()) {
            this.updateListData();
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        this.updateZoomGroupByJid(groupID);
    }

    public void onSearchBuddyByKey(String key, int result) {
        if (!StringUtil.isSameString((String)key, (String)this.mFilter)) {
            return;
        }
        this.loadData();
    }

    static class MMZoomGroupComparator
    implements Comparator<MMZoomGroup> {
        private Collator mCollator;

        public MMZoomGroupComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(MMZoomGroup lhs, MMZoomGroup rhs) {
            if (lhs == rhs) {
                return 0;
            }
            String str1 = this.getItemSortKey(lhs);
            String str2 = this.getItemSortKey(rhs);
            return this.mCollator.compare(str1, str2);
        }

        private String getItemSortKey(MMZoomGroup item) {
            return SortUtil.getSortKey((String)item.getGroupName(), (Locale)CompatUtils.getLocalDefault());
        }
    }
}

