/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.PresenceStateView;
import com.zipow.videobox.view.mm.MMChatsListItem;
import com.zipow.videobox.view.mm.MMZoomGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMSelectSessionAndBuddyListAdapter
extends BaseAdapter {
    private List<Object> mItemData = new ArrayList<Object>();
    private Context mContext;

    public MMSelectSessionAndBuddyListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void clear() {
        this.mItemData.clear();
    }

    public void addItems(List<Object> items) {
        if (items == null) {
            return;
        }
        this.mItemData.addAll(items);
    }

    public void removeItem(String jid) {
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return;
        }
        for (int i = 0; i < this.mItemData.size(); ++i) {
            Serializable itemNew;
            Object obj = this.mItemData.get(i);
            if (obj instanceof MMZoomGroup) {
                itemNew = (MMZoomGroup)obj;
                if (!TextUtils.equals((CharSequence)((MMZoomGroup)itemNew).getGroupId(), (CharSequence)jid)) continue;
                this.mItemData.remove(i);
                break;
            }
            if (!(obj instanceof IMAddrBookItem) || !TextUtils.equals((CharSequence)jid, (CharSequence)((IMAddrBookItem)(itemNew = (IMAddrBookItem)obj)).getJid())) continue;
            this.mItemData.remove(i);
            break;
        }
        this.notifyDataSetChanged();
    }

    public void updateItem(Object item) {
        boolean isSearched = false;
        if (item instanceof MMZoomGroup) {
            MMZoomGroup itemNew = (MMZoomGroup)item;
            for (int i = 0; i < this.mItemData.size(); ++i) {
                MMZoomGroup itemOld;
                Object obj = this.mItemData.get(i);
                if (!(obj instanceof MMZoomGroup) || !TextUtils.equals((CharSequence)(itemOld = (MMZoomGroup)obj).getGroupId(), (CharSequence)itemNew.getGroupId())) continue;
                this.mItemData.set(i, itemNew);
                isSearched = true;
                break;
            }
        } else if (item instanceof IMAddrBookItem) {
            IMAddrBookItem itemNew = (IMAddrBookItem)item;
            for (int i = 0; i < this.mItemData.size(); ++i) {
                IMAddrBookItem itemOld;
                Object obj = this.mItemData.get(i);
                if (!(obj instanceof IMAddrBookItem) || !TextUtils.equals((CharSequence)(itemOld = (IMAddrBookItem)obj).getJid(), (CharSequence)itemNew.getJid())) continue;
                this.mItemData.set(i, itemNew);
                isSearched = true;
                break;
            }
        }
        if (isSearched) {
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.mItemData.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItemData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        Object item = this.getItem(position);
        if (item instanceof IMAddrBookItem || item instanceof MMChatsListItem) {
            return 0;
        }
        if (item instanceof ItemViewMore) {
            return 1;
        }
        return 2;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        Object item = this.getItem(position);
        if (item == null) {
            return null;
        }
        if (item instanceof MMZoomGroup || item instanceof IMAddrBookItem) {
            return this.getContactsItemView(item, this.mContext, convertView, parent);
        }
        if (item instanceof ItemViewMore) {
            if (convertView == null || !"zm_search_view_more".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_search_view_more, null);
                convertView.setTag((Object)"zm_search_view_more");
            }
        } else {
            String str = item.toString();
            if (convertView == null || !"zm_share_category_item".equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_listview_label_item, null);
                convertView.setTag((Object)"zm_share_category_item");
            }
            TextView txtCategoryItem = (TextView)convertView.findViewById(R.id.txtHeaderLabel);
            txtCategoryItem.setText((CharSequence)str);
        }
        return convertView;
    }

    private View getContactsItemView(Object item, Context context, View convertView, ViewGroup parent) {
        LayoutInflater factory = LayoutInflater.from((Context)context);
        if (factory == null) {
            return null;
        }
        View view = null;
        if (convertView == null || !"contactsItem".equals(convertView.getTag())) {
            view = factory.inflate(R.layout.zm_share_item, parent, false);
            view.setTag((Object)"contactsItem");
        } else {
            view = convertView;
        }
        PresenceStateView imgPresence = (PresenceStateView)view.findViewById(R.id.imgPresence);
        TextView txtContactName = (TextView)view.findViewById(R.id.txtContactName);
        TextView txtGroupType = (TextView)view.findViewById(R.id.txtGroupType);
        if (item instanceof MMZoomGroup) {
            MMZoomGroup groupItem = (MMZoomGroup)item;
            imgPresence.setVisibility(8);
            txtGroupType.setVisibility(groupItem.isPublic() ? 0 : 8);
            txtContactName.setText((CharSequence)groupItem.getGroupName());
        } else if (item instanceof IMAddrBookItem) {
            IMAddrBookItem contactItem = (IMAddrBookItem)item;
            txtGroupType.setVisibility(8);
            txtContactName.setText((CharSequence)contactItem.getScreenName());
            imgPresence.setState(contactItem);
            imgPresence.setmTxtDeviceTypeGone();
        }
        return view;
    }

    public static class ItemViewMore {
    }
}

