/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;
import com.google.gson.Gson;
import com.zipow.videobox.confapp.meeting.SelectAlterHostItem;
import com.zipow.videobox.fragment.MMSelectContactsFragment;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.ptapp.ABContactsHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUserProfile;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomBuddySearchData;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.MMLocalHelper;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.MMBuddyItemComparator;
import com.zipow.videobox.view.mm.MMSelectContactsListAdapter;
import com.zipow.videobox.view.mm.MMSelectContactsListItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class MMSelectContactsListView
extends QuickSearchListView
implements AdapterView.OnItemClickListener {
    private static final String TAG = MMSelectContactsListView.class.getSimpleName();
    private static final int DELAY_LOAD_EMAILS = 300;
    public static final int CHOICE_MODE_MULTIPLE_CHOICE = 0;
    public static final int CHOICE_MODE_SINGLE_CHOICE = 1;
    private MMSelectContactsListAdapter mAdapter;
    private Listener mListener;
    private String mFilter;
    private List<MMSelectContactsListItem> mSelectedItems = new ArrayList<MMSelectContactsListItem>();
    private RetainedFragment mRetainedFragment;
    private int mLastTopPosition = 0;
    private List<String> mPreSelectedItems;
    private Set<String> mHistoryEmails;
    private String mGroupId;
    private int mChoiceMode = 0;
    private boolean mOnlySameOrganization = false;
    private MMSelectContactsFragment mParentFragment;
    private Button mBtnSearchMore;
    private int mMaxSelectCount = -1;
    private boolean mIncludeRobot = false;
    private boolean mOnlyRobot = false;
    private boolean mFilterZoomRooms = false;
    private boolean mIsShowEmail = false;
    private boolean mIsDisabledForPreSelected = true;
    private boolean mIsNeedHaveEmail = false;
    private boolean mIsNeedSortSelectedItems = true;
    private boolean mIsAlterHost = false;
    private boolean mIsAutoWebSearch = false;
    private WebSearchResult mWebSearchResult = new WebSearchResult();
    private final WebSearchResult mAutoWebSearchResult = new WebSearchResult();
    private final HashMap<String, String> mCacheJidEmail = new HashMap();
    private static final int MAX_ADDRBOOKITEM_COUNT_FOR_NO_FILTER = 250;
    private Handler mHandler = new Handler();
    private Runnable mLoadEmailsRunnable = new Runnable(){

        @Override
        public void run() {
            MMSelectContactsListView.this.loadEmailForVisibleItems();
        }
    };

    public MMSelectContactsListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMSelectContactsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMSelectContactsListView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.initAddMoreFooter();
        this.mAdapter = new MMSelectContactsListAdapter(this.getContext(), this);
        this.setOnItemClickListener(this);
        this.setmOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0 && MMSelectContactsListView.this.mIsAlterHost) {
                    MMSelectContactsListView.this.loadEmailForVisibleItems();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.setHeaderDividersEnabled(false);
        if (!this.isInEditMode()) {
            this.initRetainedFragment();
        }
    }

    public void loadEmailForVisibleItems() {
        ListView listView;
        ZoomMessenger zoomMessenger = MMLocalHelper.getGoodConnectedZoomMessenger();
        if (zoomMessenger != null && (listView = this.getmmListView()) != null) {
            List<String> jids = this.getNoEmailList(listView.getFirstVisiblePosition(), listView.getLastVisiblePosition());
            for (String jid : jids) {
                zoomMessenger.refreshBuddyVCard(jid, true);
            }
        }
    }

    private List<String> getNoEmailList(int firstVisibleCount, int lastVisibleCount) {
        int count = lastVisibleCount - firstVisibleCount;
        ArrayList<String> noEmailJids = new ArrayList<String>();
        if (count > 1) {
            MMSelectContactsListItem item;
            Object obj;
            for (int i = firstVisibleCount; i <= lastVisibleCount; ++i) {
                obj = this.getItemAtPosition(i);
                if (obj == null || !(obj instanceof MMSelectContactsListItem) || !StringUtil.isEmptyOrNull((String)(item = (MMSelectContactsListItem)obj).getEmail()) || StringUtil.isEmptyOrNull((String)item.getBuddyJid())) continue;
                noEmailJids.add(item.getBuddyJid());
            }
            int start = firstVisibleCount - count;
            if (start < 0) {
                start = 0;
            }
            for (int i = start; i < firstVisibleCount; ++i) {
                obj = this.getItemAtPosition(i);
                if (obj == null || !(obj instanceof MMSelectContactsListItem) || !StringUtil.isEmptyOrNull((String)(item = (MMSelectContactsListItem)obj).getEmail()) || StringUtil.isEmptyOrNull((String)item.getBuddyJid())) continue;
                noEmailJids.add(item.getBuddyJid());
            }
            int end = lastVisibleCount + count;
            if (end > this.getChildCount()) {
                end = this.getChildCount();
            }
            for (int i = lastVisibleCount; i < end; ++i) {
                obj = this.getItemAtPosition(i);
                if (obj == null || !(obj instanceof MMSelectContactsListItem) || !StringUtil.isEmptyOrNull((String)(item = (MMSelectContactsListItem)obj).getEmail()) || StringUtil.isEmptyOrNull((String)item.getBuddyJid())) continue;
                noEmailJids.add(item.getBuddyJid());
            }
        }
        return noEmailJids;
    }

    private void _editmode_loadAllBuddyItems(MMSelectContactsListAdapter adapter) {
        for (int i = 0; i < 20; ++i) {
            MMSelectContactsListItem item = new MMSelectContactsListItem();
            item.sortKey = item.screenName = "Buddy " + i;
            item.itemId = String.valueOf(i);
            item.setIsChecked(i % 2 == 0);
            adapter.addItem(item);
        }
    }

    private void loadAllBuddyItems(MMSelectContactsListAdapter adapter) {
        this.setQuickSearchEnabled(true);
        this.loadAllAddrBookItems(adapter);
    }

    private void loadAllAddrBookItems(MMSelectContactsListAdapter adapter) {
        ZoomMessenger messenger;
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        ABContactsCache cache = null;
        String myNumber = null;
        if (PTApp.getInstance().isPhoneNumberRegistered()) {
            cache = ABContactsCache.getInstance();
            if (!cache.isCached() && !cache.reloadAllContacts()) {
                return;
            }
            ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
            if (contactsHelper != null) {
                myNumber = contactsHelper.getVerifiedPhoneNumber();
            }
        }
        if ((messenger = PTApp.getInstance().getZoomMessenger()) == null) {
            this.loadHistoryEmails(adapter);
            adapter.sort();
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            ZoomGroup group = messenger.getGroupById(this.mGroupId);
            if (group == null) {
                return;
            }
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            String myselfJid = myself.getJid();
            int count = group.getBuddyCount();
            for (int i = 0; i < count; ++i) {
                MMSelectContactsListItem item;
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null || StringUtil.isSameString((String)buddy.getJid(), (String)myselfJid) || buddy.isZoomRoom() || (item = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, adapter, true)) == null) continue;
                adapter.addItem(item);
            }
        } else if (StringUtil.isEmptyOrNull((String)this.mFilter)) {
            for (int i = 0; i < messenger.getBuddyCount(); ++i) {
                ZoomBuddy buddy = messenger.getBuddyAt(i);
                if (buddy == null || buddy.isZoomRoom() || buddy.isPending()) continue;
                MMSelectContactsListItem item = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, adapter, false);
                if (item != null) {
                    adapter.addItem(item);
                }
                if (adapter.getCount() < 250) {
                    continue;
                }
                break;
            }
        } else {
            ZoomBuddy buddy;
            List<String> localBuddies = messenger.localStrictSearchBuddies(this.mFilter, null);
            for (String jid : localBuddies) {
                IMAddrBookItem addrItem;
                buddy = messenger.getBuddyWithJID(jid);
                if (buddy == null || buddy.isZoomRoom() || buddy.isPending() || (addrItem = IMAddrBookItem.fromZoomBuddy(buddy)) == null) continue;
                MMSelectContactsListItem item = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, adapter, false);
                if (item != null) {
                    adapter.addItem(item);
                }
                if (adapter.getCount() < 250) continue;
                break;
            }
            if (this.mWebSearchResult != null && StringUtil.isSameString((String)this.mWebSearchResult.key, (String)this.mFilter)) {
                for (String jid : this.mWebSearchResult.getAllJids()) {
                    buddy = messenger.getBuddyWithJID(jid);
                    if (buddy != null) {
                        MMSelectContactsListItem contact = this.mWebSearchResult.findByJid(jid);
                        if (contact == null) {
                            contact = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, this.mAdapter, true);
                        }
                        if (contact == null) continue;
                        this.mAdapter.updateItem(contact);
                        if (this.mAdapter.getCount() >= 250) break;
                    }
                    this.mBtnSearchMore.setVisibility(8);
                }
            }
        }
        this.loadHistoryEmails(adapter);
        adapter.sort();
    }

    private void loadHistoryEmails(MMSelectContactsListAdapter adapter) {
        if (this.mIsAlterHost && this.mHistoryEmails != null && !this.mHistoryEmails.isEmpty()) {
            for (String email : this.mHistoryEmails) {
                MMSelectContactsListItem item = this.newItemFromEmail(email, this.mAdapter);
                if (item == null) continue;
                item.setAlternativeHost(true);
                adapter.addItem(item);
            }
        }
    }

    private MMSelectContactsListItem newItemFromEmail(String email, MMSelectContactsListAdapter adapter) {
        if (email == null) {
            return null;
        }
        IMAddrBookItem item = new IMAddrBookItem();
        item.setAccoutEmail(email);
        item.setScreenName(email);
        PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
        if (profile != null && StringUtil.isSameStringForNotAllowNull((String)profile.getEmail(), (String)email)) {
            return null;
        }
        if (this.mFilter != null && this.mFilter.length() > 0) {
            Locale locale = CompatUtils.getLocalDefault();
            String lowerFilter = this.mFilter.toLowerCase(locale);
            String lowerName = email.toLowerCase(locale);
            String lowerEmail = email.toLowerCase(locale);
            if (!lowerName.contains(lowerFilter) && !lowerEmail.contains(lowerFilter)) {
                return null;
            }
        }
        adapter.setmIsShowEmail(this.mIsShowEmail);
        adapter.setmIsAlterHost(this.mIsAlterHost);
        MMSelectContactsListItem buddyItem = new MMSelectContactsListItem(item);
        MMSelectContactsListItem itemWithSameName = adapter.findFirstItemWithScreenName(email, 0);
        if (itemWithSameName != null) {
            itemWithSameName.setShowNotes(true);
            buddyItem.setShowNotes(true);
        }
        boolean isInSelectedItem = false;
        int i = 0;
        for (MMSelectContactsListItem item1 : this.mSelectedItems) {
            if (item1.isAlternativeHost() && StringUtil.isSameStringForNotAllowNull((String)email, (String)item1.getEmail())) {
                isInSelectedItem = true;
                this.mSelectedItems.set(i, buddyItem);
                break;
            }
            ++i;
        }
        if (isInSelectedItem) {
            buddyItem.setIsDisabled(this.mIsDisabledForPreSelected);
            buddyItem.setIsChecked(true);
        }
        return buddyItem;
    }

    private MMSelectContactsListItem newItemFromZoomBuddy(ZoomMessenger messenger, ZoomBuddy buddy, String myNumber, ABContactsCache cache, MMSelectContactsListAdapter adapter, boolean allInclude) {
        boolean isBuddy;
        IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
        if (!StringUtil.isEmptyOrNull((String)myNumber) && myNumber.equals(buddy.getPhoneNumber())) {
            return null;
        }
        if (item == null) {
            return null;
        }
        String jid = item.getJid();
        ZoomBuddy myself = messenger.getMyself();
        if (myself != null && StringUtil.isSameString((String)myself.getJid(), (String)jid)) {
            return null;
        }
        if (!(allInclude || StringUtil.isEmptyOrNull((String)jid) || (isBuddy = messenger.isMyContact(jid)) || item.getContactId() >= 0 || StringUtil.isSameString((String)this.mWebSearchResult.key, (String)this.mFilter) && this.mWebSearchResult.findByJid(buddy.getJid()) != null)) {
            return null;
        }
        String name = item.getScreenName();
        String email = item.getAccountEmail();
        jid = item.getJid();
        if (this.mIsNeedHaveEmail && StringUtil.isEmptyOrNull((String)email) && !StringUtil.isEmptyOrNull((String)jid)) {
            item.setAccoutEmail(this.mCacheJidEmail.get(jid));
        }
        if (this.mFilter != null && this.mFilter.length() > 0) {
            String lowerEmail;
            Locale locale = CompatUtils.getLocalDefault();
            String lowerFilter = this.mFilter.toLowerCase(locale);
            String lowerName = name == null ? "" : name.toLowerCase(locale);
            String string2 = lowerEmail = email == null ? "" : email.toLowerCase(locale);
            if (!lowerName.contains(lowerFilter) && !lowerEmail.contains(lowerFilter)) {
                return null;
            }
        }
        if (buddy.isZoomRoom()) {
            return null;
        }
        if (this.mOnlySameOrganization && !messenger.isCompanyContact(jid)) {
            return null;
        }
        if (this.mFilterZoomRooms && (buddy.isZoomRoom() || messenger.isZoomRoomContact(buddy.getJid()))) {
            return null;
        }
        if (!this.mOnlyRobot && !this.mIncludeRobot && buddy.isRobot()) {
            return null;
        }
        if (this.mOnlyRobot && !buddy.isRobot()) {
            return null;
        }
        if (this.mOnlyRobot) {
            adapter.setmIsSlashCommand(this.mOnlyRobot);
        }
        adapter.setmIsShowEmail(this.mIsShowEmail);
        adapter.setmIsAlterHost(this.mIsAlterHost);
        MMSelectContactsListItem buddyItem = new MMSelectContactsListItem(item);
        MMSelectContactsListItem itemWithSameName = adapter.findFirstItemWithScreenName(name, 0);
        if (itemWithSameName != null) {
            itemWithSameName.setShowNotes(true);
            buddyItem.setShowNotes(true);
        }
        boolean isInSelectedItem = false;
        if (!this.mIsAlterHost) {
            if (this.mPreSelectedItems != null && !StringUtil.isEmptyOrNull((String)jid) && this.mPreSelectedItems.indexOf(jid) >= 0) {
                isInSelectedItem = true;
            }
        } else {
            int i = 0;
            for (MMSelectContactsListItem item1 : this.mSelectedItems) {
                if (item1.isAlternativeHost() && StringUtil.isSameStringForNotAllowNull((String)email, (String)item1.getEmail())) {
                    isInSelectedItem = true;
                    this.mSelectedItems.set(i, buddyItem);
                    break;
                }
                ++i;
            }
        }
        if (isInSelectedItem) {
            buddyItem.setIsDisabled(this.mIsDisabledForPreSelected);
            buddyItem.setIsChecked(true);
        } else {
            buddyItem.setIsChecked(this.isAddrBookItemSelected(item));
        }
        email = buddyItem.getEmail();
        if (this.mIsAlterHost && !StringUtil.isEmptyOrNull((String)email) && !CollectionsUtil.isCollectionEmpty(this.mHistoryEmails)) {
            this.mHistoryEmails.remove(email);
        }
        return buddyItem;
    }

    public void sort() {
        this.mAdapter.sort();
        this.mAdapter.notifyDataSetChanged();
    }

    public void setAvatarMemCache(MemCache<String, Bitmap> avatarCache) {
        this.mAdapter.setAvatarMemCache(avatarCache);
    }

    public void setParentFragment(MMSelectContactsFragment fragment) {
        this.mParentFragment = fragment;
    }

    public void setMaxSelectCount(int maxSelectCount) {
        this.mMaxSelectCount = maxSelectCount;
    }

    public void onClickEveryone() {
        if (this.mParentFragment != null) {
            this.mParentFragment.onClickEveryone();
        }
    }

    private boolean isBuddySelected(String itemId) {
        if (itemId == null) {
            return false;
        }
        for (MMSelectContactsListItem item : this.mSelectedItems) {
            if (!itemId.equals(item.itemId)) continue;
            return true;
        }
        return false;
    }

    private boolean isAddrBookItemSelected(IMAddrBookItem abItem) {
        if (abItem == null) {
            return false;
        }
        for (MMSelectContactsListItem item : this.mSelectedItems) {
            IMAddrBookItem abItemTmp = item.getAddrBookItem();
            if (abItemTmp == null || !StringUtil.isSameString((String)abItemTmp.getJid(), (String)abItem.getJid())) continue;
            return true;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            this._editmode_loadAllBuddyItems(this.mAdapter);
        }
        this.setAdapter(this.mAdapter);
        if (this.mLastTopPosition >= 0) {
            this.setSelectionFromTop(this.mLastTopPosition, 0);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        Parcelable superState = null;
        if (state instanceof Bundle) {
            Bundle allState = (Bundle)state;
            superState = allState.getParcelable("InviteBuddyListView.superState");
            this.mFilter = allState.getString("InviteBuddyListView.mFilter");
            this.mLastTopPosition = allState.getInt("InviteBuddyListView.topPosition", -1);
            this.updateViewMore();
        } else {
            superState = state;
        }
        super.onRestoreInstanceState(superState);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable("InviteBuddyListView.superState", superState);
        bundle.putString("InviteBuddyListView.mFilter", this.mFilter);
        bundle.putInt("InviteBuddyListView.topPosition", this.pointToPosition(10, 10));
        return bundle;
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode == 1 ? choiceMode : 0;
        this.mAdapter.setChoiceMode(this.mChoiceMode);
        if (this.isShown()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void initAddMoreFooter() {
        View footer = View.inflate((Context)this.getContext(), (int)R.layout.zm_search_view_more, null);
        this.mBtnSearchMore = (Button)footer.findViewById(R.id.btnSearchMore);
        this.mBtnSearchMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MMSelectContactsListView.this.mListener.onViewMoreClick();
            }
        });
        this.mBtnSearchMore.setVisibility(8);
        this.getListView().addFooterView(footer);
    }

    private void updateViewMore() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isConnectionGood()) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)this.mFilter) && this.mFilter.length() >= 3) {
            this.mBtnSearchMore.setVisibility(0);
        } else {
            this.mBtnSearchMore.setVisibility(8);
        }
    }

    public void setPreSelectedItems(List<String> itemIDs) {
        this.mPreSelectedItems = itemIDs;
    }

    public void setPreSelectedItems(List<String> preSelectedItems, boolean isAlterHost) {
        this.mIsAlterHost = isAlterHost;
        if (this.mAdapter != null) {
            this.mAdapter.setmIsAlterHost(this.mIsAlterHost);
        }
        if (isAlterHost) {
            ArrayList<String> emails = new ArrayList<String>();
            if (preSelectedItems != null && !preSelectedItems.isEmpty()) {
                Gson gson = new Gson();
                for (String str : preSelectedItems) {
                    SelectAlterHostItem selectAlterHostItem = (SelectAlterHostItem)gson.fromJson(str, SelectAlterHostItem.class);
                    MMSelectContactsListItem mmSelectContactsListItem = MMLocalHelper.transformSelectAlterHostToMMSelectContactsListItem(selectAlterHostItem);
                    this.addSelectedItem(mmSelectContactsListItem);
                    if (StringUtil.isEmptyOrNull((String)selectAlterHostItem.getEmail())) continue;
                    emails.add(selectAlterHostItem.getEmail());
                }
            }
            this.mPreSelectedItems = emails;
            this.mHistoryEmails = ConfLocalHelper.loadHistoryEmailsForAlterHosts();
        } else {
            this.mPreSelectedItems = preSelectedItems;
        }
    }

    public void setGroupId(String groupId, boolean hasAll) {
        this.mGroupId = groupId;
        if (!StringUtil.isEmptyOrNull((String)groupId) && hasAll) {
            this.mAdapter.setHasEveryone(true);
        } else {
            this.mAdapter.setHasEveryone(false);
        }
    }

    public void reloadAllBuddyItems() {
        long timeStart = System.currentTimeMillis();
        this.mAdapter.clear();
        this.loadAllBuddyItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void updateBuddyInfoWithJid(String jid) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            ZoomGroup group = messenger.getGroupById(this.mGroupId);
            if (group == null) {
                return;
            }
            int count = group.getBuddyCount();
            boolean isInGroup = false;
            for (int i = 0; i < count; ++i) {
                ZoomBuddy groupBuddy = group.getBuddyAt(i);
                if (groupBuddy == null || !StringUtil.isSameString((String)jid, (String)groupBuddy.getJid())) continue;
                isInGroup = true;
                break;
            }
            if (!isInGroup) {
                return;
            }
        }
        ABContactsCache cache = null;
        String myNumber = null;
        if (PTApp.getInstance().isPhoneNumberRegistered()) {
            cache = ABContactsCache.getInstance();
            ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
            if (contactsHelper != null) {
                myNumber = contactsHelper.getVerifiedPhoneNumber();
            }
        }
        this.mAdapter.removeItem(buddy.getJid());
        MMSelectContactsListItem item = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, this.mAdapter, false);
        if (item != null) {
            if (this.mIsAlterHost) {
                this.mAdapter.removeItemByEmail(buddy.getEmail());
            }
            this.mAdapter.addItem(item);
        }
        this.notifyDataSetChanged(true);
    }

    public void onIndicationZoomMessengerSearchBuddyByKeyForNoProgressDialog(String key, int result) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ABContactsCache cache = null;
        String myNumber = null;
        if (PTApp.getInstance().isPhoneNumberRegistered()) {
            cache = ABContactsCache.getInstance();
            ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
            if (contactsHelper != null) {
                myNumber = contactsHelper.getVerifiedPhoneNumber();
            }
        }
        this.mAutoWebSearchResult.clear();
        HashSet<String> buddies = new HashSet<String>();
        List<String> localBuddies = messenger.localStrictSearchBuddies(key, null);
        buddies.addAll(localBuddies);
        ZoomBuddySearchData searchData = messenger.getBuddySearchData();
        if (searchData == null) {
            return;
        }
        ZoomBuddySearchData.SearchKey searchKey = searchData.getSearchKey();
        ArrayList<String> webSearched = new ArrayList<String>();
        this.mAutoWebSearchResult.key = key;
        if (searchKey != null) {
            for (int i = 0; i < searchData.getBuddyCount(); ++i) {
                ZoomBuddy buddy = searchData.getBuddyAt(i);
                if (buddy == null) continue;
                String jid = buddy.getJid();
                String email = buddy.getEmail();
                if (this.mIsNeedHaveEmail && !StringUtil.isEmptyOrNull((String)jid) && !StringUtil.isEmptyOrNull((String)email)) {
                    this.mCacheJidEmail.put(jid, email);
                }
                webSearched.add(jid);
                MMSelectContactsListItem item = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, this.mAdapter, true);
                if (item == null) continue;
                if (this.mIsAlterHost) {
                    this.mAdapter.removeItemByEmail(buddy.getEmail());
                }
                this.mAutoWebSearchResult.putInviteBuddyItem(jid, item);
            }
            messenger.getBuddiesPresence(webSearched, false);
        }
        buddies.addAll(webSearched);
        ZoomBuddy mySelf = messenger.getMyself();
        if (mySelf != null) {
            for (String jid : buddies) {
                ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
                if (buddy == null) continue;
                MMSelectContactsListItem item = this.mAutoWebSearchResult.findByJid(jid);
                if (item == null) {
                    item = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, this.mAdapter, true);
                }
                if (item == null) continue;
                if (this.mIsAlterHost) {
                    this.mAdapter.removeItemByEmail(buddy.getEmail());
                }
                this.mAdapter.updateItem(item);
                if (this.mAdapter.getCount() < 250) continue;
                break;
            }
        }
        this.mAdapter.notifyDataSetChanged();
        this.mBtnSearchMore.setVisibility(8);
    }

    public void onIndicationZoomMessengerSearchBuddyByKey(String key, int result) {
        if (!StringUtil.isSameString((String)key, (String)this.mFilter)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ABContactsCache cache = null;
        String myNumber = null;
        if (PTApp.getInstance().isPhoneNumberRegistered()) {
            cache = ABContactsCache.getInstance();
            ABContactsHelper contactsHelper = PTApp.getInstance().getABContactsHelper();
            if (contactsHelper != null) {
                myNumber = contactsHelper.getVerifiedPhoneNumber();
            }
        }
        HashSet<String> buddies = new HashSet<String>();
        List<String> localBuddies = messenger.localStrictSearchBuddies(this.mFilter, null);
        buddies.addAll(localBuddies);
        ZoomBuddySearchData searchData = messenger.getBuddySearchData();
        if (searchData == null) {
            return;
        }
        ZoomBuddySearchData.SearchKey searchKey = searchData.getSearchKey();
        ArrayList<String> webSearched = new ArrayList<String>();
        this.mWebSearchResult.key = this.mFilter;
        if (searchKey != null && TextUtils.equals((CharSequence)searchData.getSearchKey().getKey(), (CharSequence)this.mFilter)) {
            for (int i = 0; i < searchData.getBuddyCount(); ++i) {
                ZoomBuddy buddy = searchData.getBuddyAt(i);
                if (buddy == null) continue;
                String jid = buddy.getJid();
                webSearched.add(jid);
                MMSelectContactsListItem item = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, this.mAdapter, true);
                if (item == null) continue;
                if (this.mIsAlterHost) {
                    this.mAdapter.removeItemByEmail(buddy.getEmail());
                }
                this.mWebSearchResult.putInviteBuddyItem(jid, item);
            }
            messenger.getBuddiesPresence(webSearched, false);
        }
        buddies.addAll(webSearched);
        ZoomBuddy mySelf = messenger.getMyself();
        if (mySelf != null) {
            for (String jid : buddies) {
                ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
                if (buddy == null) continue;
                MMSelectContactsListItem item = this.mWebSearchResult.findByJid(jid);
                if (item == null) {
                    item = this.newItemFromZoomBuddy(messenger, buddy, myNumber, cache, this.mAdapter, true);
                }
                if (item == null) continue;
                if (this.mIsAlterHost) {
                    this.mAdapter.removeItemByEmail(buddy.getEmail());
                }
                this.mAdapter.updateItem(item);
                if (this.mAdapter.getCount() < 250) continue;
                break;
            }
        }
        this.mAdapter.notifyDataSetChanged();
        this.mBtnSearchMore.setVisibility(8);
    }

    public void clearSelection() {
        this.mSelectedItems.clear();
        for (int index = 0; index < this.mAdapter.getCount(); ++index) {
            Object obj = this.mAdapter.getItem(index);
            if (!(obj instanceof MMSelectContactsListItem)) continue;
            MMSelectContactsListItem item = (MMSelectContactsListItem)obj;
            item.setIsChecked(false);
            this.mAdapter.notifyDataSetChanged();
        }
        if (this.mListener != null) {
            this.mListener.onSelectionChanged();
        }
    }

    public List<MMSelectContactsListItem> getSelectedBuddies() {
        return this.mSelectedItems;
    }

    public void unselectBuddy(MMSelectContactsListItem item) {
        if (item != null) {
            MMSelectContactsListItem listItem = this.mAdapter.getItemById(item.itemId);
            if (listItem == null && this.mIsAlterHost) {
                listItem = this.mAdapter.getItemByEmail(item.email);
            }
            if (listItem != null) {
                listItem.setIsChecked(false);
                this.mAdapter.notifyDataSetChanged();
            }
            this.removeSelectedItem(item);
            if (this.mListener != null) {
                this.mListener.onSelectionChanged();
            }
        }
    }

    public void filter(String filter) {
        if (filter == null) {
            filter = "";
        }
        filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        String oldFilter = this.mFilter;
        this.mFilter = filter;
        if (oldFilter == null) {
            oldFilter = "";
        }
        if (oldFilter.equals(filter)) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)this.mGroupId)) {
            this.mWebSearchResult.clear();
            this.updateViewMore();
            this.reloadAllBuddyItems();
        } else if (!StringUtil.isEmptyOrNull((String)filter)) {
            if (StringUtil.isEmptyOrNull((String)oldFilter) || !StringUtil.isEmptyOrNull((String)oldFilter) && filter.contains(oldFilter)) {
                this.mAdapter.filter(filter);
                this.mAdapter.notifyDataSetChanged();
            } else {
                this.reloadAllBuddyItems();
            }
        } else {
            this.mAdapter.filter(null);
            this.reloadAllBuddyItems();
        }
        if (this.mIsAutoWebSearch && this.mAdapter.isEmpty()) {
            this.mBtnSearchMore.setVisibility(8);
            MMLocalHelper.searchBuddyByKey(this.mFilter);
        }
        if (this.mIsAlterHost && !this.mAdapter.isEmpty()) {
            this.mHandler.removeCallbacks(this.mLoadEmailsRunnable);
            this.mHandler.postDelayed(this.mLoadEmailsRunnable, 300L);
        }
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object obj = this.getItemAtPosition(position);
        if (!(obj instanceof MMSelectContactsListItem)) {
            return;
        }
        MMSelectContactsListItem item = (MMSelectContactsListItem)obj;
        if (!item.isDisabled()) {
            if (!item.isChecked() && this.mMaxSelectCount > 0) {
                int selectCount = 0;
                if (this.mPreSelectedItems != null) {
                    selectCount = this.mPreSelectedItems.size();
                }
                if (this.mSelectedItems.size() + selectCount >= this.mMaxSelectCount) {
                    if (this.mListener != null) {
                        this.mListener.onSelectCountReachMax();
                    }
                    return;
                }
            }
            if (this.mIsAlterHost && StringUtil.isEmptyOrNull((String)item.getEmail())) {
                ZoomMessenger zoomMessenger = MMLocalHelper.getGoodConnectedZoomMessenger();
                if (zoomMessenger != null) {
                    zoomMessenger.refreshBuddyVCard(item.getBuddyJid(), true);
                }
                return;
            }
            item.setIsChecked(!item.isChecked());
            this.mAdapter.notifyDataSetChanged();
            if (item.isChecked()) {
                this.addSelectedItem(item);
            } else {
                this.removeSelectedItem(item);
            }
            if (this.mListener != null) {
                this.mListener.onSelectionChanged();
            }
        }
    }

    public void stop() {
        this.mHandler.removeCallbacks(this.mLoadEmailsRunnable);
    }

    private void removeSelectedItem(MMSelectContactsListItem item) {
        for (int i = this.mSelectedItems.size() - 1; i >= 0; --i) {
            MMSelectContactsListItem tmpItem = this.mSelectedItems.get(i);
            if (!MMLocalHelper.isSameMMSelectContactsListItem(this.mIsAlterHost, item, tmpItem)) continue;
            this.mSelectedItems.remove(i);
            if (this.mListener == null) break;
            this.mListener.onSelected(false, item);
            break;
        }
    }

    public void addSelectedItem(MMSelectContactsListItem item) {
        item.setIsChecked(true);
        for (int i = this.mSelectedItems.size() - 1; i >= 0; --i) {
            MMSelectContactsListItem tmpItem = this.mSelectedItems.get(i);
            if (!MMLocalHelper.isSameMMSelectContactsListItem(this.mIsAlterHost, item, tmpItem)) continue;
            this.mSelectedItems.set(i, item);
            return;
        }
        this.mSelectedItems.add(item);
        if (this.mListener != null) {
            this.mListener.onSelected(true, item);
        }
        if (this.mIsNeedSortSelectedItems) {
            Collections.sort(this.mSelectedItems, new MMBuddyItemComparator(CompatUtils.getLocalDefault()));
        }
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            this.mRetainedFragment.saveSelectedItems(this.mSelectedItems);
            this.mRetainedFragment.saveWebSearchResult(this.mWebSearchResult);
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        } else {
            WebSearchResult oldSearchResult;
            List<MMSelectContactsListItem> oldItems = this.mRetainedFragment.restoreSelectedItems();
            if (oldItems != null) {
                this.mSelectedItems = oldItems;
            }
            if ((oldSearchResult = this.mRetainedFragment.restoreWebSearchResult()) != null) {
                this.mWebSearchResult = oldSearchResult;
            }
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        return (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
    }

    public void notifyDataSetChanged(boolean disableLazyLoadAvatar) {
        if (disableLazyLoadAvatar) {
            this.mAdapter.setLazyLoadAvatarDisabled(true);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MMSelectContactsListView.this.mAdapter.setLazyLoadAvatarDisabled(false);
                }
            }, 1000L);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void setOnlySameOrganization(boolean onlySameOrganization) {
        this.mOnlySameOrganization = onlySameOrganization;
    }

    public void setIncludeRobot(boolean includeRobot) {
        this.mIncludeRobot = includeRobot;
    }

    public void setmOnlyRobot(boolean mOnlyRobot) {
        this.mOnlyRobot = mOnlyRobot;
        if (this.mAdapter != null) {
            this.mAdapter.setmIsSlashCommand(mOnlyRobot);
        }
    }

    public void setmFilterZoomRooms(boolean filterZoomRooms) {
        this.mFilterZoomRooms = filterZoomRooms;
    }

    public void setmIsShowEmail(boolean isShowEmail) {
        this.mIsShowEmail = isShowEmail;
        if (this.mAdapter != null) {
            this.mAdapter.setmIsShowEmail(isShowEmail);
        }
    }

    public void setmIsDisabledForPreSelected(boolean mIsDisabledForPreSelected) {
        this.mIsDisabledForPreSelected = mIsDisabledForPreSelected;
    }

    public void setmIsNeedHaveEmail(boolean mIsNeedHaveEmail) {
        this.mIsNeedHaveEmail = mIsNeedHaveEmail;
    }

    public void setmIsNeedSortSelectedItems(boolean mIsNeedSortSelectedItems) {
        this.mIsNeedSortSelectedItems = mIsNeedSortSelectedItems;
    }

    public void setmIsAutoWebSearch(boolean mIsAutoWebSearch) {
        this.mIsAutoWebSearch = mIsAutoWebSearch;
    }

    static class WebSearchResult {
        String key;
        Map<String, MMSelectContactsListItem> results = new HashMap<String, MMSelectContactsListItem>();

        WebSearchResult() {
        }

        public MMSelectContactsListItem findByJid(String jid) {
            return this.results.get(jid);
        }

        public Set<String> getAllJids() {
            return this.results.keySet();
        }

        public void putInviteBuddyItem(String jid, MMSelectContactsListItem item) {
            this.results.put(jid, item);
        }

        public void clear() {
            this.key = null;
            this.results.clear();
        }
    }

    public static class RetainedFragment
    extends ZMFragment {
        private List<MMSelectContactsListItem> mSelectedItems = null;
        private WebSearchResult mWebSearchResult = null;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }

        public void saveSelectedItems(List<MMSelectContactsListItem> items) {
            this.mSelectedItems = items;
        }

        public List<MMSelectContactsListItem> restoreSelectedItems() {
            return this.mSelectedItems;
        }

        public void saveWebSearchResult(WebSearchResult items) {
            this.mWebSearchResult = items;
        }

        public WebSearchResult restoreWebSearchResult() {
            return this.mWebSearchResult;
        }
    }

    public static interface Listener {
        public void onSelectionChanged();

        public void onViewMoreClick();

        public void onSelectCountReachMax();

        public void onSelected(boolean var1, MMSelectContactsListItem var2);
    }
}

