/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.util.GroupAvatarDrawable_v2;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.mm.MMBuddyItemComparator;
import com.zipow.videobox.view.mm.MMSelectContactsListItem;
import com.zipow.videobox.view.mm.MMSelectContactsListItemView;
import com.zipow.videobox.view.mm.MMSelectContactsListView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.videomeetings.R;

public class MMSelectContactsListAdapter
extends QuickSearchListView.QuickSearchListDataAdapter {
    private static final int ITEM_TYPE_NORMAL = 0;
    private static final int ITEM_TYPE_EVERYONE = 1;
    private static final int ITEM_TYPE_SLASH_COMMAND = 2;
    private static final int ITEM_TYPE_ALL_COUNT = 3;
    private List<MMSelectContactsListItem> mItems = new ArrayList<MMSelectContactsListItem>();
    private Context mContext;
    private MemCache<String, Bitmap> mAvatarCache;
    private int mChoiceMode = 0;
    private boolean mLazyLoadAvatarDisabled = false;
    private boolean mContainsEveryOne = false;
    private boolean mIsSlashCommand = false;
    private boolean mIsShowEmail = false;
    private boolean mIsAlterHost = false;
    private String mFilter;
    private MMSelectContactsListView mSelectContactsListView;

    public MMSelectContactsListAdapter(Context context, MMSelectContactsListView listView) {
        assert (context != null);
        this.mContext = context;
        this.mSelectContactsListView = listView;
    }

    public void setAvatarMemCache(MemCache<String, Bitmap> avatarCache) {
        this.mAvatarCache = avatarCache;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
    }

    public void addItem(MMSelectContactsListItem item) {
        if (item == null) {
            return;
        }
        this.mItems.add(item);
    }

    public void setHasEveryone(boolean hasEveryone) {
        this.mContainsEveryOne = hasEveryone;
    }

    public void setmIsSlashCommand(boolean mIsSlashCommand) {
        this.mIsSlashCommand = mIsSlashCommand;
    }

    public void updateItem(MMSelectContactsListItem item) {
        assert (item != null);
        int position = this.findItem(item.itemId);
        if (position >= 0) {
            this.mItems.set(position, item);
        } else {
            this.mItems.add(item);
        }
    }

    public int findItem(String itemId) {
        if (itemId == null) {
            return -1;
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            MMSelectContactsListItem item = this.mItems.get(i);
            if (!itemId.equals(item.itemId)) continue;
            return i;
        }
        return -1;
    }

    public int findItemByEmail(String email) {
        if (email == null) {
            return -1;
        }
        for (int i = 0; i < this.mItems.size(); ++i) {
            MMSelectContactsListItem item = this.mItems.get(i);
            if (!StringUtil.isSameStringForNotAllowNull((String)email, (String)item.getEmail())) continue;
            return i;
        }
        return -1;
    }

    public void removeItem(String itemId) {
        int position = this.findItem(itemId);
        if (position >= 0) {
            this.removeItemAt(position);
        }
    }

    public void removeItemByEmail(String email) {
        int position = this.findItemByEmail(email);
        if (position >= 0) {
            this.removeItemAt(position);
        }
    }

    public void removeItemAt(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(position);
    }

    public MMSelectContactsListItem findFirstItemWithScreenName(String screenName, int fromIdx) {
        if (screenName == null || fromIdx < 0) {
            return null;
        }
        for (int i = fromIdx; i < this.mItems.size(); ++i) {
            MMSelectContactsListItem item = this.mItems.get(i);
            if (!screenName.equals(item.screenName)) continue;
            return item;
        }
        return null;
    }

    public int getCount() {
        int count = this.mItems.size();
        if (this.mContainsEveryOne && StringUtil.isEmptyOrNull((String)this.mFilter)) {
            ++count;
        }
        return count;
    }

    public Object getItem(int position) {
        if (this.mContainsEveryOne && StringUtil.isEmptyOrNull((String)this.mFilter)) {
            --position;
        }
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public MMSelectContactsListItem getItemById(String itemId) {
        if (StringUtil.isEmptyOrNull((String)itemId)) {
            return null;
        }
        for (MMSelectContactsListItem item : this.mItems) {
            if (!itemId.equals(item.itemId)) continue;
            return item;
        }
        return null;
    }

    public MMSelectContactsListItem getItemByEmail(String email) {
        if (StringUtil.isEmptyOrNull((String)email)) {
            return null;
        }
        for (MMSelectContactsListItem item : this.mItems) {
            if (!StringUtil.isSameStringForNotAllowNull((String)email, (String)item.getEmail())) continue;
            return item;
        }
        return null;
    }

    public long getItemId(int position) {
        MMSelectContactsListItem item = (MMSelectContactsListItem)this.getItem(position);
        return item.itemId.hashCode();
    }

    public int getItemViewType(int position) {
        if (this.mIsSlashCommand) {
            return 2;
        }
        if (position == 0 && this.mContainsEveryOne && StringUtil.isEmptyOrNull((String)this.mFilter)) {
            return 1;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public void filter(String filter) {
        this.mFilter = filter;
        if (StringUtil.isEmptyOrNull((String)filter)) {
            return;
        }
        Locale locale = CompatUtils.getLocalDefault();
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            boolean emailAccepted;
            MMSelectContactsListItem item = this.mItems.get(i);
            boolean nameAccepted = item.screenName != null && item.screenName.toLowerCase(locale).contains(filter);
            boolean bl = emailAccepted = item.email != null && item.email.toLowerCase(locale).contains(filter);
            if (nameAccepted || emailAccepted) continue;
            this.mItems.remove(i);
        }
    }

    public void setLazyLoadAvatarDisabled(boolean disabled) {
        this.mLazyLoadAvatarDisabled = disabled;
    }

    public void setmIsShowEmail(boolean mIsShowEmail) {
        this.mIsShowEmail = mIsShowEmail;
    }

    public void setmIsAlterHost(boolean mIsAlterHost) {
        this.mIsAlterHost = mIsAlterHost;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        View view = null;
        int type = this.getItemViewType(position);
        switch (type) {
            case 0: {
                view = this.createNormalItemView(position, convertView, parent, this.mLazyLoadAvatarDisabled, this.mIsShowEmail, this.mIsAlterHost);
                break;
            }
            case 1: {
                view = this.createEveryoneItemView(position, convertView, parent);
                break;
            }
            case 2: {
                view = this.createSlashCommandItemView(position, convertView, parent, this.mLazyLoadAvatarDisabled);
            }
        }
        return view;
    }

    private View createEveryoneItemView(int position, View convertView, ViewGroup parent) {
        MMSelectContactsListItemView view;
        if (convertView == null) {
            view = new MMSelectContactsListItemView(this.mContext);
            view.setHidePresencePanel(true);
            view.setCheckVisible(false);
            view.setContactsDesc(this.mContext.getString(R.string.zm_lbl_notify_everyone));
        } else {
            view = (MMSelectContactsListItemView)convertView;
        }
        view.setNotes(null, this.mIsAlterHost);
        view.setScreenName(this.mContext.getString(R.string.zm_lbl_select_everyone));
        view.setAvatar(new GroupAvatarDrawable_v2(null));
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MMSelectContactsListAdapter.this.mSelectContactsListView != null) {
                    MMSelectContactsListAdapter.this.mSelectContactsListView.onClickEveryone();
                }
            }
        });
        return view;
    }

    private View createSlashCommandItemView(int position, View convertView, ViewGroup parent, boolean disableLazyLoadAvatar) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        MMSelectContactsListItem item = (MMSelectContactsListItem)this.getItem(position);
        boolean showCheck = this.mChoiceMode == 0;
        boolean showPresence = this.mChoiceMode == 1;
        return item.getView(this.mContext, convertView, showCheck, showPresence, this.mAvatarCache, disableLazyLoadAvatar, true, false);
    }

    private View createNormalItemView(int position, View convertView, ViewGroup parent, boolean disableLazyLoadAvatar, boolean isShowEmail, boolean isShowLoading) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        MMSelectContactsListItem item = (MMSelectContactsListItem)this.getItem(position);
        boolean showCheck = this.mChoiceMode == 0;
        boolean showPresence = this.mChoiceMode == 1;
        return item.getView(this.mContext, convertView, showCheck, showPresence, this.mAvatarCache, disableLazyLoadAvatar, isShowEmail, isShowLoading);
    }

    public void sort() {
        Collections.sort(this.mItems, new MMBuddyItemComparator(CompatUtils.getLocalDefault()));
    }

    public String getItemSortKey(Object item) {
        if (item instanceof MMSelectContactsListItem) {
            MMSelectContactsListItem inItem = (MMSelectContactsListItem)item;
            String key = inItem.sortKey;
            if (StringUtil.isEmptyOrNull((String)key)) {
                key = inItem.email;
            }
            if (key == null) {
                key = "";
            }
            return key;
        }
        return "";
    }
}

